/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.interfaces;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.biome.api.data.BiomeDataRegistry;
import org.betterx.wover.state.api.WorldState;
import org.betterx.wover.surface.api.SurfaceRuleBuilder;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.jetbrains.annotations.Nullable;

public interface SurfaceMaterialProvider {
    public static final MapCodec<SurfaceMaterialProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockState.CODEC.fieldOf("top").forGetter(SurfaceMaterialProvider::getTopMaterial), (App)BlockState.CODEC.fieldOf("under").forGetter(SurfaceMaterialProvider::getUnderMaterial), (App)BlockState.CODEC.fieldOf("alt").forGetter(SurfaceMaterialProvider::getAltTopMaterial), (App)Codec.BOOL.fieldOf("floor_rule").forGetter(SurfaceMaterialProvider::generateFloorRule)).apply((Applicative)instance, SurfaceMaterialProvider::create));

    public static SurfaceMaterialProvider create(final BlockState top, final BlockState under, final BlockState alt, final boolean genFloorRule) {
        return new SurfaceMaterialProvider(){

            @Override
            public BlockState getTopMaterial() {
                return top;
            }

            @Override
            public BlockState getUnderMaterial() {
                return under;
            }

            @Override
            public BlockState getAltTopMaterial() {
                return alt;
            }

            @Override
            public boolean generateFloorRule() {
                return genFloorRule;
            }

            @Override
            public SurfaceRuleBuilder surface() {
                return null;
            }
        };
    }

    public BlockState getTopMaterial();

    public BlockState getUnderMaterial();

    public BlockState getAltTopMaterial();

    public boolean generateFloorRule();

    public SurfaceRuleBuilder surface();

    default public void addBiomeSurfaceToEndGroup(TagBootstrapContext<Block> context, TagKey<Block> groundTag) {
        context.add(groundTag, (Object[])new Block[]{this.getTopMaterial().getBlock()});
        context.add(groundTag, (Object[])new Block[]{this.getAltTopMaterial().getBlock()});
        context.add(groundTag, (Object[])new Block[]{this.getUnderMaterial().getBlock()});
    }

    public static Optional<SurfaceMaterialProvider> findSurfaceMaterialProvider(WorldGenLevel world, BlockPos pos) {
        return SurfaceMaterialProvider.findSurfaceMaterialProvider((Holder<Biome>)world.getBiome(pos));
    }

    public static Optional<SurfaceMaterialProvider> findSurfaceMaterialProvider(@Nullable Holder<Biome> biome) {
        BiomeData data;
        if (biome != null && (data = (BiomeData)((Registry)WorldState.registryAccess().registry(BiomeDataRegistry.BIOME_DATA_REGISTRY).orElseThrow()).get(((ResourceKey)biome.unwrapKey().orElseThrow()).location())) instanceof SurfaceMaterialProvider) {
            SurfaceMaterialProvider smp = (SurfaceMaterialProvider)data;
            return Optional.of(smp);
        }
        return Optional.empty();
    }
}

