/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.interfaces;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public interface AirSelectionItem {
    default public boolean renderAirSelection() {
        return true;
    }

    default public int airSelectionColor() {
        return -1074333072;
    }

    default public BlockHitResult getAirSelectionHit(Level level, Player player) {
        if (this.renderAirSelection()) {
            Vec3 vec = new Vec3(0.0, 0.0, 1.0).xRot(-player.getXRot() * ((float)Math.PI / 180)).yRot(-player.getYHeadRot() * ((float)Math.PI / 180));
            return level.isBlockInLine(new ClipBlockStateContext(player.getEyePosition(), player.getEyePosition().add(vec.scale(4.9)), BlockBehaviour.BlockStateBase::isAir));
        }
        return null;
    }

    default public InteractionResultHolder<ItemStack> useOnAir(Level level, Player player, InteractionHand interactionHand) {
        BlockHitResult hit = this.getAirSelectionHit(level, player);
        if (hit != null) {
            InteractionResult result = this.useOn(new UseOnContext(player, interactionHand, hit));
            if (result == InteractionResult.SUCCESS) {
                return InteractionResultHolder.success((Object)player.getItemInHand(interactionHand));
            }
            if (result == InteractionResult.FAIL) {
                return InteractionResultHolder.fail((Object)player.getItemInHand(interactionHand));
            }
            if (result == InteractionResult.PASS) {
                return InteractionResultHolder.pass((Object)player.getItemInHand(interactionHand));
            }
            if (result == InteractionResult.CONSUME) {
                return InteractionResultHolder.consume((Object)player.getItemInHand(interactionHand));
            }
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(interactionHand));
    }

    public InteractionResult useOn(UseOnContext var1);
}

