/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import org.betterx.bclib.integration.emi.EMIPlugin;

public abstract class EMIAbstractAlloyingRecipe<C extends RecipeInput, T extends Recipe<C>>
implements EmiRecipe {
    private final ResourceLocation id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;
    protected final T recipe;
    private final int fuelMultiplier;
    private final boolean infiniBurn;

    public EMIAbstractAlloyingRecipe(RecipeHolder<T> recipe, ResourceLocation id, int fuelMultiplier, boolean infiniBurn) {
        this.recipe = recipe.value();
        this.id = id;
        this.input = List.of(EmiIngredient.of((Ingredient)((Ingredient)this.recipe.getIngredients().get(0))), this.recipe.getIngredients().size() > 1 ? EmiIngredient.of((Ingredient)((Ingredient)this.recipe.getIngredients().get(1))) : EmiIngredient.of((Ingredient)Ingredient.EMPTY));
        this.output = List.of(EmiStack.of((ItemStack)this.recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())));
        this.fuelMultiplier = fuelMultiplier;
        this.infiniBurn = infiniBurn;
    }

    protected abstract int getSmeltTime();

    protected abstract float getExperience();

    public EmiRecipeCategory getCategory() {
        return EMIPlugin.END_ALLOYING_CATEGORY;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    protected int getXOffset() {
        return 22;
    }

    public int getDisplayWidth() {
        return 82 + this.getXOffset();
    }

    public int getDisplayHeight() {
        return 38;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addFillingArrow(24 + this.getXOffset(), 5, 50 * this.getSmeltTime()).tooltip((mx, my) -> List.of(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)"emi.cooking.time", (Object[])new Object[]{Float.valueOf((float)this.getSmeltTime() / 20.0f)}).getVisualOrderText())));
        if (this.infiniBurn) {
            widgets.addTexture(EmiTexture.FULL_FLAME, 1, 24);
        } else {
            widgets.addTexture(EmiTexture.EMPTY_FLAME, 1, 24);
            widgets.addAnimatedTexture(EmiTexture.FULL_FLAME, 1, 24, 4000 / this.fuelMultiplier, false, true, true);
        }
        widgets.addSlot(this.input.get(0), 0, 4);
        widgets.addSlot(this.input.size() > 1 ? this.input.get(1) : null, 20, 4);
        widgets.addText(Component.translatable((String)"emi.cooking.experience", (Object[])new Object[]{Float.valueOf(this.getExperience())}).getVisualOrderText(), 24 + this.getXOffset(), 28, -1, true);
        widgets.addSlot((EmiIngredient)this.output.get(0), 56 + this.getXOffset(), 0).large(true).recipeContext((EmiRecipe)this);
    }

    public boolean supportsRecipeTree() {
        return true;
    }
}

