/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.complexmaterials;

import java.util.function.Consumer;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.complexmaterials.BCLWoodTypeWrapper;
import org.betterx.bclib.complexmaterials.ComplexMaterialSet;
import org.betterx.bclib.complexmaterials.entry.SlotMap;
import org.betterx.bclib.complexmaterials.set.wood.WoodSlots;
import org.betterx.bclib.items.boat.BoatTypeOverride;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.tag.api.TagManager;
import org.jetbrains.annotations.Nullable;

public class WoodenComplexMaterial
extends ComplexMaterialSet<WoodenComplexMaterial> {
    public static final ResourceLocation MATERIAL_ID = BCLib.makeID("wooden_material");
    public static final String BLOCK_CRAFTING_TABLE = WoodSlots.CRAFTING_TABLE.suffix;
    public static final String BLOCK_STRIPPED_BARK = WoodSlots.STRIPPED_BARK.suffix;
    public static final String BLOCK_STRIPPED_LOG = WoodSlots.STRIPPED_LOG.suffix;
    public static final String BLOCK_PRESSURE_PLATE = WoodSlots.PRESSURE_PLATE.suffix;
    public static final String BLOCK_BOOKSHELF = WoodSlots.BOOKSHELF.suffix;
    public static final String BLOCK_COMPOSTER = WoodSlots.COMPOSTER.suffix;
    public static final String BLOCK_TRAPDOOR = WoodSlots.TRAPDOOR.suffix;
    public static final String BLOCK_BARREL = WoodSlots.BARREL.suffix;
    public static final String BLOCK_BUTTON = WoodSlots.BUTTON.suffix;
    public static final String BLOCK_LADDER = WoodSlots.LADDER.suffix;
    public static final String BLOCK_PLANKS = WoodSlots.PLANKS.suffix;
    public static final String BLOCK_STAIRS = WoodSlots.STAIRS.suffix;
    public static final String BLOCK_CHEST = WoodSlots.CHEST.suffix;
    public static final String BLOCK_FENCE = WoodSlots.FENCE.suffix;
    public static final String BLOCK_BARK = WoodSlots.BARK.suffix;
    public static final String BLOCK_DOOR = WoodSlots.DOOR.suffix;
    public static final String BLOCK_GATE = WoodSlots.GATE.suffix;
    public static final String BLOCK_SIGN = WoodSlots.SIGN.suffix;
    public static final String BLOCK_WALL_SIGN = "wall_sign";
    public static final String BLOCK_SLAB = WoodSlots.SLAB.suffix;
    public static final String BLOCK_LOG = WoodSlots.LOG.suffix;
    public static final String ITEM_BOAT = WoodSlots.BOAT.suffix;
    public static final String ITEM_CHEST_BOAT = WoodSlots.CHEST_BOAT.suffix;
    public static final String TAG_LOGS = "logs";
    public final MapColor planksColor;
    public final MapColor woodColor;
    @Nullable
    protected BoatTypeOverride boatType;
    public final BCLWoodTypeWrapper woodType;
    protected Block clothMaterial;

    public WoodenComplexMaterial(ModCore modCore, String baseName, String receipGroupPrefix, MapColor woodColor, MapColor planksColor) {
        super(modCore, baseName, receipGroupPrefix);
        this.planksColor = planksColor;
        this.woodColor = woodColor;
        this.woodType = this.createWoodTypeBuilder().build();
    }

    @Deprecated(forRemoval=true)
    public WoodenComplexMaterial(ModCore modCore, String baseName, String receipGroupPrefix, MapColor woodColor, MapColor planksColor, BoatTypeOverride boatType) {
        this(modCore, baseName, receipGroupPrefix, woodColor, planksColor);
        this.setBoatType(boatType);
    }

    public <W extends WoodenComplexMaterial> W setBoatType(BoatTypeOverride boatType) {
        this.boatType = boatType;
        return (W)this;
    }

    public <W extends WoodenComplexMaterial> W setFurnitureCloth(Block clothMaterial) {
        this.clothMaterial = clothMaterial;
        return (W)this;
    }

    public Block furnitureCloth() {
        return this.clothMaterial;
    }

    public Block furnitureFrame() {
        return this.getBlock(WoodSlots.PLANKS);
    }

    protected BCLWoodTypeWrapper.Builder createWoodTypeBuilder() {
        return BCLWoodTypeWrapper.create(this.C, this.getBaseName()).setColor(this.planksColor);
    }

    @Override
    protected BlockBehaviour.Properties getBlockSettings() {
        return FabricBlockSettings.copyOf((BlockBehaviour)Blocks.OAK_PLANKS).mapColor(this.planksColor);
    }

    @Override
    public ResourceLocation getMaterialID() {
        return MATERIAL_ID;
    }

    @Override
    protected void initTags() {
        this.addBlockTag((TagKey<Block>)TagManager.BLOCKS.makeTag(this.C, this.getBaseName() + "_logs"));
        this.addItemTag((TagKey<Item>)TagManager.ITEMS.makeTag(this.C, this.getBaseName() + "_logs"));
    }

    @Override
    protected SlotMap<WoodenComplexMaterial> createMaterialSlots() {
        return SlotMap.of(WoodSlots.STRIPPED_LOG, WoodSlots.STRIPPED_BARK, WoodSlots.LOG, WoodSlots.BARK, WoodSlots.PLANKS, WoodSlots.STAIRS, WoodSlots.SLAB, WoodSlots.FENCE, WoodSlots.GATE, WoodSlots.BUTTON, WoodSlots.PRESSURE_PLATE, WoodSlots.TRAPDOOR, WoodSlots.DOOR, WoodSlots.LADDER, WoodSlots.SIGN, WoodSlots.CHEST, WoodSlots.BARREL, WoodSlots.CRAFTING_TABLE, WoodSlots.BOOKSHELF, WoodSlots.COMPOSTER);
    }

    @Override
    protected void initFlammable(FlammableBlockRegistry registry) {
        Consumer<Block> addFlammableHardWood = block -> registry.add(block, 5, 5);
        this.getBlocks().forEach(block -> registry.add(block, 5, 20));
        this.ifBlockPresent(WoodSlots.LOG, addFlammableHardWood);
        this.ifBlockPresent(WoodSlots.BARK, addFlammableHardWood);
        this.ifBlockPresent(WoodSlots.STRIPPED_LOG, addFlammableHardWood);
        this.ifBlockPresent(WoodSlots.STRIPPED_BARK, addFlammableHardWood);
    }

    public final void initBoatType() {
        if (this.getBoatType() == null) {
            this.boatType = this.supplyBoatType();
        }
    }

    protected BoatTypeOverride supplyBoatType() {
        return BoatTypeOverride.create(this.C, this.getBaseName(), this.getBlock(WoodSlots.PLANKS));
    }

    public BoatTypeOverride getBoatType() {
        return this.boatType;
    }
}

