/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.complexmaterials;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.betterx.bclib.complexmaterials.entry.BlockEntry;
import org.betterx.bclib.complexmaterials.entry.ItemEntry;
import org.betterx.bclib.complexmaterials.entry.MaterialSlot;
import org.betterx.bclib.complexmaterials.entry.RecipeEntry;
import org.betterx.wover.block.api.BlockRegistry;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.item.api.ItemRegistry;
import org.jetbrains.annotations.Nullable;

public abstract class ComplexMaterial {
    private static final Map<ResourceLocation, List<RecipeEntry>> RECIPE_ENTRIES = Maps.newHashMap();
    private static final Map<ResourceLocation, List<BlockEntry>> BLOCK_ENTRIES = Maps.newHashMap();
    private static final Map<ResourceLocation, List<ItemEntry>> ITEM_ENTRIES = Maps.newHashMap();
    private static final List<ComplexMaterial> MATERIALS = Lists.newArrayList();
    private final List<RecipeEntry> defaultRecipeEntries = Lists.newArrayList();
    private final List<BlockEntry> defaultBlockEntries = Lists.newArrayList();
    private final List<ItemEntry> defaultItemEntries = Lists.newArrayList();
    private final Map<String, TagKey<Block>> blockTags = Maps.newHashMap();
    private final Map<String, TagKey<Item>> itemTags = Maps.newHashMap();
    private final Map<String, Block> blocks = Maps.newHashMap();
    private final Map<String, Item> items = Maps.newHashMap();
    protected final String baseName;
    public final ModCore C;
    protected final String receipGroupPrefix;

    public ComplexMaterial(ModCore modID, String baseName, String receipGroupPrefix) {
        this.baseName = baseName;
        this.C = modID;
        this.receipGroupPrefix = receipGroupPrefix;
        MATERIALS.add(this);
    }

    public ComplexMaterial init(BlockRegistry blocksRegistry, ItemRegistry itemsRegistry) {
        this.initTags();
        BlockBehaviour.Properties blockSettings = this.getBlockSettings();
        Item.Properties itemSettings = this.getItemSettings(itemsRegistry);
        this.initDefault(blockSettings, itemSettings);
        this.getBlockEntries().forEach(entry -> {
            Block block = entry.init(this, blockSettings, blocksRegistry);
            this.blocks.put(entry.getSuffix(), block);
        });
        this.getItemEntries().forEach(entry -> {
            Item item = entry.init(this, itemSettings, itemsRegistry);
            this.items.put(entry.getSuffix(), item);
        });
        this.initFlammable(FlammableBlockRegistry.getDefaultInstance());
        return this;
    }

    private void provideRecipes(RecipeOutput context) {
        this.initDefaultRecipes();
        this.getRecipeEntries().forEach(entry -> entry.init(context, this));
    }

    public static void provideAllRecipes(RecipeOutput context, ModCore modCore) {
        MATERIALS.stream().filter(m -> m.C == modCore).forEach(material -> material.provideRecipes(context));
    }

    protected abstract void initDefault(BlockBehaviour.Properties var1, Item.Properties var2);

    protected void initTags() {
    }

    protected void initDefaultRecipes() {
    }

    protected void initFlammable(FlammableBlockRegistry registry) {
    }

    protected void addBlockTag(TagKey<Block> tag) {
        String key = tag.location().getPath().replace(this.getBaseName() + "_", "");
        this.blockTags.put(key, tag);
    }

    protected void addItemTag(TagKey<Item> tag) {
        String key = tag.location().getPath().replace(this.getBaseName() + "_", "");
        this.itemTags.put(key, tag);
    }

    @Nullable
    public TagKey<Block> getBlockTag(String key) {
        return this.blockTags.get(key);
    }

    @Nullable
    public TagKey<Item> getItemTag(String key) {
        return this.itemTags.get(key);
    }

    @Nullable
    public Block getBlock(String key) {
        return this.blocks.get(key);
    }

    @Nullable
    public Block ifBlockPresent(String key, Consumer<Block> runIfPresent) {
        Block block = this.blocks.get(key);
        if (block != null) {
            runIfPresent.accept(block);
        }
        return block;
    }

    @Nullable
    public <M extends ComplexMaterial> Block ifBlockPresent(MaterialSlot<M> slot, Consumer<Block> runIfPresent) {
        Block block = this.blocks.get(slot.suffix);
        if (block != null) {
            runIfPresent.accept(block);
        }
        return block;
    }

    @Nullable
    public <M extends ComplexMaterial> Block getBlock(MaterialSlot<M> key) {
        return this.blocks.get(key.suffix);
    }

    @Nullable
    public <M extends ComplexMaterial> BlockItem getBlockItem(MaterialSlot<M> key) {
        return this.getBlockItem(key.suffix);
    }

    @Nullable
    public BlockItem getBlockItem(String key) {
        BlockItem bi;
        Item item;
        Block bl = this.blocks.get(key);
        return bl != null && (item = bl.asItem()) instanceof BlockItem ? (bi = (BlockItem)item) : null;
    }

    @Nullable
    public Item getItem(String key) {
        return this.items.get(key);
    }

    @Nullable
    public <M extends ComplexMaterial> Item getItem(MaterialSlot<M> slot) {
        return this.items.get(slot.suffix);
    }

    @Nullable
    public Item ifItemPresent(String key, Consumer<Item> runIfPresent) {
        Item item = this.items.get(key);
        if (item != null) {
            runIfPresent.accept(item);
        }
        return item;
    }

    @Nullable
    public <M extends ComplexMaterial> Item ifItemPresent(MaterialSlot<M> slot, Consumer<Item> runIfPresent) {
        Item item = this.items.get(slot.suffix);
        if (item != null) {
            runIfPresent.accept(item);
        }
        return item;
    }

    protected abstract BlockBehaviour.Properties getBlockSettings();

    protected Item.Properties getItemSettings(ItemRegistry registry) {
        return registry.createDefaultItemSettings();
    }

    private Collection<BlockEntry> getBlockEntries() {
        ArrayList result = Lists.newArrayList(this.defaultBlockEntries);
        List<BlockEntry> entries = BLOCK_ENTRIES.get(this.getMaterialID());
        if (entries != null) {
            result.addAll(entries);
        }
        return result;
    }

    private Collection<ItemEntry> getItemEntries() {
        ArrayList result = Lists.newArrayList(this.defaultItemEntries);
        List<ItemEntry> entries = ITEM_ENTRIES.get(this.getMaterialID());
        if (entries != null) {
            result.addAll(entries);
        }
        return result;
    }

    private Collection<RecipeEntry> getRecipeEntries() {
        ArrayList result = Lists.newArrayList(this.defaultRecipeEntries);
        List<RecipeEntry> entries = RECIPE_ENTRIES.get(this.getMaterialID());
        if (entries != null) {
            result.addAll(entries);
        }
        return result;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public abstract ResourceLocation getMaterialID();

    public Collection<Block> getBlocks() {
        return this.blocks.values();
    }

    public Collection<Item> getItems() {
        return this.items.values();
    }

    protected void addBlockEntry(BlockEntry entry) {
        this.defaultBlockEntries.add(entry);
    }

    protected void replaceOrAddBlockEntry(BlockEntry entry) {
        int pos = this.defaultBlockEntries.indexOf(entry);
        if (pos >= 0) {
            this.defaultBlockEntries.remove(entry);
        }
        this.addBlockEntry(entry);
    }

    protected void addItemEntry(ItemEntry entry) {
        this.defaultItemEntries.add(entry);
    }

    protected void addRecipeEntry(RecipeEntry entry) {
        this.defaultRecipeEntries.add(entry);
    }

    public static void addBlockEntry(ResourceLocation materialName, BlockEntry entry) {
        ArrayList entries = BLOCK_ENTRIES.get(materialName);
        if (entries == null) {
            entries = Lists.newArrayList();
            BLOCK_ENTRIES.put(materialName, entries);
        }
        entries.add(entry);
    }

    public static void addItemEntry(ResourceLocation materialName, ItemEntry entry) {
        ArrayList entries = ITEM_ENTRIES.get(materialName);
        if (entries == null) {
            entries = Lists.newArrayList();
            ITEM_ENTRIES.put(materialName, entries);
        }
        entries.add(entry);
    }

    public static void addRecipeEntry(ResourceLocation materialName, RecipeEntry entry) {
        ArrayList entries = RECIPE_ENTRIES.get(materialName);
        if (entries == null) {
            entries = Lists.newArrayList();
            RECIPE_ENTRIES.put(materialName, entries);
        }
        entries.add(entry);
    }

    public static Collection<ComplexMaterial> getAllMaterials() {
        return MATERIALS;
    }
}

