/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.commands.arguments;

import com.google.gson.JsonObject;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import org.betterx.bclib.commands.arguments.Float3ArgumentType;

public class Float3ArgumentInfo
implements ArgumentTypeInfo<Float3ArgumentType, Template> {
    private static byte MIN_FLAG = (byte)2;
    private static byte MAX_FLAG = (byte)4;
    private static byte IS_INT_FLAG = 1;

    private static byte createNumberFlags(boolean isInt, boolean hasMin, boolean hasMax) {
        byte flagByte = 0;
        if (isInt) {
            flagByte = (byte)(flagByte | IS_INT_FLAG);
        }
        if (hasMin) {
            flagByte = (byte)(flagByte | MIN_FLAG);
        }
        if (hasMax) {
            flagByte = (byte)(flagByte | MAX_FLAG);
        }
        return flagByte;
    }

    private static boolean numberHasMin(byte flag) {
        return (flag & MIN_FLAG) != 0;
    }

    private static boolean numberHasMax(byte flag) {
        return (flag & MAX_FLAG) != 0;
    }

    private static boolean numberIsInt(byte flag) {
        return (flag & IS_INT_FLAG) != 0;
    }

    public void serializeToNetwork(Template template, FriendlyByteBuf friendlyByteBuf) {
        boolean hasMin = template.min != -1.7976931348623157E308;
        boolean hasMax = template.max != Double.MAX_VALUE;
        friendlyByteBuf.writeByte((int)Float3ArgumentInfo.createNumberFlags(template.asInt, hasMin, hasMax));
        if (hasMin) {
            friendlyByteBuf.writeDouble(template.min);
        }
        if (hasMax) {
            friendlyByteBuf.writeDouble(template.max);
        }
    }

    public Template deserializeFromNetwork(FriendlyByteBuf friendlyByteBuf) {
        byte flag = friendlyByteBuf.readByte();
        boolean asInt = Float3ArgumentInfo.numberIsInt(flag);
        double min = Float3ArgumentInfo.numberHasMin(flag) ? friendlyByteBuf.readDouble() : -1.7976931348623157E308;
        double max = Float3ArgumentInfo.numberHasMax(flag) ? friendlyByteBuf.readDouble() : Double.MAX_VALUE;
        return new Template(asInt, min, max);
    }

    public void serializeToJson(Template template, JsonObject jsonObject) {
        if (!template.asInt) {
            jsonObject.addProperty("asInt", Boolean.valueOf(template.asInt));
        }
        if (template.min != -1.7976931348623157E308) {
            jsonObject.addProperty("min", (Number)template.min);
        }
        if (template.max != Double.MAX_VALUE) {
            jsonObject.addProperty("max", (Number)template.max);
        }
    }

    public Template unpack(Float3ArgumentType type) {
        return new Template(type.isInt(), type.getMinimum(), type.getMaximum());
    }

    public final class Template
    implements ArgumentTypeInfo.Template<Float3ArgumentType> {
        final double min;
        final double max;
        final boolean asInt;

        Template(boolean asInt, double min, double max) {
            this.min = min;
            this.max = max;
            this.asInt = asInt;
        }

        public Float3ArgumentType instantiate(CommandBuildContext commandBuildContext) {
            return this.asInt ? Float3ArgumentType.int3((int)this.min, (int)this.max) : Float3ArgumentType.float3(this.min, this.max);
        }

        public ArgumentTypeInfo<Float3ArgumentType, ?> type() {
            return Float3ArgumentInfo.this;
        }
    }
}

