/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import de.ambertation.wunderlib.math.Bounds;
import de.ambertation.wunderlib.math.Float3;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.betterx.bclib.api.v2.levelgen.structures.StructureNBT;
import org.betterx.bclib.commands.PlaceCommand;
import org.betterx.bclib.commands.arguments.ConnectorArgument;
import org.betterx.bclib.commands.arguments.Float3ArgumentType;
import org.betterx.bclib.commands.arguments.PlacementDirections;
import org.betterx.bclib.commands.arguments.TemplatePlacementArgument;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.wover.state.api.WorldState;

class PlaceCommandBuilder {
    public static final String PATH = "path";
    public static final String NBT = "nbt";
    public static final String EMPTY = "empty";
    public static final String PLACEMENT = "placement";
    public static final String POS = "pos";
    public static final String RECURSION_DEPTH = "recursion_depth";
    public static final String SPAN = "span";
    public static final String BORDER = "border";
    public static final String ADD_CONTROLL_BLOCKS = "controller";
    public static final String FILL_VOID = "replaceair";
    public static final String JIGSAW = "jigsaw";
    public static final String CONNECTOR_NAME = "connector_name";
    public static final String REPLACE_WITH = "replace_with";
    public static final String ROLLABLE = "rollable";
    public static final String REPLACE_FROM_WORLD = "fromWorld";
    public static final String BLOCKS = "blocks";
    private static final DynamicCommandExceptionType ERROR_PLACE_TAG_INVALID = new DynamicCommandExceptionType(object -> Component.translatableEscape((String)"commands.place.tag.invalid", (Object[])new Object[]{object}));

    PlaceCommandBuilder() {
    }

    public void register(CommandBuildContext ctx, LiteralArgumentBuilder<CommandSourceStack> command) {
        Supplier<RequiredArgumentBuilder> path = () -> Commands.argument((String)PATH, (ArgumentType)ResourceLocationArgument.id());
        Supplier<RequiredArgumentBuilder> placement = () -> Commands.argument((String)PLACEMENT, (ArgumentType)TemplatePlacementArgument.templatePlacement());
        Supplier<RequiredArgumentBuilder> pos = () -> Commands.argument((String)POS, (ArgumentType)BlockPosArgument.blockPos());
        Supplier<RequiredArgumentBuilder> recursionDepth = () -> Commands.argument((String)RECURSION_DEPTH, (ArgumentType)IntegerArgumentType.integer((int)0, (int)16));
        Function<Boolean, RequiredArgumentBuilder> placeIt = hasRecursionArg -> (RequiredArgumentBuilder)((RequiredArgumentBuilder)placement.get()).then(this.addOptionalsAndExecute(ctx, (RequiredArgumentBuilder)((RequiredArgumentBuilder)pos.get()), (boolean)hasRecursionArg, PlaceCommandBuilder::placeNBT));
        LiteralArgumentBuilder nbtTree = (LiteralArgumentBuilder)Commands.literal((String)NBT).then(((RequiredArgumentBuilder)path.get().then(recursionDepth.get().then((ArgumentBuilder)placeIt.apply(true)))).then((ArgumentBuilder)placeIt.apply(false)));
        LiteralArgumentBuilder emptyTree = (LiteralArgumentBuilder)Commands.literal((String)EMPTY).then(path.get().then(placement.get().then(pos.get().then(this.addOptionalsAndExecute(ctx, Commands.argument((String)SPAN, (ArgumentType)Float3ArgumentType.int3(0, 64)), false, PlaceCommandBuilder::placeEmpty)))));
        Supplier<RequiredArgumentBuilder> replace = () -> Commands.argument((String)REPLACE_WITH, (ArgumentType)BlockStateArgument.block((CommandBuildContext)ctx));
        Supplier<LiteralArgumentBuilder> replace_source = () -> Commands.literal((String)REPLACE_FROM_WORLD);
        Supplier<LiteralArgumentBuilder> rotate = () -> Commands.literal((String)ROLLABLE);
        LiteralArgumentBuilder jigsawTree = (LiteralArgumentBuilder)Commands.literal((String)JIGSAW).then(Commands.argument((String)"pool", (ArgumentType)ResourceKeyArgument.key((ResourceKey)Registries.TEMPLATE_POOL)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)CONNECTOR_NAME, (ArgumentType)ConnectorArgument.id()).then(((RequiredArgumentBuilder)replace.get().then(rotate.get().then(pos.get().executes(cc -> PlaceCommandBuilder.placeJigsaw((CommandContext<CommandSourceStack>)cc, true, true, false))))).then(pos.get().executes(cc -> PlaceCommandBuilder.placeJigsaw((CommandContext<CommandSourceStack>)cc, true, false, false))))).then(((LiteralArgumentBuilder)replace_source.get().then(rotate.get().then(pos.get().executes(cc -> PlaceCommandBuilder.placeJigsaw((CommandContext<CommandSourceStack>)cc, false, true, true))))).then(pos.get().executes(cc -> PlaceCommandBuilder.placeJigsaw((CommandContext<CommandSourceStack>)cc, false, false, true))))).then(rotate.get().then(pos.get().executes(cc -> PlaceCommandBuilder.placeJigsaw((CommandContext<CommandSourceStack>)cc, false, true, false))))).then(pos.get().executes(cc -> PlaceCommandBuilder.placeJigsaw((CommandContext<CommandSourceStack>)cc, false, false, false)))));
        LiteralArgumentBuilder blocksTree = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)BLOCKS).then(Commands.literal((String)"location").then(Commands.argument((String)"namespace", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)PATH, (ArgumentType)StringArgumentType.string()).then(pos.get().executes(this::placeBlocksMatchingLocation)))))).then(Commands.literal((String)"tag").then(Commands.argument((String)"blocktag", (ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)Registries.BLOCK)).then(pos.get().executes(this::placeBlocksMatchingTag))));
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.then((ArgumentBuilder)nbtTree)).then((ArgumentBuilder)emptyTree)).then((ArgumentBuilder)jigsawTree)).then((ArgumentBuilder)blocksTree);
    }

    private int placeBlocksMatchingLocation(CommandContext<CommandSourceStack> cc) {
        String namespace = StringArgumentType.getString(cc, (String)"namespace");
        String path = StringArgumentType.getString(cc, (String)PATH);
        return this.placeMatchingBlocks(cc, blocks -> blocks.holders().filter(holder -> {
            Optional okey = holder.unwrapKey();
            if (okey.isPresent()) {
                ResourceLocation key = ((ResourceKey)okey.get()).location();
                return !(!namespace.trim().equals("*") && !key.getNamespace().contains(namespace) || !path.trim().equals("*") && !key.getPath().contains(path));
            }
            return false;
        }).map(h -> h));
    }

    private int placeBlocksMatchingTag(CommandContext<CommandSourceStack> cc) {
        try {
            ResourceOrTagKeyArgument.Result tagResult = ResourceOrTagKeyArgument.getResourceOrTagKey(cc, (String)"blocktag", (ResourceKey)Registries.BLOCK, (DynamicCommandExceptionType)ERROR_PLACE_TAG_INVALID);
            TagKey tag = tagResult.unwrap().right().orElse(null);
            if (tag == null) {
                return -1;
            }
            return this.placeMatchingBlocks(cc, blocks -> {
                LinkedList<Holder> blockHolders = new LinkedList<Holder>();
                for (Holder bl : blocks.getTagOrEmpty(tag)) {
                    blockHolders.add(bl);
                }
                return blockHolders.stream();
            });
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private int placeMatchingBlocks(CommandContext<CommandSourceStack> cc, Function<Registry<Block>, Stream<Holder<Block>>> blockSupplier) {
        try {
            BlockPos pos = BlockPosArgument.getLoadedBlockPos(cc, (String)POS);
            int LENGTH = 16;
            int HEIGHT = 16;
            Registry blocks = WorldState.registryAccess().registry(Registries.BLOCK).orElse(null);
            LinkedList blockHolders = new LinkedList();
            blockSupplier.apply((Registry<Block>)blocks).forEach(blockHolders::add);
            ServerLevel world = ((CommandSourceStack)cc.getSource()).getLevel();
            ServerPlayer player = ((CommandSourceStack)cc.getSource()).getPlayerOrException();
            if (blocks == null) {
                return -1;
            }
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            for (Holder entry : blockHolders) {
                ResourceLocation key = ((ResourceKey)entry.unwrapKey().orElseThrow()).location();
                Block block = (Block)entry.value();
                BlockPos test = new BlockPos(x, y, z);
                while (!world.isEmptyBlock(test)) {
                    if (++x - pos.getX() > 16) {
                        x = pos.getX();
                        if (++y - pos.getY() > 16) {
                            y = pos.getY();
                            z += 4;
                        }
                    }
                    test = new BlockPos(x, y, z);
                }
                PlaceCommandBuilder.place(world, player, block, block.defaultBlockState(), test);
            }
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    private static void place(ServerLevel world, ServerPlayer player, Block bl, BlockState state, BlockPos blockPos) {
        if (!(bl instanceof LiquidBlock)) {
            if (bl instanceof DoorBlock) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, blockPos, (BlockState)state.setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, blockPos.above(), (BlockState)state.setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.UPPER));
            } else if (bl instanceof BedBlock) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, blockPos, (BlockState)state.setValue((Property)BedBlock.PART, (Comparable)BedPart.FOOT));
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, blockPos.relative((Direction)state.getValue((Property)BedBlock.FACING)), (BlockState)state.setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD));
            } else {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, blockPos, state);
            }
        }
    }

    private <T> RequiredArgumentBuilder<CommandSourceStack, T> addOptionalsAndExecute(CommandBuildContext commandBuildContext, RequiredArgumentBuilder<CommandSourceStack, T> root, boolean hasRecursionArgs, Executor runner) {
        Supplier<LiteralArgumentBuilder> addControllers = () -> Commands.literal((String)ADD_CONTROLL_BLOCKS);
        Supplier<LiteralArgumentBuilder> replaceAir = () -> Commands.literal((String)FILL_VOID);
        Supplier<RequiredArgumentBuilder> addBorder = () -> Commands.argument((String)BORDER, (ArgumentType)BlockStateArgument.block((CommandBuildContext)commandBuildContext));
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)root.executes(c -> runner.exec((CommandContext<CommandSourceStack>)c, false, false, false, hasRecursionArgs))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)addBorder.get().executes(c -> runner.exec((CommandContext<CommandSourceStack>)c, true, false, false, hasRecursionArgs))).then(addControllers.get().executes(c -> runner.exec((CommandContext<CommandSourceStack>)c, true, true, false, hasRecursionArgs)))).then(addControllers.get().then(replaceAir.get().executes(c -> runner.exec((CommandContext<CommandSourceStack>)c, true, true, true, hasRecursionArgs)))))).then(addControllers.get().executes(c -> runner.exec((CommandContext<CommandSourceStack>)c, false, true, false, hasRecursionArgs)))).then(addControllers.get().then(replaceAir.get().executes(c -> runner.exec((CommandContext<CommandSourceStack>)c, false, true, true, hasRecursionArgs))));
    }

    protected static int placeNBT(CommandContext<CommandSourceStack> ctx, boolean hasBorderArg, boolean controlBlocks, boolean replaceAir, boolean hasRecursionArg) throws CommandSyntaxException {
        ResourceLocation id = ResourceLocationArgument.getId(ctx, (String)PATH);
        PlacementDirections searchDir = TemplatePlacementArgument.getPlacement(ctx, PLACEMENT);
        BlockInput blockInput = hasBorderArg ? BlockStateArgument.getBlock(ctx, (String)BORDER) : null;
        BlockPos pos = BlockPosArgument.getLoadedBlockPos(ctx, (String)POS);
        int recursionDepth = hasRecursionArg ? IntegerArgumentType.getInteger(ctx, (String)RECURSION_DEPTH) : 1;
        List<StructureNBT> structures = StructureNBT.createResourcesFrom(id, recursionDepth);
        if (structures != null) {
            Bounds b = Bounds.of((BlockPos)pos);
            Bounds all = Bounds.of((BlockPos)pos);
            BlockPos pNew = pos;
            BlockPos rowStart = pos;
            String lastPrefix = null;
            for (StructureNBT s : structures) {
                String prefix;
                String string = prefix = s.location.getPath().contains("/") ? s.location.getPath().replaceAll("/[^/]*$", "") : "";
                if (lastPrefix != null && !lastPrefix.equals(prefix)) {
                    rowStart = pNew = searchDir.resetStart(b, pNew, 10);
                    b = Bounds.of((BlockPos)pNew);
                }
                lastPrefix = prefix;
                Bounds bb = Bounds.of((BoundingBox)Objects.requireNonNull(PlaceCommand.placeBlocks((CommandSourceStack)ctx.getSource(), rowStart, searchDir.getOffset(), blockInput, controlBlocks, replaceAir, true, s.location, p -> s.getBoundingBox((BlockPos)p, Rotation.NONE, Mirror.NONE), (level, p) -> s.generateAt((ServerLevelAccessor)level, (BlockPos)p, Rotation.NONE, Mirror.NONE))));
                rowStart = searchDir.advanceStart(bb, rowStart);
                b = b.encapsulate(bb);
                all = all.encapsulate(bb);
                if (searchDir.sizeInDirection(b) <= 160) continue;
                rowStart = pNew = searchDir.resetStart(b, pNew);
                b = Bounds.of((BlockPos)pNew);
            }
            Bounds finalAll = all;
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Placed " + structures.size() + " NBTs: " + finalAll.toString())).setStyle(Style.EMPTY.withColor(ChatFormatting.LIGHT_PURPLE)), true);
            return 0;
        }
        StructureNBT structureNBT = StructureNBT.create(id);
        return PlaceCommand.placeBlocks((CommandSourceStack)ctx.getSource(), pos, searchDir.getOffset(), blockInput, controlBlocks, replaceAir, true, structureNBT.location, p -> structureNBT.getBoundingBox((BlockPos)p, Rotation.NONE, Mirror.NONE), (level, p) -> structureNBT.generateAt((ServerLevelAccessor)level, (BlockPos)p, Rotation.NONE, Mirror.NONE)) == null ? 1 : -1;
    }

    protected static int placeEmpty(CommandContext<CommandSourceStack> ctx, boolean hasBorderArg, boolean controlBlocks, boolean replaceAir, boolean hasRecursionArg) throws CommandSyntaxException {
        ResourceLocation id = ResourceLocationArgument.getId(ctx, (String)PATH);
        PlacementDirections searchDir = TemplatePlacementArgument.getPlacement(ctx, PLACEMENT);
        BlockInput blockInput = hasBorderArg ? BlockStateArgument.getBlock(ctx, (String)BORDER) : null;
        BlockPos span = Float3ArgumentType.getFloat3(ctx, SPAN).toBlockPos();
        return PlaceCommand.placeBlocks((CommandSourceStack)ctx.getSource(), BlockPosArgument.getLoadedBlockPos(ctx, (String)POS), searchDir == null || searchDir.dir == Float3.ZERO ? null : searchDir.dir.toBlockPos(), blockInput, controlBlocks, replaceAir, false, id, p -> BoundingBox.fromCorners((Vec3i)p, (Vec3i)p.offset((Vec3i)span)), (level, p) -> {
            BoundingBox box = BoundingBox.fromCorners((Vec3i)p, (Vec3i)p.offset((Vec3i)span));
            PlaceCommand.fillStructureVoid((Level)level, box);
            if (blockInput != null) {
                PlaceCommand.fill((Level)level, new BoundingBox(box.minX(), box.minY() - 1, box.minZ(), box.maxX(), box.minY() - 1, box.maxZ()), blockInput.getState());
            }
        }) == null ? 1 : -1;
    }

    public static int placeJigsaw(CommandContext<CommandSourceStack> ctx, boolean hasReplaceArg, boolean rotate, boolean replaceFromWorld) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.getLoadedBlockPos(ctx, (String)POS);
        Holder.Reference pool = ResourceKeyArgument.getStructureTemplatePool(ctx, (String)"pool");
        ResourceLocation connector = ResourceLocationArgument.getId(ctx, (String)CONNECTOR_NAME);
        if (connector.getNamespace().equals("-")) {
            connector = ResourceLocation.fromNamespaceAndPath((String)pool.key().location().getNamespace(), (String)connector.getPath());
        }
        BlockState replaceWith = hasReplaceArg ? BlockStateArgument.getBlock(ctx, (String)REPLACE_WITH).getState() : Blocks.AIR.defaultBlockState();
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayer();
        int deltaY = player.getBlockY() - pos.getY();
        BlockState state = Blocks.JIGSAW.defaultBlockState();
        state = deltaY < 2 && deltaY > -2 && !rotate ? (BlockState)state.setValue((Property)JigsawBlock.ORIENTATION, (Comparable)FrontAndTop.fromFrontAndTop((Direction)player.getDirection().getOpposite(), (Direction)Direction.UP)) : (deltaY < 0 ? (BlockState)state.setValue((Property)JigsawBlock.ORIENTATION, (Comparable)FrontAndTop.fromFrontAndTop((Direction)Direction.DOWN, (Direction)player.getDirection().getOpposite())) : (BlockState)state.setValue((Property)JigsawBlock.ORIENTATION, (Comparable)FrontAndTop.fromFrontAndTop((Direction)Direction.UP, (Direction)player.getDirection().getOpposite())));
        if (replaceFromWorld) {
            replaceWith = level.getBlockState(pos);
        }
        level.setBlock(pos, state, 18);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof JigsawBlockEntity) {
            JigsawBlockEntity entity = (JigsawBlockEntity)blockEntity;
            entity.setName(connector);
            entity.setTarget(connector);
            entity.setPool(pool.key());
            entity.setFinalState(BlockStateParser.serialize((BlockState)replaceWith));
            if (rotate) {
                entity.setJoint(JigsawBlockEntity.JointType.ROLLABLE);
            } else {
                entity.setJoint(JigsawBlockEntity.JointType.ALIGNED);
            }
        }
        return 1;
    }

    public static int placeSpawner(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.getLoadedBlockPos(ctx, (String)POS);
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        level.setBlock(pos, Blocks.SPAWNER.defaultBlockState(), 18);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity entity = (SpawnerBlockEntity)blockEntity;
            CompoundTag tag = TagParser.parseTag((String)"{SpawnData:{entity:{id:wither_skeleton,PersistenceRequired:1,HandItems:[{Count:1,id:netherite_sword},{Count:1,id:shield}],ArmorItems:[{Count:1,id:netherite_boots,tag:{Enchantments:[{id:protection,lvl:1}]}},{Count:1,id:netherite_leggings,tag:{Enchantments:[{id:protection,lvl:1}]}},{Count:1,id:netherite_chestplate,tag:{Enchantments:[{id:protection,lvl:1},{id:thorns,lvl:3}]}},{Count:1,id:netherite_helmet,tag:{Enchantments:[{id:protection,lvl:1}]}}],HandDropChances:[0.0f,0.0f],ArmorDropChances:[0.0f,0.0f,0.0f,0.0f]}, custom_spawn_rules:{sky_light_limit:{max_inclusive:13},block_light_limit:{max_inclusive:11}}},SpawnRange:4,SpawnCount:8,MaxNearbyEntities:18,Delay:499,MinSpawnDelay:300,MaxSpawnDelay:1600,RequiredPlayerRange:20}");
            entity.loadCustomOnly(tag, (HolderLookup.Provider)((CommandSourceStack)ctx.getSource()).registryAccess());
        }
        return 1;
    }

    static interface Executor {
        public int exec(CommandContext<CommandSourceStack> var1, boolean var2, boolean var3, boolean var4, boolean var5) throws CommandSyntaxException;
    }
}

