/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.textures;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.resources.ResourceLocation;

@Environment(value=EnvType.CLIENT)
public class AtlasSetManager {
    public static final ResourceLocation VANILLA_BLOCKS = ResourceLocation.withDefaultNamespace((String)"blocks");
    private static Map<ResourceLocation, List<SpriteSource>> additionalSets = new HashMap<ResourceLocation, List<SpriteSource>>();

    public static void addSource(ResourceLocation type, SpriteSource source) {
        additionalSets.computeIfAbsent(type, t -> new LinkedList()).add(source);
    }

    public static void onLoadResources(ResourceLocation type, List<SpriteSource> sources) {
        List<SpriteSource> additionalSources = additionalSets.get(type);
        if (additionalSources != null) {
            sources.addAll(additionalSources);
        }
    }
}

