/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Camera;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FogType;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.util.BackgroundInfo;
import org.betterx.bclib.util.MHelper;
import org.betterx.wover.biome.api.BiomeManager;
import org.betterx.wover.biome.api.data.BiomeData;

public class CustomFogRenderer {
    private static final BlockPos.MutableBlockPos LAST_POS = new BlockPos.MutableBlockPos(0, -100, 0);
    private static final BlockPos.MutableBlockPos MUT_POS = new BlockPos.MutableBlockPos();
    private static final float[] FOG_DENSITY = new float[8];
    private static final int GRID_SIZE = 32;
    private static float fogStart = 0.0f;
    private static float fogEnd = 192.0f;

    public static boolean applyFogDensity(Camera camera, float viewDistance, boolean thickFog) {
        float fog;
        if (!Configs.CLIENT_CONFIG.renderCustomFog()) {
            return false;
        }
        FogType fogType = camera.getFluidInCamera();
        if (fogType != FogType.NONE) {
            BackgroundInfo.fogDensity = 1.0f;
            return false;
        }
        Entity entity = camera.getEntity();
        if (!CustomFogRenderer.isForcedDimension(entity.level()) && CustomFogRenderer.shouldIgnoreArea(entity.level(), (int)entity.getX(), (int)entity.getEyeY(), (int)entity.getZ())) {
            BackgroundInfo.fogDensity = 1.0f;
            return false;
        }
        BackgroundInfo.fogDensity = fog = CustomFogRenderer.getFogDensity(entity.level(), entity.getX(), entity.getEyeY(), entity.getZ()) * Configs.CLIENT_CONFIG.fogDensity();
        if (CustomFogRenderer.thickFog(thickFog, entity.level())) {
            fogStart = viewDistance * 0.05f / fog;
            fogEnd = Math.min(viewDistance, 192.0f) * 0.5f / fog;
        } else {
            fogStart = viewDistance * 0.25f / fog;
            fogEnd = viewDistance / fog;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            MobEffectInstance effect = livingEntity.getEffect(MobEffects.BLINDNESS);
            if (effect != null) {
                int duration = effect.getDuration();
                if (duration > 20) {
                    fogStart = 0.0f;
                    fogEnd *= 0.03f;
                    BackgroundInfo.blindness = 1.0f;
                } else {
                    float delta;
                    BackgroundInfo.blindness = delta = (float)duration / 20.0f;
                    fogStart = Mth.lerp((float)delta, (float)fogStart, (float)0.0f);
                    fogEnd = Mth.lerp((float)delta, (float)fogEnd, (float)(fogEnd * 0.03f));
                }
            } else {
                BackgroundInfo.blindness = 0.0f;
            }
        }
        RenderSystem.setShaderFogStart((float)fogStart);
        RenderSystem.setShaderFogEnd((float)fogEnd);
        return true;
    }

    private static boolean thickFog(boolean thickFog, Level level) {
        if (!thickFog) {
            return false;
        }
        if (level.dimension() == Level.NETHER) {
            return Configs.CLIENT_CONFIG.netherThickFog();
        }
        return true;
    }

    private static boolean isForcedDimension(Level level) {
        return level.dimension() == Level.END || level.dimension() == Level.NETHER;
    }

    private static boolean shouldIgnoreArea(Level level, int x, int y, int z) {
        for (int i = -8; i <= 8; i += 8) {
            for (int j = -8; j <= 8; j += 8) {
                if (CustomFogRenderer.shouldIgnore(level, x + i, y, z + j)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean shouldIgnore(Level level, int x, int y, int z) {
        Holder biome = level.getBiome((BlockPos)MUT_POS.set(x, y, z));
        return BiomeManager.biomeDataForHolder((Holder)biome) != null;
    }

    private static float getFogDensityI(Level level, int x, int y, int z) {
        Holder biome = level.getBiome((BlockPos)MUT_POS.set(x, y, z));
        BiomeData renderBiome = BiomeManager.biomeDataForHolder((Holder)biome);
        if (renderBiome == null) {
            return 1.0f;
        }
        return renderBiome.fogDensity;
    }

    private static float getFogDensity(Level level, double x, double y, double z) {
        int x1 = MHelper.floor(x / 32.0) * 32;
        int y1 = MHelper.floor(y / 32.0) * 32;
        int z1 = MHelper.floor(z / 32.0) * 32;
        float dx = (float)(x - (double)x1) / 32.0f;
        float dy = (float)(y - (double)y1) / 32.0f;
        float dz = (float)(z - (double)z1) / 32.0f;
        if (LAST_POS.getX() != x1 || LAST_POS.getY() != y1 || LAST_POS.getZ() != z1) {
            int x2 = x1 + 32;
            int y2 = y1 + 32;
            int z2 = z1 + 32;
            LAST_POS.set(x1, y1, z1);
            CustomFogRenderer.FOG_DENSITY[0] = CustomFogRenderer.getFogDensityI(level, x1, y1, z1);
            CustomFogRenderer.FOG_DENSITY[1] = CustomFogRenderer.getFogDensityI(level, x2, y1, z1);
            CustomFogRenderer.FOG_DENSITY[2] = CustomFogRenderer.getFogDensityI(level, x1, y2, z1);
            CustomFogRenderer.FOG_DENSITY[3] = CustomFogRenderer.getFogDensityI(level, x2, y2, z1);
            CustomFogRenderer.FOG_DENSITY[4] = CustomFogRenderer.getFogDensityI(level, x1, y1, z2);
            CustomFogRenderer.FOG_DENSITY[5] = CustomFogRenderer.getFogDensityI(level, x2, y1, z2);
            CustomFogRenderer.FOG_DENSITY[6] = CustomFogRenderer.getFogDensityI(level, x1, y2, z2);
            CustomFogRenderer.FOG_DENSITY[7] = CustomFogRenderer.getFogDensityI(level, x2, y2, z2);
        }
        float a = Mth.lerp((float)dx, (float)FOG_DENSITY[0], (float)FOG_DENSITY[1]);
        float b = Mth.lerp((float)dx, (float)FOG_DENSITY[2], (float)FOG_DENSITY[3]);
        float c = Mth.lerp((float)dx, (float)FOG_DENSITY[4], (float)FOG_DENSITY[5]);
        float d = Mth.lerp((float)dx, (float)FOG_DENSITY[6], (float)FOG_DENSITY[7]);
        a = Mth.lerp((float)dy, (float)a, (float)b);
        b = Mth.lerp((float)dy, (float)c, (float)d);
        return Mth.lerp((float)dz, (float)a, (float)b);
    }
}

