/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.multipart.MultiPart;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.interfaces.ItemModelProvider;
import org.betterx.bclib.interfaces.RuntimeBlockModelProvider;
import org.betterx.bclib.models.RecordItemModelProvider;

public class CustomModelBakery {
    private final Map<ResourceLocation, UnbakedModel> models = Maps.newConcurrentMap();
    private final Map<Block, List<StateModelPair>> blockModels = Maps.newConcurrentMap();

    public UnbakedModel getBlockModel(ResourceLocation location) {
        return this.models.get(location);
    }

    public UnbakedModel getItemModel(ResourceLocation location) {
        return this.models.get(location);
    }

    public void registerBlockStateResolvers(ModelLoadingPlugin.Context pluginContext) {
        for (Map.Entry<Block, List<StateModelPair>> e : this.blockModels.entrySet()) {
            pluginContext.registerBlockStateResolver(e.getKey(), context -> ((List)e.getValue()).forEach(p -> context.setModel(p.state, p.model)));
        }
    }

    public void loadCustomModels(ResourceManager resourceManager) {
        ((Stream)BuiltInRegistries.BLOCK.stream().parallel()).filter(block -> block instanceof RuntimeBlockModelProvider).forEach(block -> {
            ResourceLocation blockID = BuiltInRegistries.BLOCK.getKey(block);
            ResourceLocation storageID = ResourceLocation.fromNamespaceAndPath((String)blockID.getNamespace(), (String)("blockstates/" + blockID.getPath() + ".json"));
            if (resourceManager.getResource(storageID).isEmpty()) {
                this.addBlockModel(blockID, (Block)block);
            }
            if (resourceManager.getResource(storageID = ResourceLocation.fromNamespaceAndPath((String)blockID.getNamespace(), (String)("models/item/" + blockID.getPath() + ".json"))).isEmpty()) {
                this.addItemModel(blockID, (ItemModelProvider)block);
            }
        });
        ((Stream)BuiltInRegistries.ITEM.stream().parallel()).filter(item -> item instanceof ItemModelProvider || RecordItemModelProvider.has(item)).forEach(item -> {
            ItemModelProvider provider;
            ResourceLocation registryID = BuiltInRegistries.ITEM.getKey(item);
            ResourceLocation storageID = ResourceLocation.fromNamespaceAndPath((String)registryID.getNamespace(), (String)("models/item/" + registryID.getPath() + ".json"));
            ItemModelProvider itemModelProvider = provider = item instanceof ItemModelProvider ? (ItemModelProvider)item : RecordItemModelProvider.get(item);
            if (resourceManager.getResource(storageID).isEmpty()) {
                this.addItemModel(registryID, provider);
            }
        });
    }

    private void addBlockModel(ResourceLocation blockID, Block block) {
        RuntimeBlockModelProvider provider = (RuntimeBlockModelProvider)block;
        ImmutableList states = block.getStateDefinition().getPossibleStates();
        BlockState defaultState = block.defaultBlockState();
        ModelResourceLocation defaultStateID = BlockModelShaper.stateToModelLocation((ResourceLocation)blockID, (BlockState)defaultState);
        UnbakedModel defaultModel = provider.getModelVariant(defaultStateID, defaultState, this.models);
        ArrayList stateModels = new ArrayList(states.size());
        if (defaultModel instanceof MultiPart) {
            states.forEach(blockState -> {
                ModelResourceLocation stateID = BlockModelShaper.stateToModelLocation((ResourceLocation)blockID, (BlockState)blockState);
                this.models.put(stateID.id(), defaultModel);
                stateModels.add(new StateModelPair((BlockState)blockState, defaultModel));
            });
        } else {
            states.forEach(blockState -> {
                ModelResourceLocation stateID = BlockModelShaper.stateToModelLocation((ResourceLocation)blockID, (BlockState)blockState);
                UnbakedModel model = stateID.equals((Object)defaultStateID) ? defaultModel : provider.getModelVariant(stateID, (BlockState)blockState, this.models);
                this.models.put(stateID.id(), model);
                stateModels.add(new StateModelPair((BlockState)blockState, model));
            });
        }
        this.blockModels.put(block, stateModels);
    }

    private void addItemModel(ResourceLocation itemID, ItemModelProvider provider) {
        ModelResourceLocation modelLocation = new ModelResourceLocation(itemID, "inventory");
        if (!this.models.containsKey(modelLocation)) {
            ResourceLocation itemModelLocation = itemID.withPrefix("item/");
            BlockModel model = provider.getItemModel(modelLocation.id());
            this.models.put(modelLocation.id(), (UnbakedModel)model);
            this.models.put(itemModelLocation, (UnbakedModel)model);
        }
    }

    private record StateModelPair(BlockState state, UnbakedModel model) {
    }
}

