/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.MapColor;
import org.betterx.bclib.blocks.BaseAnvilBlock;
import org.betterx.bclib.util.LegacyTiers;

public class LeveledAnvilBlock
extends BaseAnvilBlock {
    protected final int level;

    public LeveledAnvilBlock(MapColor color, int level) {
        super(color);
        this.level = level;
    }

    public static int getAnvilCraftingLevel(Block anvil) {
        if (anvil instanceof LeveledAnvilBlock) {
            LeveledAnvilBlock l = (LeveledAnvilBlock)anvil;
            return l.getCraftingLevel();
        }
        if (anvil == Blocks.ANVIL || anvil == Blocks.CHIPPED_ANVIL || anvil == Blocks.DAMAGED_ANVIL) {
            return LegacyTiers.IRON.level - 1;
        }
        return 0;
    }

    public static boolean canHandle(Block anvil, int level) {
        return LeveledAnvilBlock.getAnvilCraftingLevel(anvil) >= level;
    }

    public static List<Block> getAnvils() {
        return BuiltInRegistries.BLOCK.stream().filter(b -> b instanceof LeveledAnvilBlock || b == Blocks.ANVIL).toList();
    }

    public static List<FormattedCharSequence> getNamesForLevel(int level) {
        MutableComponent names = LeveledAnvilBlock.getAnvils().stream().filter(b -> LeveledAnvilBlock.canHandle(b, level)).map(Block::getName).reduce(null, (p, c) -> p == null ? c : p.append((Component)Component.literal((String)", ")).append((Component)c));
        if (names == null) {
            return List.of();
        }
        return Minecraft.getInstance().font.split((FormattedText)names, 200);
    }

    public int getCraftingLevel() {
        return this.level;
    }
}

