/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.client.models.BasePatterns;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.interfaces.RuntimeBlockModelProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FeatureSaplingBlock<F extends Feature<FC>, FC extends FeatureConfiguration>
extends SaplingBlock
implements RenderLayerProvider,
RuntimeBlockModelProvider,
DropSelfLootProvider<FeatureSaplingBlock> {
    private static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);
    private final FeatureSupplier<F, FC> feature;

    public FeatureSaplingBlock(FeatureSupplier<F, FC> featureSupplier) {
        this(0, featureSupplier);
    }

    public FeatureSaplingBlock(int light, FeatureSupplier<F, FC> featureSupplier) {
        this(BehaviourBuilders.createPlant().randomTicks().noCollission().lightLevel(state -> light).sound(SoundType.GRASS), featureSupplier);
    }

    public FeatureSaplingBlock(BlockBehaviour.Properties properties, FeatureSupplier<F, FC> featureSupplier) {
        super(null, properties);
        this.feature = featureSupplier;
    }

    protected boolean growFeature(@NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull BlockState blockState, @NotNull RandomSource random) {
        if (this.feature != null) {
            return this.feature.grow(world, pos, blockState, random);
        }
        return false;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return random.nextInt(16) == 0;
    }

    public void advanceTree(ServerLevel world, BlockPos pos, BlockState blockState, RandomSource random) {
        if ((Integer)blockState.getValue((Property)STAGE) == 0) {
            world.setBlock(pos, (BlockState)blockState.cycle((Property)STAGE), 4);
        } else {
            this.doGrowFeature(world, pos, blockState, random);
        }
    }

    protected boolean doGrowFeature(ServerLevel serverLevel, BlockPos blockPos, BlockState originalBlockState, RandomSource randomSource) {
        if (this.feature == null) {
            return false;
        }
        BlockState emptyState = serverLevel.getFluidState(blockPos).createLegacyBlock();
        serverLevel.setBlock(blockPos, emptyState, 4);
        if (this.growFeature(serverLevel, blockPos, originalBlockState, randomSource)) {
            if (serverLevel.getBlockState(blockPos) == emptyState) {
                serverLevel.sendBlockUpdated(blockPos, originalBlockState, emptyState, 2);
            }
            return true;
        }
        serverLevel.setBlock(blockPos, originalBlockState, 4);
        return false;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.tick(state, world, pos, random);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(state, world, pos, random);
        if (this.isBonemealSuccess((Level)world, random, pos, state)) {
            this.performBonemeal(world, random, pos, state);
        }
    }

    @Override
    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BlockModel getItemModel(ResourceLocation resourceLocation) {
        return ModelsHelper.createBlockItem(resourceLocation);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public BlockModel getBlockModel(ResourceLocation resourceLocation, BlockState blockState) {
        Optional<String> pattern = PatternsHelper.createJson(BasePatterns.BLOCK_CROSS, resourceLocation);
        return ModelsHelper.fromPattern(pattern);
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    @FunctionalInterface
    public static interface FeatureSupplier<F extends Feature<FC>, FC extends FeatureConfiguration> {
        public boolean grow(@NotNull ServerLevel var1, @NotNull BlockPos var2, @NotNull BlockState var3, @NotNull RandomSource var4);
    }
}

