/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeightedPressurePlateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.client.models.BasePatterns;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.interfaces.RuntimeBlockModelProvider;
import org.jetbrains.annotations.Nullable;

public class BaseWeightedPlateBlock
extends WeightedPressurePlateBlock
implements RuntimeBlockModelProvider,
DropSelfLootProvider<BaseWeightedPlateBlock> {
    private final Block parent;

    public BaseWeightedPlateBlock(Block source, BlockSetType type) {
        super(15, type, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)source).noCollission().noOcclusion().requiresCorrectToolForDrops().strength(0.5f));
        this.parent = source;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BlockModel getItemModel(ResourceLocation resourceLocation) {
        return this.getBlockModel(resourceLocation, this.defaultBlockState());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public BlockModel getBlockModel(ResourceLocation resourceLocation, BlockState blockState) {
        ResourceLocation parentId = BuiltInRegistries.BLOCK.getKey((Object)this.parent);
        Optional<String> pattern = (Integer)blockState.getValue((Property)POWER) > 0 ? PatternsHelper.createJson(BasePatterns.BLOCK_PLATE_DOWN, parentId) : PatternsHelper.createJson(BasePatterns.BLOCK_PLATE_UP, parentId);
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public UnbakedModel getModelVariant(ModelResourceLocation stateId, BlockState blockState, Map<ResourceLocation, UnbakedModel> modelCache) {
        String state = (Integer)blockState.getValue((Property)POWER) > 0 ? "_down" : "_up";
        ModelResourceLocation modelId = RuntimeBlockModelProvider.remapModelResourceLocation(stateId, blockState, state);
        this.registerBlockModel(stateId, modelId, blockState, modelCache);
        return ModelsHelper.createBlockSimple(modelId.id());
    }
}

