/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.wover.block.api.BlockTagProvider;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;

public abstract class BaseWallBlock
extends WallBlock
implements DropSelfLootProvider<BaseWallBlock>,
BlockModelProvider,
BlockTagProvider {
    private final Block parent;

    protected BaseWallBlock(Block source) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)source).noOcclusion());
        this.parent = source;
    }

    public void registerBlockTags(ResourceLocation location, TagBootstrapContext<Block> context) {
        context.add((Object)this, new TagKey[]{BlockTags.WALLS});
    }

    @Environment(value=EnvType.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        generator.createWall(this.parent, (Block)this);
    }

    public static BaseWallBlock from(Block source) {
        if (source instanceof BehaviourWood) {
            return new Wood(source);
        }
        if (source instanceof BehaviourMetal) {
            return new Metal(source);
        }
        return new Stone(source);
    }

    public static class Wood
    extends BaseWallBlock
    implements BehaviourWood {
        public Wood(Block source) {
            super(source);
        }
    }

    public static class Metal
    extends BaseWallBlock
    implements BehaviourMetal {
        public Metal(Block block) {
            super(block);
        }
    }

    public static class Stone
    extends BaseWallBlock
    implements BehaviourStone {
        public Stone(Block source) {
            super(source);
        }
    }
}

