/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourObsidian;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.wover.block.api.BlockTagProvider;
import org.betterx.wover.block.api.CustomBlockItemProvider;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.betterx.wover.item.api.ItemTagProvider;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;

public abstract class BaseStairsBlock
extends StairBlock
implements BlockModelProvider,
CustomBlockItemProvider,
BlockTagProvider,
ItemTagProvider,
DropSelfLootProvider<BaseStairsBlock> {
    private final Block parent;
    public final boolean fireproof;

    protected BaseStairsBlock(Block source, boolean fireproof) {
        super(source.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)source));
        this.parent = source;
        this.fireproof = fireproof;
    }

    @Environment(value=EnvType.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        generator.createStairs(this.parent, (Block)this);
    }

    public BlockItem getCustomBlockItem(ResourceLocation blockID, Item.Properties settings) {
        if (this.fireproof) {
            settings = settings.fireResistant();
        }
        return new BlockItem((Block)this, settings);
    }

    public void registerBlockTags(ResourceLocation location, TagBootstrapContext<Block> context) {
        context.add((Object)this, new TagKey[]{BlockTags.STAIRS});
    }

    public void registerItemTags(ResourceLocation location, ItemTagBootstrapContext context) {
        context.add((ItemLike)this, new TagKey[]{ItemTags.STAIRS});
    }

    public static BaseStairsBlock from(Block source, boolean flammable) {
        return BehaviourHelper.from(source, block -> new Wood((Block)block, flammable), block -> new Stone((Block)block, !flammable), block -> new Metal((Block)block, !flammable), block -> new Obsidian((Block)block, !flammable), null);
    }

    public static class Obsidian
    extends BaseStairsBlock
    implements BehaviourObsidian {
        public Obsidian(Block source) {
            this(source, true);
        }

        public Obsidian(Block source, boolean fireproof) {
            super(source, fireproof);
        }
    }

    public static class Metal
    extends BaseStairsBlock
    implements BehaviourMetal {
        public Metal(Block source) {
            this(source, true);
        }

        public Metal(Block source, boolean fireproof) {
            super(source, fireproof);
        }
    }

    public static class Stone
    extends BaseStairsBlock
    implements BehaviourStone {
        public Stone(Block source) {
            this(source, true);
        }

        public Stone(Block source, boolean fireproof) {
            super(source, fireproof);
        }
    }

    public static class Wood
    extends BaseStairsBlock
    implements BehaviourWood {
        public Wood(Block source) {
            this(source, false);
        }

        public Wood(Block source, boolean fireproof) {
            super(source, fireproof);
        }

        @Override
        public void registerBlockTags(ResourceLocation location, TagBootstrapContext<Block> context) {
            context.add((Object)this, new TagKey[]{BlockTags.STAIRS, BlockTags.WOODEN_STAIRS});
        }

        @Override
        public void registerItemTags(ResourceLocation location, ItemTagBootstrapContext context) {
            context.add((ItemLike)this, new TagKey[]{ItemTags.STAIRS, ItemTags.WOODEN_STAIRS});
        }
    }
}

