/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.blocks.BaseTerrainBlock;
import org.betterx.bclib.client.models.BCLModels;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.betterx.wover.loot.api.BlockLootProvider;
import org.betterx.wover.loot.api.LootLookupProvider;
import org.jetbrains.annotations.NotNull;

public abstract class BasePathBlock
extends BaseBlockNotFull
implements BlockLootProvider,
BlockModelProvider {
    private static final VoxelShape SHAPE = BasePathBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private Block baseBlock;

    public BasePathBlock(Block source) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)source).isValidSpawn((state, world, pos, type) -> false));
        this.baseBlock = source;
        if (source instanceof BaseTerrainBlock) {
            BaseTerrainBlock terrain = (BaseTerrainBlock)source;
            this.baseBlock = terrain.getBaseBlock();
            terrain.setPathBlock(this);
        }
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        ResourceLocation side = TextureMapping.getBlockTexture((Block)this, (String)"_side");
        side = ResourceLocation.fromNamespaceAndPath((String)side.getNamespace(), (String)side.getPath().replace("_path", ""));
        TextureMapping mapping = new TextureMapping().put(TextureSlot.SIDE, side).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)this, (String)"_top")).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)this.baseBlock));
        ResourceLocation location = BCLModels.PATH.create((Block)this, mapping, generator.modelOutput());
        generator.acceptBlockState((BlockStateGenerator)WoverBlockModelGenerators.randomTopModelVariant((Block)this, (ResourceLocation)location));
    }

    @Override
    public LootTable.Builder registerBlockLoot(@NotNull ResourceLocation location, @NotNull LootLookupProvider provider, @NotNull ResourceKey<LootTable> tableKey) {
        return provider.dropWithSilkTouch((Block)this, (ItemLike)this.baseBlock, (NumberProvider)ConstantValue.exactly((float)1.0f));
    }

    public static class Stone
    extends BasePathBlock
    implements BehaviourStone {
        public Stone(Block source) {
            super(source);
        }
    }
}

