/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourClimable;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.client.models.BCLModels;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;

public abstract class BaseLadderBlock
extends LadderBlock
implements RenderLayerProvider,
BehaviourClimable,
DropSelfLootProvider<BaseLadderBlock>,
BlockModelProvider {
    protected BaseLadderBlock(Block block) {
        this(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block).noOcclusion());
    }

    public BaseLadderBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    @Environment(value=EnvType.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        TextureMapping mapping = new TextureMapping().put(TextureSlot.TEXTURE, TextureMapping.getBlockTexture((Block)this));
        ResourceLocation location = BCLModels.LADDER.create((Block)this, mapping, generator.modelOutput());
        generator.acceptBlockState((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)this, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)location)).with(BlockModelGenerators.createHorizontalFacingDispatch()));
        generator.createFlatItem((Block)this);
    }

    public static BaseLadderBlock from(Block source) {
        return BehaviourHelper.from(source, Wood::new, null, Metal::new);
    }

    public static class Metal
    extends BaseLadderBlock
    implements BehaviourMetal {
        public Metal(Block block) {
            super(block);
        }

        public Metal(BlockBehaviour.Properties properties) {
            super(properties);
        }
    }

    public static class Wood
    extends BaseLadderBlock
    implements BehaviourWood {
        public Wood(Block block) {
            super(block);
        }

        public Wood(BlockBehaviour.Properties properties) {
            super(properties);
        }
    }
}

