/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.wover.block.api.BlockTagProvider;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;

public abstract class BaseGateBlock
extends FenceGateBlock
implements BlockModelProvider,
BlockTagProvider,
DropSelfLootProvider<BaseGateBlock> {
    private final Block parent;

    protected BaseGateBlock(Block source, WoodType type) {
        super(type, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)source).noOcclusion());
        this.parent = source;
    }

    public void registerBlockTags(ResourceLocation location, TagBootstrapContext<Block> context) {
        context.add(BlockTags.FENCE_GATES, (Object[])new Block[]{this});
    }

    @Environment(value=EnvType.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        generator.createFenceGate(this.parent, (Block)this);
    }

    public static BaseGateBlock from(Block source, WoodType type) {
        return new Wood(source, type);
    }

    public static class Wood
    extends BaseGateBlock
    implements BehaviourWood {
        public Wood(Block source, WoodType type) {
            super(source, type);
        }
    }
}

