/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.wover.block.api.BlockTagProvider;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.betterx.wover.item.api.ItemTagProvider;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;

public abstract class BaseDoorBlock
extends DoorBlock
implements RenderLayerProvider,
BlockModelProvider,
BlockTagProvider,
ItemTagProvider {
    protected BaseDoorBlock(Block source, BlockSetType type) {
        this(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)source).strength(3.0f, 3.0f).noOcclusion(), type);
    }

    protected BaseDoorBlock(BlockBehaviour.Properties properties, BlockSetType type) {
        super(type, properties);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        if (state.getValue((Property)HALF) == DoubleBlockHalf.LOWER) {
            return Collections.singletonList(new ItemStack((ItemLike)this.asItem()));
        }
        return Collections.emptyList();
    }

    @Override
    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    @Environment(value=EnvType.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        generator.vanillaGenerator.createDoor((Block)this);
    }

    public void registerBlockTags(ResourceLocation location, TagBootstrapContext<Block> context) {
        context.add((Object)this, new TagKey[]{BlockTags.DOORS});
    }

    public void registerItemTags(ResourceLocation location, ItemTagBootstrapContext context) {
        context.add((ItemLike)this, new TagKey[]{ItemTags.DOORS});
    }

    public static BaseDoorBlock from(Block source, BlockSetType type) {
        return BehaviourHelper.from(source, type, Wood::new, Stone::new, Metal::new);
    }

    public static class Stone
    extends BaseDoorBlock
    implements BehaviourStone {
        public Stone(Block source, BlockSetType type) {
            super(source, type);
        }

        public Stone(BlockBehaviour.Properties properties, BlockSetType type) {
            super(properties, type);
        }
    }

    public static class Metal
    extends BaseDoorBlock
    implements BehaviourMetal {
        public Metal(Block source, BlockSetType type) {
            super(source, type);
        }

        public Metal(BlockBehaviour.Properties properties, BlockSetType type) {
            super(properties, type);
        }
    }

    public static class Wood
    extends BaseDoorBlock
    implements BehaviourWood {
        public Wood(Block source, BlockSetType type) {
            super(source, type);
        }

        public Wood(BlockBehaviour.Properties properties, BlockSetType type) {
            super(properties, type);
        }

        @Override
        public void registerBlockTags(ResourceLocation location, TagBootstrapContext<Block> context) {
            context.add((Object)this, new TagKey[]{BlockTags.DOORS, BlockTags.WOODEN_DOORS});
        }

        @Override
        public void registerItemTags(ResourceLocation location, ItemTagBootstrapContext context) {
            context.add((ItemLike)this, new TagKey[]{ItemTags.DOORS, ItemTags.WOODEN_DOORS});
        }
    }
}

