/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.blocks.BasePlantBlock;
import org.betterx.bclib.interfaces.SurvivesOnBlocks;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.wover.loot.api.BlockLootProvider;
import org.betterx.wover.loot.api.LootLookupProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseCropBlock
extends BasePlantBlock
implements SurvivesOnBlocks,
BlockLootProvider {
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)3);
    private static final VoxelShape SHAPE = BaseCropBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    private final List<Block> terrain;
    private final Item drop;

    public BaseCropBlock(Item drop, Block ... terrain) {
        this(BehaviourBuilders.createPlant().randomTicks().sound(SoundType.CROP).offsetType(BlockBehaviour.OffsetType.XZ), drop, terrain);
    }

    protected BaseCropBlock(BlockBehaviour.Properties properties, Item drop, Block ... terrain) {
        super(properties);
        this.drop = drop;
        this.terrain = List.of(terrain);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{AGE});
    }

    @Override
    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int age = (Integer)state.getValue((Property)AGE);
        if (age < 3) {
            BlocksHelper.setWithUpdate((LevelAccessor)level, pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
        }
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 3;
    }

    @Override
    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 3;
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(state, world, pos, random);
        if (this.isBonemealSuccess((Level)world, random, pos, state) && random.nextInt(8) == 0) {
            this.performBonemeal(world, random, pos, state);
        }
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    @Override
    public List<Block> getSurvivableBlocks() {
        return this.terrain;
    }

    @Override
    public boolean isTerrain(BlockState state) {
        return SurvivesOnBlocks.super.isTerrain(state);
    }

    @Override
    @Nullable
    public LootTable.Builder registerBlockLoot(@NotNull ResourceLocation location, @NotNull LootLookupProvider provider, @NotNull ResourceKey<LootTable> tableKey) {
        return provider.dropPlant((Block)this, (ItemLike)this.drop, (NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f), (ItemLike)this, (NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f), 0.571f, 3, AGE, 3);
    }
}

