/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.wover.block.api.BlockTagProvider;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;
import org.betterx.wover.tag.api.predefined.CommonPoiTags;

public abstract class BaseComposterBlock
extends ComposterBlock
implements BlockModelProvider,
BlockTagProvider,
DropSelfLootProvider<BaseComposterBlock> {
    protected BaseComposterBlock(Block source) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)source));
    }

    @Environment(value=EnvType.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        generator.createComposter((Block)this);
    }

    public void registerBlockTags(ResourceLocation location, TagBootstrapContext<Block> context) {
        context.add((Object)this, new TagKey[]{CommonBlockTags.COMPOSTER, CommonPoiTags.FARMER_WORKSTATION});
    }

    public static BaseComposterBlock from(Block source) {
        return new Wood(source);
    }

    public static class Wood
    extends BaseComposterBlock
    implements BehaviourWood {
        public Wood(Block source) {
            super(source);
        }

        @Override
        public void registerBlockTags(ResourceLocation location, TagBootstrapContext<Block> context) {
            context.add((Object)this, new TagKey[]{CommonBlockTags.COMPOSTER, CommonBlockTags.WOODEN_COMPOSTER, CommonPoiTags.FARMER_WORKSTATION});
        }
    }
}

