/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.client.models.BCLModels;
import org.betterx.bclib.registry.BaseBlockEntities;
import org.betterx.wover.block.api.BlockTagProvider;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.betterx.wover.item.api.ItemTagProvider;
import org.betterx.wover.loot.api.BlockLootProvider;
import org.betterx.wover.loot.api.LootLookupProvider;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;
import org.betterx.wover.tag.api.predefined.CommonItemTags;
import org.jetbrains.annotations.NotNull;

public abstract class BaseChestBlock
extends ChestBlock
implements BlockModelProvider,
BlockTagProvider,
ItemTagProvider,
BlockLootProvider {
    private final Block parent;

    protected BaseChestBlock(Block source) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)source).noOcclusion(), () -> BaseBlockEntities.CHEST);
        this.parent = source;
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return BaseBlockEntities.CHEST.create(blockPos, blockState);
    }

    public void provideBlockModels(WoverBlockModelGenerators generator) {
        generator.createChest(this.parent, (Block)this);
        generator.createItemModel((Block)this, BCLModels.CHEST_ITEM, new TextureMapping().put(TextureSlot.TEXTURE, BuiltInRegistries.BLOCK.getKey((Object)this).withPrefix("entity/chest/")));
    }

    public void registerBlockTags(ResourceLocation location, TagBootstrapContext<Block> context) {
        context.add((Object)this, new TagKey[]{CommonBlockTags.CHEST});
    }

    public void registerItemTags(ResourceLocation location, ItemTagBootstrapContext context) {
        context.add((ItemLike)this, new TagKey[]{CommonItemTags.CHEST});
    }

    public LootTable.Builder registerBlockLoot(@NotNull ResourceLocation location, @NotNull LootLookupProvider provider, @NotNull ResourceKey<LootTable> tableKey) {
        LootTable.Builder builder = LootTable.lootTable();
        LootPool.Builder pool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)this).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.CUSTOM_NAME).include(DataComponents.CONTAINER).include(DataComponents.LOCK).include(DataComponents.CONTAINER_LOOT))).when(ExplosionCondition.survivesExplosion());
        builder.setRandomSequence(((ResourceKey)this.asItem().builtInRegistryHolder().unwrapKey().orElseThrow()).location());
        return builder.withPool(pool);
    }

    protected List<ItemStack> getDrops(BlockState blockState, LootParams.Builder builder) {
        return super.getDrops(blockState, builder);
    }

    public static BaseChestBlock from(Block source) {
        return new Wood(source);
    }

    public static class Wood
    extends BaseChestBlock
    implements BehaviourWood {
        public Wood(Block source) {
            super(source);
        }

        @Override
        public void registerBlockTags(ResourceLocation location, TagBootstrapContext<Block> context) {
            context.add((Object)this, new TagKey[]{CommonBlockTags.CHEST, CommonBlockTags.WOODEN_CHEST});
        }

        @Override
        public void registerItemTags(ResourceLocation location, ItemTagBootstrapContext context) {
            context.add((ItemLike)this, new TagKey[]{CommonItemTags.CHEST, CommonItemTags.WOODEN_CHEST});
        }
    }
}

