/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.storage.loot.LootTable;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.betterx.wover.loot.api.BlockLootProvider;
import org.betterx.wover.loot.api.LootLookupProvider;
import org.jetbrains.annotations.NotNull;

public class BaseBlock
extends Block
implements BlockLootProvider,
BlockModelProvider {
    public BaseBlock(BlockBehaviour.Properties settings) {
        this(settings, false);
    }

    protected BaseBlock(BlockBehaviour.Properties settings, boolean emptyLootTable) {
        super(emptyLootTable ? settings.noLootTable() : settings);
    }

    static BlockBehaviour.Properties acceptAndReturn(Consumer<BlockBehaviour.Properties> customizeProperties, BlockBehaviour.Properties settings) {
        customizeProperties.accept(settings);
        return settings;
    }

    @Environment(value=EnvType.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        generator.createCubeModel((Block)this);
    }

    public LootTable.Builder registerBlockLoot(@NotNull ResourceLocation location, @NotNull LootLookupProvider provider, @NotNull ResourceKey<LootTable> tableKey) {
        return provider.drop((ItemLike)this);
    }

    public static class Metal
    extends BaseBlock
    implements BehaviourMetal {
        public Metal(BlockBehaviour.Properties settings) {
            super(settings);
        }
    }

    public static class Stone
    extends BaseBlock
    implements BehaviourStone {
        public Stone(BlockBehaviour.Properties settings) {
            super(settings);
        }
    }

    public static class Wood
    extends BaseBlock
    implements BehaviourWood {
        public Wood(BlockBehaviour.Properties settings) {
            super(settings);
        }
    }
}

