/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.behaviours.interfaces.BehaviourGlass;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.util.BlocksHelper;

public abstract class BaseAttachedBlock
extends BaseBlockNotFull {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;

    protected BaseAttachedBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.UP));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction[] directions;
        BlockState blockState = this.defaultBlockState();
        Level worldView = ctx.getLevel();
        BlockPos blockPos = ctx.getClickedPos();
        for (Direction direction : directions = ctx.getNearestLookingDirections()) {
            Direction direction2 = direction.getOpposite();
            if (!(blockState = (BlockState)blockState.setValue((Property)FACING, (Comparable)direction2)).canSurvive((LevelReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockPos = pos.relative(direction.getOpposite());
        return BaseAttachedBlock.canSupportCenter((LevelReader)world, (BlockPos)blockPos, (Direction)direction) || world.getBlockState(blockPos).is(BlockTags.LEAVES);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (Property<Direction>)FACING);
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal(state, mirror, (Property<Direction>)FACING);
    }

    public static class Glass
    extends BaseAttachedBlock
    implements BehaviourGlass {
        public Glass(BlockBehaviour.Properties settings) {
            super(settings);
        }
    }

    public static class Metal
    extends BaseAttachedBlock
    implements BehaviourMetal {
        public Metal(BlockBehaviour.Properties settings) {
            super(settings);
        }
    }

    public static class Stone
    extends BaseAttachedBlock
    implements BehaviourStone {
        public Stone(BlockBehaviour.Properties settings) {
            super(settings);
        }
    }

    public static class Wood
    extends BaseAttachedBlock
    implements BehaviourWood {
        public Wood(BlockBehaviour.Properties settings) {
            super(settings);
        }
    }
}

