/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.datagen;

import com.mojang.serialization.Codec;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.ResourceKey;
import org.betterx.bclib.BCLib;
import org.jetbrains.annotations.Nullable;

public abstract class RegistrySupplier {
    private static final int MAX_PERMITS = 2000;
    private final Semaphore BOOTSTRAP_LOCK = new Semaphore(2000);
    public final Semaphore MAIN_LOCK = new Semaphore(1);
    final List<RegistryInfo<?>> allRegistries;
    @Nullable
    List<String> defaultModIDs;

    protected RegistrySupplier(@Nullable List<String> defaultModIDs) {
        this.defaultModIDs = defaultModIDs;
        this.allRegistries = this.initializeRegistryList(defaultModIDs);
        try {
            this.BOOTSTRAP_LOCK.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract List<RegistryInfo<?>> initializeRegistryList(@Nullable List<String> var1);

    public void bootstrapRegistries(RegistrySetBuilder registryBuilder) {
        for (RegistryInfo<?> nfo : this.allRegistries) {
            nfo.add(registryBuilder, this.BOOTSTRAP_LOCK);
        }
        this.BOOTSTRAP_LOCK.release();
    }

    void acquireLock() {
        try {
            this.BOOTSTRAP_LOCK.acquire(2000);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    void releaseLock() {
        this.BOOTSTRAP_LOCK.release(2000);
    }

    public final class RegistryInfo<T> {
        public static final List<String> UNFILTERED = null;
        public final RegistryDataLoader.RegistryData<T> data;
        public final List<String> modIDs;
        public final RegistrySetBuilder.RegistryBootstrap<T> registryBootstrap;

        public RegistryInfo(RegistrySupplier this$0, RegistryDataLoader.RegistryData<T> data, List<String> modIDs, RegistrySetBuilder.RegistryBootstrap<T> registryBootstrap) {
            this.data = data;
            this.modIDs = modIDs;
            this.registryBootstrap = registryBootstrap;
        }

        public RegistryInfo(RegistrySupplier this$0, ResourceKey<? extends Registry<T>> key, Codec<T> elementCodec, RegistrySetBuilder.RegistryBootstrap<T> registryBootstrap) {
            this(this$0, new RegistryDataLoader.RegistryData(key, elementCodec), this$0.defaultModIDs, registryBootstrap);
        }

        public RegistryInfo(RegistrySupplier this$0, ResourceKey<? extends Registry<T>> key, Codec<T> elementCodec, RegistrySetBuilder.RegistryBootstrap<T> registryBootstrap, String ... modIDs) {
            this(this$0, new RegistryDataLoader.RegistryData(key, elementCodec), List.of(modIDs), registryBootstrap);
        }

        public RegistryInfo(RegistrySupplier this$0, ResourceKey<? extends Registry<T>> key, Codec<T> elementCodec, RegistrySetBuilder.RegistryBootstrap<T> registryBootstrap, List<String> modIDs) {
            this(this$0, new RegistryDataLoader.RegistryData(key, elementCodec), modIDs, registryBootstrap);
        }

        public RegistryInfo(RegistrySupplier this$0, ResourceKey<? extends Registry<T>> key, Codec<T> elementCodec) {
            this(this$0, new RegistryDataLoader.RegistryData(key, elementCodec), this$0.defaultModIDs, null);
        }

        public RegistryInfo(RegistrySupplier this$0, ResourceKey<? extends Registry<T>> key, Codec<T> elementCodec, String ... modIDs) {
            this(this$0, new RegistryDataLoader.RegistryData(key, elementCodec), List.of(modIDs), null);
        }

        public RegistryInfo(RegistrySupplier this$0, ResourceKey<? extends Registry<T>> key, Codec<T> elementCodec, List<String> modIDs) {
            this(this$0, new RegistryDataLoader.RegistryData(key, elementCodec), modIDs, null);
        }

        public ResourceKey<? extends Registry<T>> key() {
            return this.data.key();
        }

        public Codec<T> elementCodec() {
            return this.data.elementCodec();
        }

        List<Holder<T>> allElements(HolderLookup.Provider registryAccess) {
            HolderLookup.RegistryLookup registry = registryAccess.lookupOrThrow(this.key());
            return registry.listElementIds().filter(k -> this.modIDs == null || this.modIDs.contains(k.location().getNamespace())).map(k -> (Holder)registry.get(k).orElseThrow()).toList();
        }

        private void add(RegistrySetBuilder registryBuilder, Semaphore LOCK_BOOSTRAP) {
            try {
                LOCK_BOOSTRAP.acquire();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            BCLib.LOGGER.info("Adding:" + String.valueOf(this.key()));
            registryBuilder.add(this.key(), ctx -> {
                if (this.registryBootstrap != null) {
                    this.registryBootstrap.run(ctx);
                }
                LOCK_BOOSTRAP.release();
            });
        }

        public RegistryDataLoader.RegistryData<T> data() {
            return this.data;
        }

        public List<String> modIDs() {
            return this.modIDs;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            RegistryInfo that = (RegistryInfo)obj;
            return Objects.equals(this.data, that.data) && Objects.equals(this.modIDs, that.modIDs);
        }

        public int hashCode() {
            return Objects.hash(this.data, this.modIDs);
        }

        public String toString() {
            return "RegistryInfo[data=" + String.valueOf(this.data) + ", modIDs=" + String.valueOf(this.modIDs) + "]";
        }
    }

    public class InfoList
    extends LinkedList<RegistryInfo<?>> {
        public <T> void add(ResourceKey<? extends Registry<T>> key, Codec<T> elementCodec) {
            this.add(new RegistryInfo<T>(RegistrySupplier.this, key, elementCodec));
        }

        public <T> void add(ResourceKey<? extends Registry<T>> key, Codec<T> elementCodec, String ... modIDs) {
            this.add(new RegistryInfo<T>(RegistrySupplier.this, key, elementCodec, modIDs));
        }

        public <T> void add(ResourceKey<? extends Registry<T>> key, Codec<T> elementCodec, List<String> modIDs) {
            this.add(new RegistryInfo<T>(RegistrySupplier.this, key, elementCodec, modIDs));
        }

        public <T> void addUnfiltered(ResourceKey<? extends Registry<T>> key, Codec<T> elementCodec) {
            this.add(new RegistryInfo<T>(RegistrySupplier.this, key, elementCodec, RegistryInfo.UNFILTERED));
        }

        public <T> void add(ResourceKey<? extends Registry<T>> key, Codec<T> elementCodec, RegistrySetBuilder.RegistryBootstrap<T> registryBootstrap) {
            this.add(new RegistryInfo<T>(RegistrySupplier.this, key, elementCodec, registryBootstrap));
        }

        public <T> void add(ResourceKey<? extends Registry<T>> key, Codec<T> elementCodec, RegistrySetBuilder.RegistryBootstrap<T> registryBootstrap, String ... modIDs) {
            this.add(new RegistryInfo<T>(RegistrySupplier.this, key, elementCodec, registryBootstrap, modIDs));
        }

        public <T> void add(ResourceKey<? extends Registry<T>> key, Codec<T> elementCodec, RegistrySetBuilder.RegistryBootstrap<T> registryBootstrap, List<String> modIDs) {
            this.add(new RegistryInfo<T>(RegistrySupplier.this, key, elementCodec, registryBootstrap, modIDs));
        }

        public <T> void addUnfiltered(ResourceKey<? extends Registry<T>> key, Codec<T> elementCodec, RegistrySetBuilder.RegistryBootstrap<T> registryBootstrap) {
            this.add(new RegistryInfo<T>(RegistrySupplier.this, key, elementCodec, registryBootstrap, RegistryInfo.UNFILTERED));
        }

        public <T> void addBootstrapOnly(ResourceKey<? extends Registry<T>> key, Codec<T> elementCodec, RegistrySetBuilder.RegistryBootstrap<T> registryBootstrap) {
            this.add(new RegistryInfo<T>(RegistrySupplier.this, key, elementCodec, registryBootstrap, List.of()));
        }
    }
}

