/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.bonemeal;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.api.v3.bonemeal.TaggedBonemealBlockSpreader;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.WeightedList;

public class WaterGrassSpreader
extends TaggedBonemealBlockSpreader {
    public WaterGrassSpreader(TagKey<Block> sourceBlockTag) {
        super(sourceBlockTag);
    }

    @Override
    public boolean canSpreadAt(BlockGetter blockGetter, BlockPos blockPos) {
        BlockState stateAbove = blockGetter.getBlockState(blockPos.above());
        return !stateAbove.getFluidState().isEmpty() && stateAbove.is(Blocks.WATER);
    }

    @Override
    public boolean isValidBonemealSpreadTarget(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, boolean bl) {
        return this.canSpreadAt(blockGetter, blockPos);
    }

    @Override
    public boolean performBonemealSpread(ServerLevel level, RandomSource randomSource, BlockPos pos, BlockState blockState) {
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
        WeightedList sourceSet = new WeightedList();
        BuiltInRegistries.BLOCK.getTagOrEmpty(this.blockTag).forEach(c -> sourceSet.add(c, 1.0f));
        int y1 = pos.getY() + 3;
        int y2 = pos.getY() - 3;
        boolean result = false;
        block0: for (int i = 0; i < 64; i = (int)((byte)(i + 1))) {
            int x = (int)((double)pos.getX() + level.random.nextGaussian() * 2.0);
            int z = (int)((double)pos.getZ() + level.random.nextGaussian() * 2.0);
            currentPos.setX(x);
            currentPos.setZ(z);
            for (int y = y1; y >= y2; --y) {
                currentPos.setY(y);
                BlockPos down = currentPos.below();
                if (!BlocksHelper.isFluid(level.getBlockState((BlockPos)currentPos)) || BlocksHelper.isFluid(level.getBlockState(down))) continue;
                Holder grass = (Holder)sourceSet.get(randomSource);
                if (!grass.isBound() || !((Block)grass.value()).canSurvive(((Block)grass.value()).defaultBlockState(), (LevelReader)level, (BlockPos)currentPos)) continue block0;
                level.setBlock((BlockPos)currentPos, ((Block)grass.value()).defaultBlockState(), 18);
                result = true;
                continue block0;
            }
        }
        return result;
    }
}

