/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.bonemeal;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import org.betterx.wover.feature.api.FeatureUtils;
import org.jetbrains.annotations.Nullable;

public interface BonemealNyliumLike
extends BonemealableBlock {
    public Block getHostBlock();

    @Nullable
    public Holder<? extends ConfiguredFeature<?, ? extends Feature<?>>> getCoverFeature();

    default public boolean isValidBonemealTarget(LevelReader blockGetter, BlockPos blockPos, BlockState blockState) {
        return blockGetter.getBlockState(blockPos.above()).isAir();
    }

    default public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    default public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        Holder<? extends ConfiguredFeature<?, ? extends Feature<?>>> feature;
        BlockState currentState = serverLevel.getBlockState(blockPos);
        if (currentState.is(this.getHostBlock()) && (feature = this.getCoverFeature()) != null) {
            FeatureUtils.placeInWorld((ConfiguredFeature)((ConfiguredFeature)feature.value()), (WorldGenLevel)serverLevel, (BlockPos)blockPos.above(), (RandomSource)randomSource, (boolean)false);
        }
    }
}

