/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.bonemeal;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import org.betterx.bclib.api.v3.bonemeal.BonemealBlockSpreader;

abstract class BlockSpreader
implements BonemealBlockSpreader {
    BlockSpreader() {
    }

    protected abstract boolean isValidSource(BlockState var1);

    protected abstract boolean hasCustomBehaviour(BlockState var1);

    @Override
    public boolean isValidBonemealSpreadTarget(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, boolean bl) {
        if (!this.canSpreadAt(blockGetter, blockPos)) {
            return false;
        }
        for (BlockPos testPos : BlockPos.betweenClosed((BlockPos)blockPos.offset(-1, -1, -1), (BlockPos)blockPos.offset(1, 1, 1))) {
            BlockState state = blockGetter.getBlockState(testPos);
            if (!this.isValidSource(state) || !this.hasCustomBehaviour(state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean performBonemealSpread(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        HashMap<BlockState, Integer> sourceBlocks = new HashMap<BlockState, Integer>();
        for (Object testPos : BlockPos.betweenClosed((BlockPos)blockPos.offset(-1, -1, -1), (BlockPos)blockPos.offset(1, 1, 1))) {
            BlockState blockState2 = serverLevel.getBlockState((BlockPos)testPos);
            if (!this.isValidSource(blockState2)) continue;
            sourceBlocks.compute(blockState2, (k, v) -> {
                if (v == null) {
                    return 1;
                }
                return v + 1;
            });
        }
        SimpleWeightedRandomList.Builder builder = new SimpleWeightedRandomList.Builder();
        for (Map.Entry entry : sourceBlocks.entrySet()) {
            builder.add((Object)((BlockState)entry.getKey()), ((Integer)entry.getValue()).intValue());
        }
        WeightedStateProvider provider = new WeightedStateProvider(builder.build());
        BlockState blockState3 = provider.getState(randomSource, blockPos);
        if (blockState3 != null) {
            serverLevel.setBlock(blockPos, blockState3, 3);
            return true;
        }
        return false;
    }
}

