/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.structures;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class StructureWorld {
    private final Map<ChunkPos, Part> parts = Maps.newHashMap();
    private ChunkPos lastPos;
    private Part lastPart;
    private int minX = Integer.MAX_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int minZ = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private int maxZ = Integer.MIN_VALUE;

    public StructureWorld() {
    }

    public StructureWorld(CompoundTag tag) {
        this.minX = tag.getInt("minX");
        this.maxX = tag.getInt("maxX");
        this.minY = tag.getInt("minY");
        this.maxY = tag.getInt("maxY");
        this.minZ = tag.getInt("minZ");
        this.maxZ = tag.getInt("maxZ");
        ListTag map = tag.getList("parts", 10);
        map.forEach(element -> {
            CompoundTag compound = (CompoundTag)element;
            Part part = new Part(compound);
            int x = compound.getInt("x");
            int z = compound.getInt("z");
            this.parts.put(new ChunkPos(x, z), part);
        });
    }

    public void setBlock(BlockPos pos, BlockState state) {
        ChunkPos cPos = new ChunkPos(pos);
        if (cPos.equals((Object)this.lastPos)) {
            this.lastPart.addBlock(pos, state);
            return;
        }
        Part part = this.parts.get(cPos);
        if (part == null) {
            part = new Part();
            this.parts.put(cPos, part);
            if (cPos.x < this.minX) {
                this.minX = cPos.x;
            }
            if (cPos.x > this.maxX) {
                this.maxX = cPos.x;
            }
            if (cPos.z < this.minZ) {
                this.minZ = cPos.z;
            }
            if (cPos.z > this.maxZ) {
                this.maxZ = cPos.z;
            }
        }
        if (pos.getY() < this.minY) {
            this.minY = pos.getY();
        }
        if (pos.getY() > this.maxY) {
            this.maxY = pos.getY();
        }
        part.addBlock(pos, state);
        this.lastPos = cPos;
        this.lastPart = part;
    }

    public boolean placeChunk(WorldGenLevel world, ChunkPos chunkPos) {
        Part part = this.parts.get(chunkPos);
        if (part != null) {
            ChunkAccess chunk = world.getChunk(chunkPos.x, chunkPos.z);
            part.placeChunk(chunk);
            return true;
        }
        return false;
    }

    public CompoundTag toBNT() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("minX", this.minX);
        tag.putInt("maxX", this.maxX);
        tag.putInt("minY", this.minY);
        tag.putInt("maxY", this.maxY);
        tag.putInt("minZ", this.minZ);
        tag.putInt("maxZ", this.maxZ);
        ListTag map = new ListTag();
        tag.put("parts", (Tag)map);
        this.parts.forEach((pos, part) -> map.add((Object)part.toNBT(pos.x, pos.z)));
        return tag;
    }

    public BoundingBox getBounds() {
        if (this.minX == Integer.MAX_VALUE || this.maxX == Integer.MIN_VALUE || this.minZ == Integer.MAX_VALUE || this.maxZ == Integer.MIN_VALUE) {
            return BoundingBox.infinite();
        }
        return new BoundingBox(this.minX << 4, this.minY, this.minZ << 4, this.maxX << 4 | 0xF, this.maxY, this.maxZ << 4 | 0xF);
    }

    private static final class Part {
        Map<BlockPos, BlockState> blocks = Maps.newHashMap();

        public Part() {
        }

        public Part(CompoundTag tag) {
            ListTag map = tag.getList("blocks", 10);
            ListTag map2 = tag.getList("states", 10);
            BlockState[] states = new BlockState[map2.size()];
            for (int i = 0; i < states.length; ++i) {
                states[i] = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)((CompoundTag)map2.get(i)));
            }
            map.forEach(element -> {
                CompoundTag block = (CompoundTag)element;
                BlockPos pos = NbtUtils.readBlockPos((CompoundTag)block, (String)"pos").orElse(null);
                if (pos != null) {
                    int stateID = block.getInt("state");
                    BlockState state = stateID < states.length ? states[stateID] : Block.stateById((int)stateID);
                    this.blocks.put(pos, state);
                }
            });
        }

        void addBlock(BlockPos pos, BlockState state) {
            BlockPos inner = new BlockPos(pos.getX() & 0xF, pos.getY(), pos.getZ() & 0xF);
            this.blocks.put(inner, state);
        }

        void placeChunk(ChunkAccess chunk) {
            this.blocks.forEach((pos, state) -> chunk.setBlockState(pos, state, false));
        }

        CompoundTag toNBT(int x, int z) {
            CompoundTag tag = new CompoundTag();
            tag.putInt("x", x);
            tag.putInt("z", z);
            ListTag map = new ListTag();
            tag.put("blocks", (Tag)map);
            ListTag stateMap = new ListTag();
            tag.put("states", (Tag)stateMap);
            int[] id = new int[1];
            HashMap states = Maps.newHashMap();
            this.blocks.forEach((pos, state) -> {
                int stateID = states.getOrDefault(states, -1);
                if (stateID < 0) {
                    int n = id[0];
                    id[0] = n + 1;
                    stateID = n;
                    states.put(state, stateID);
                    stateMap.add((Object)NbtUtils.writeBlockState((BlockState)state));
                }
                CompoundTag block = new CompoundTag();
                block.put("pos", NbtUtils.writeBlockPos((BlockPos)pos));
                block.putInt("state", stateID);
                map.add((Object)block);
            });
            return tag;
        }
    }
}

