/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.structures;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.betterx.bclib.BCLib;
import org.jetbrains.annotations.Nullable;
import org.sinytra.connector.mod.ConnectorMod;

public class StructureNBT {
    public final ResourceLocation location;
    protected StructureTemplate structure;
    private static final Map<ResourceLocation, StructureNBT> STRUCTURE_CACHE = Maps.newHashMap();
    private static final Map<ResourceLocation, StructureTemplate> READER_CACHE = Maps.newHashMap();

    protected StructureNBT(ResourceLocation location) {
        this.location = location;
        this.structure = StructureNBT.readStructureFromJar(location);
    }

    protected StructureNBT(ResourceLocation location, StructureTemplate structure) {
        this.location = location;
        this.structure = structure;
    }

    public static Rotation getRandomRotation(RandomSource random) {
        return Rotation.getRandom((RandomSource)random);
    }

    public static Mirror getRandomMirror(RandomSource random) {
        return Mirror.values()[random.nextInt(3)];
    }

    public static StructureNBT create(ResourceLocation location) {
        return STRUCTURE_CACHE.computeIfAbsent(location, r -> new StructureNBT((ResourceLocation)r));
    }

    public boolean generateCentered(ServerLevelAccessor world, BlockPos pos, Rotation rotation, Mirror mirror) {
        BlockPos newPos = this.getCenteredPos(pos, rotation, mirror);
        if (newPos == null) {
            return false;
        }
        StructurePlaceSettings data = new StructurePlaceSettings().setRotation(rotation).setMirror(mirror);
        this.structure.placeInWorld(world, newPos, newPos, data, world.getRandom(), 18);
        return true;
    }

    public boolean generateAt(ServerLevelAccessor world, BlockPos pos, Rotation rotation, Mirror mirror) {
        StructurePlaceSettings data = new StructurePlaceSettings().setRotation(rotation).setMirror(mirror);
        this.structure.placeInWorld(world, pos, pos, data, world.getRandom(), 18);
        return true;
    }

    @Nullable
    private BlockPos getCenteredPos(BlockPos pos, Rotation rotation, Mirror mirror) {
        if (this.structure == null) {
            BCLib.LOGGER.error("No structure: " + this.location.toString());
            return null;
        }
        BlockPos.MutableBlockPos blockpos2 = new BlockPos.MutableBlockPos().set(this.structure.getSize());
        if (mirror == Mirror.FRONT_BACK) {
            blockpos2.setX(-blockpos2.getX());
        }
        if (mirror == Mirror.LEFT_RIGHT) {
            blockpos2.setZ(-blockpos2.getZ());
        }
        blockpos2.set((Vec3i)blockpos2.rotate(rotation));
        return pos.offset(-blockpos2.getX() >> 1, 0, -blockpos2.getZ() >> 1);
    }

    private static StructureTemplate readStructureFromJar(ResourceLocation resource) {
        return READER_CACHE.computeIfAbsent(resource, r -> StructureNBT._readStructureFromJar(r));
    }

    private static String getStructurePath(ResourceLocation resource) {
        return "data/" + resource.getNamespace() + "/structure/" + resource.getPath();
    }

    private static StructureTemplate _readStructureFromJar(ResourceLocation resource) {
        try {
            InputStream inputstream = ConnectorMod.getModResourceAsStream(MinecraftServer.class, (String)("/" + StructureNBT.getStructurePath(resource) + ".nbt"));
            return StructureNBT.readStructureFromStream(inputstream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<StructureNBT> createResourcesFrom(ResourceLocation resource, int recursionDepth) {
        String ns = resource.getNamespace();
        String nm = resource.getPath();
        String resourceFolder = StructureNBT.getStructurePath(resource);
        URL url = MinecraftServer.class.getClassLoader().getResource(resourceFolder);
        if (url != null) {
            Path myPath;
            URI uri;
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException e) {
                BCLib.LOGGER.error("Unable to load Resources: ", (Exception)e);
                return null;
            }
            if (uri.getScheme().equals("jar")) {
                FileSystem fileSystem = null;
                try {
                    fileSystem = FileSystems.getFileSystem(uri);
                }
                catch (FileSystemNotFoundException notLoaded) {
                    try {
                        fileSystem = FileSystems.newFileSystem(uri, new HashMap());
                    }
                    catch (IOException e) {
                        BCLib.LOGGER.error("Unable to load Filesystem: ", (Exception)e);
                        return null;
                    }
                }
                myPath = fileSystem.getPath(resourceFolder, new String[0]);
            } else {
                myPath = Paths.get(uri);
            }
            if (Files.isDirectory(myPath, new LinkOption[0])) {
                try {
                    return Files.walk(myPath, recursionDepth <= 0 ? Integer.MAX_VALUE : recursionDepth, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0])).map(p -> {
                        if (p.isAbsolute()) {
                            return Path.of(uri).relativize((Path)p).toString();
                        }
                        return p.toString().replace(resourceFolder, "").replaceAll("^/+", "");
                    }).filter(s -> s.endsWith(".nbt")).map(s -> ResourceLocation.fromNamespaceAndPath((String)ns, (String)((String)(nm.isEmpty() ? "" : nm + "/") + s.substring(0, s.length() - 4)))).sorted(Comparator.comparing(ResourceLocation::toString)).map(r -> {
                        BCLib.LOGGER.info("Loading Structure: " + String.valueOf(r));
                        try {
                            return StructureNBT.create(r);
                        }
                        catch (Exception e) {
                            BCLib.LOGGER.error("Unable to load Structure " + String.valueOf(r), e);
                            return null;
                        }
                    }).toList();
                }
                catch (IOException e) {
                    BCLib.LOGGER.error("Unable to load Resources: ", (Exception)e);
                    return null;
                }
            }
        }
        return null;
    }

    private static StructureTemplate readStructureFromStream(InputStream stream) throws IOException {
        CompoundTag nbttagcompound = NbtIo.readCompressed((InputStream)stream, (NbtAccounter)NbtAccounter.unlimitedHeap());
        StructureTemplate template = new StructureTemplate();
        template.load((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), nbttagcompound);
        return template;
    }

    public BlockPos getSize(Rotation rotation) {
        if (rotation == Rotation.NONE || rotation == Rotation.CLOCKWISE_180) {
            return new BlockPos(this.structure.getSize());
        }
        Vec3i size = this.structure.getSize();
        int x = size.getX();
        int z = size.getZ();
        return new BlockPos(z, size.getY(), x);
    }

    public String getName() {
        return this.location.getPath();
    }

    public BoundingBox getBoundingBox(BlockPos pos, Rotation rotation, Mirror mirror) {
        return this.structure.getBoundingBox(new StructurePlaceSettings().setRotation(rotation).setMirror(mirror), pos);
    }

    public BoundingBox getCenteredBoundingBox(BlockPos pos, Rotation rotation, Mirror mirror) {
        return this.structure.getBoundingBox(new StructurePlaceSettings().setRotation(rotation).setMirror(mirror), this.getCenteredPos(pos, rotation, mirror));
    }
}

