/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.datafixer;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.zip.ZipException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.EditWorldScreen;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.datafixer.MigrationProfile;
import org.betterx.bclib.api.v2.datafixer.Patch;
import org.betterx.bclib.api.v2.datafixer.PatchDidiFailException;
import org.betterx.bclib.client.gui.screens.AtomicProgressListener;
import org.betterx.bclib.client.gui.screens.ConfirmFixScreen;
import org.betterx.bclib.client.gui.screens.LevelFixErrorScreen;
import org.betterx.bclib.client.gui.screens.ProgressScreen;
import org.betterx.bclib.config.Configs;
import org.betterx.wover.core.api.Logger;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.state.api.WorldConfig;
import org.jetbrains.annotations.NotNull;

public class DataFixerAPI {
    static final Logger LOGGER = Logger.create((ModCore)BCLib.C);
    static CompoundTag patchConfTag = null;

    private static boolean wrapCall(LevelStorageSource levelSource, String levelID, Function<LevelStorageSource.LevelStorageAccess, Boolean> runWithLevel) {
        LevelStorageSource.LevelStorageAccess levelStorageAccess;
        try {
            levelStorageAccess = levelSource.createAccess(levelID);
        }
        catch (IOException e) {
            BCLib.LOGGER.warn("Failed to read level {} data", (Object)levelID, (Exception)e);
            SystemToast.onWorldAccessFailure((Minecraft)Minecraft.getInstance(), (String)levelID);
            Minecraft.getInstance().setScreen(null);
            return true;
        }
        boolean returnValue = runWithLevel.apply(levelStorageAccess);
        try {
            levelStorageAccess.close();
        }
        catch (IOException e) {
            BCLib.LOGGER.warn("Failed to unlock access to level {}", (Object)levelID, (Exception)e);
        }
        return returnValue;
    }

    public static boolean fixData(LevelStorageSource levelSource, String levelID, boolean showUI, Consumer<Boolean> onResume) {
        return DataFixerAPI.wrapCall(levelSource, levelID, levelStorageAccess -> DataFixerAPI.fixData(levelStorageAccess, showUI, onResume));
    }

    public static boolean fixData(LevelStorageSource.LevelStorageAccess levelStorageAccess, boolean showUI, Consumer<Boolean> onResume) {
        File levelPath = levelStorageAccess.getLevelPath(LevelResource.ROOT).toFile();
        return DataFixerAPI.fixData(levelPath, levelStorageAccess.getLevelId(), showUI, onResume);
    }

    public static void initializePatchData() {
        DataFixerAPI.getMigrationProfile().markApplied();
        WorldConfig.saveFile((ModCore)BCLib.C);
    }

    @Environment(value=EnvType.CLIENT)
    private static AtomicProgressListener showProgressScreen() {
        ProgressScreen ps = new ProgressScreen(Minecraft.getInstance().screen, (Component)Component.translatable((String)"title.bclib.datafixer.progress"), (Component)Component.translatable((String)"message.bclib.datafixer.progress"));
        Minecraft.getInstance().setScreen((Screen)ps);
        return ps;
    }

    private static void makeBackupAndShowToast(LevelStorageSource storageSource, String levelID) {
        boolean didOpen = false;
        try (LevelStorageSource.LevelStorageAccess access = storageSource.createAccess(levelID);){
            didOpen = true;
            EditWorldScreen.makeBackupAndShowToast((LevelStorageSource.LevelStorageAccess)access);
        }
        catch (IOException ex) {
            if (!didOpen) {
                SystemToast.onWorldAccessFailure((Minecraft)Minecraft.getInstance(), (String)levelID);
            }
            LOGGER.warn("Failed to create backup of level {}", (Object)levelID, (Exception)ex);
        }
    }

    private static boolean fixData(File dir, String levelID, boolean showUI, Consumer<Boolean> onResume) {
        MigrationProfile profile = DataFixerAPI.loadProfileIfNeeded(dir);
        BiConsumer<Boolean, Boolean> runFixes = (createBackup, applyFixes) -> {
            AtomicProgressListener progress = applyFixes.booleanValue() ? (showUI ? DataFixerAPI.showProgressScreen() : new AtomicProgressListener(){
                private long timeStamp = Util.getMillis();
                private AtomicInteger counter = new AtomicInteger(0);

                @Override
                public void incAtomic(int maxProgress) {
                    int percentage = 100 * this.counter.incrementAndGet() / maxProgress;
                    if (Util.getMillis() - this.timeStamp >= 1000L) {
                        this.timeStamp = Util.getMillis();
                        BCLib.LOGGER.info("Patching... {}%", new Object[]{percentage});
                    }
                }

                @Override
                public void resetAtomic() {
                    this.counter = new AtomicInteger(0);
                }

                @Override
                public void stop() {
                }

                @Override
                public void progressStage(Component component) {
                    BCLib.LOGGER.info("Patcher Stage... {}%", new Object[]{component.getString()});
                }
            }) : null;
            Supplier<State> runner = () -> {
                if (createBackup.booleanValue()) {
                    progress.progressStage((Component)Component.translatable((String)"message.bclib.datafixer.progress.waitbackup"));
                    DataFixerAPI.makeBackupAndShowToast(Minecraft.getInstance().getLevelSource(), levelID);
                }
                if (applyFixes.booleanValue()) {
                    return DataFixerAPI.runDataFixes(levelID, dir, profile, progress);
                }
                return new State();
            };
            if (showUI) {
                Thread fixerThread = new Thread(() -> {
                    State state = (State)runner.get();
                    Minecraft.getInstance().execute(() -> {
                        if (profile != null && showUI) {
                            if (state.didFail || state.hasError()) {
                                DataFixerAPI.showLevelFixErrorScreen(state, markFixed -> {
                                    if (markFixed) {
                                        profile.markApplied();
                                    }
                                    onResume.accept((Boolean)applyFixes);
                                });
                            } else {
                                onResume.accept((Boolean)applyFixes);
                            }
                        }
                    });
                });
                fixerThread.start();
            } else {
                State state = runner.get();
                if (state.hasError()) {
                    LOGGER.error("There were Errors while fixing the Level:");
                    LOGGER.error(state.getErrorMessage());
                }
            }
        };
        if (profile != null) {
            if (showUI) {
                DataFixerAPI.showBackupWarning(levelID, runFixes);
                return true;
            }
            BCLib.LOGGER.warn("Applying Fixes on Level");
            runFixes.accept(false, true);
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    private static void showLevelFixErrorScreen(State state, LevelFixErrorScreen.Listener onContinue) {
        Minecraft.getInstance().setScreen((Screen)new LevelFixErrorScreen(Minecraft.getInstance().screen, state.getErrorMessages(), onContinue));
    }

    private static MigrationProfile loadProfileIfNeeded(File levelBaseDir) {
        if (!Configs.MAIN_CONFIG.applyPatches()) {
            LOGGER.info("World Patches are disabled");
            return null;
        }
        MigrationProfile profile = DataFixerAPI.getMigrationProfile();
        profile.runPrePatches(levelBaseDir);
        if (!profile.hasAnyFixes()) {
            LOGGER.info("Everything up to date");
            return null;
        }
        return profile;
    }

    @NotNull
    private static MigrationProfile getMigrationProfile() {
        CompoundTag patchConfig = WorldConfig.getCompoundTag((ModCore)BCLib.C, (String)"patches");
        MigrationProfile profile = Patch.createMigrationData(patchConfig);
        return profile;
    }

    @Environment(value=EnvType.CLIENT)
    static void showBackupWarning(String levelID, BiConsumer<Boolean, Boolean> whenFinished) {
        Minecraft.getInstance().setScreen((Screen)new ConfirmFixScreen(null, whenFinished::accept));
    }

    private static State runDataFixes(String levelID, File dir, MigrationProfile profile, AtomicProgressListener progress) {
        State state = new State();
        progress.resetAtomic();
        progress.progressStage((Component)Component.translatable((String)"message.bclib.datafixer.progress.reading"));
        List<File> players = DataFixerAPI.getAllPlayers(dir);
        List<File> regions = DataFixerAPI.getAllRegions(dir, null);
        int maxProgress = players.size() + regions.size() + 4;
        progress.incAtomic(maxProgress);
        progress.progressStage((Component)Component.translatable((String)"message.bclib.datafixer.progress.players"));
        RegionStorageInfo regionStorageInfo = new RegionStorageInfo(levelID, ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)BCLib.makeID("world_fixer")), "mca");
        players.parallelStream().forEach(file -> {
            DataFixerAPI.fixPlayer(profile, state, file.toPath(), regionStorageInfo);
            progress.incAtomic(maxProgress);
        });
        progress.progressStage((Component)Component.translatable((String)"message.bclib.datafixer.progress.level"));
        DataFixerAPI.fixLevel(profile, state, dir, regionStorageInfo);
        progress.incAtomic(maxProgress);
        progress.progressStage((Component)Component.translatable((String)"message.bclib.datafixer.progress.worlddata"));
        try {
            profile.patchWorldData();
        }
        catch (PatchDidiFailException e) {
            state.didFail = true;
            state.addError("Failed fixing worldconfig (" + e.getMessage() + ")");
            BCLib.LOGGER.error(e.getMessage());
        }
        progress.incAtomic(maxProgress);
        progress.progressStage((Component)Component.translatable((String)"message.bclib.datafixer.progress.regions"));
        regions.parallelStream().forEach(file -> {
            DataFixerAPI.fixRegion(profile, state, file, regionStorageInfo);
            progress.incAtomic(maxProgress);
        });
        if (!state.didFail) {
            progress.progressStage((Component)Component.translatable((String)"message.bclib.datafixer.progress.saving"));
            profile.markApplied();
            WorldConfig.saveFile((ModCore)BCLib.C);
        }
        progress.incAtomic(maxProgress);
        progress.stop();
        return state;
    }

    private static void fixLevel(MigrationProfile profile, State state, File levelBaseDir, RegionStorageInfo regionStorageInfo) {
        try {
            CompoundTag dataTag;
            LOGGER.info("Inspecting level.dat in " + String.valueOf(levelBaseDir));
            CompoundTag level = profile.getLevelDat(levelBaseDir);
            boolean[] changed = new boolean[]{profile.isLevelDatChanged()};
            if (profile.getPrePatchException() != null) {
                throw profile.getPrePatchException();
            }
            if (level.contains("Data") && (dataTag = (CompoundTag)level.get("Data")).contains("Player")) {
                CompoundTag player = (CompoundTag)dataTag.get("Player");
                DataFixerAPI.fixPlayerNbt(player, changed, profile);
            }
            if (changed[0]) {
                LOGGER.warn("Writing '{}'", new Object[]{profile.getLevelDatPath()});
                NbtIo.writeCompressed((CompoundTag)level, (Path)profile.getLevelDatPath());
            }
        }
        catch (Exception e) {
            BCLib.LOGGER.error("Failed fixing Level-Data.");
            state.addError("Failed fixing Level-Data in level.dat (" + e.getMessage() + ")");
            state.didFail = true;
            e.printStackTrace();
        }
    }

    private static void fixPlayer(MigrationProfile data, State state, Path file, RegionStorageInfo regionStorageInfo) {
        try {
            LOGGER.info("Inspecting " + String.valueOf(file));
            CompoundTag player = DataFixerAPI.readNbt(file);
            boolean[] changed = new boolean[]{false};
            DataFixerAPI.fixPlayerNbt(player, changed, data);
            if (changed[0]) {
                LOGGER.warn("Writing '{}'", new Object[]{file});
                NbtIo.writeCompressed((CompoundTag)player, (Path)file);
            }
        }
        catch (Exception e) {
            BCLib.LOGGER.error("Failed fixing Player-Data.");
            state.addError("Failed fixing Player-Data in " + String.valueOf(file.getFileName()) + " (" + e.getMessage() + ")");
            state.didFail = true;
            e.printStackTrace();
        }
    }

    private static void fixPlayerNbt(CompoundTag player, boolean[] changed, MigrationProfile data) {
        ListTag inventory = player.getList("Inventory", 10);
        DataFixerAPI.fixItemArrayWithID(inventory, changed, data, true);
        ListTag enderitems = player.getList("EnderItems", 10);
        DataFixerAPI.fixItemArrayWithID(enderitems, changed, data, true);
        if (player.contains("recipeBook")) {
            CompoundTag recipeBook = player.getCompound("recipeBook");
            changed[0] = changed[0] | DataFixerAPI.fixStringIDList(recipeBook, "recipes", data);
            changed[0] = changed[0] | DataFixerAPI.fixStringIDList(recipeBook, "toBeDisplayed", data);
        }
    }

    static boolean fixStringIDList(CompoundTag root, String name, MigrationProfile data) {
        boolean _changed = false;
        if (root.contains(name)) {
            ListTag items = root.getList(name, 8);
            ListTag newItems = new ListTag();
            for (Tag tag : items) {
                StringTag str = (StringTag)tag;
                String replace = data.replaceStringFromIDs(str.getAsString());
                if (replace != null) {
                    _changed = true;
                    newItems.add((Object)StringTag.valueOf((String)replace));
                    continue;
                }
                newItems.add((Object)tag);
            }
            if (_changed) {
                root.put(name, (Tag)newItems);
            }
        }
        return _changed;
    }

    private static void fixRegion(MigrationProfile data, State state, File file, RegionStorageInfo regionStorageInfo) {
        try {
            Path path = file.toPath();
            LOGGER.info("Inspecting " + String.valueOf(path));
            boolean[] changed = new boolean[1];
            RegionFile region = new RegionFile(regionStorageInfo, path, path.getParent(), true);
            for (int x = 0; x < 32; ++x) {
                for (int z = 0; z < 32; ++z) {
                    ChunkPos pos = new ChunkPos(x, z);
                    changed[0] = false;
                    if (!region.hasChunk(pos) || state.didFail) continue;
                    DataInputStream input = region.getChunkDataInputStream(pos);
                    CompoundTag root = NbtIo.read((DataInput)input);
                    input.close();
                    ListTag tileEntities = root.getCompound("Level").getList("TileEntities", 10);
                    DataFixerAPI.fixItemArrayWithID(tileEntities, changed, data, true);
                    ListTag entities = root.getList("Entities", 10);
                    DataFixerAPI.fixItemArrayWithID(entities, changed, data, true);
                    ListTag sections = root.getCompound("Level").getList("Sections", 10);
                    sections.forEach(tag -> {
                        ListTag palette = ((CompoundTag)tag).getList("Palette", 10);
                        palette.forEach(blockTag -> {
                            CompoundTag blockTagCompound = (CompoundTag)blockTag;
                            changed[0] = changed[0] | data.replaceStringFromIDs(blockTagCompound, "Name");
                        });
                        try {
                            changed[0] = changed[0] | data.patchBlockState(palette, ((CompoundTag)tag).getList("BlockStates", 4));
                        }
                        catch (PatchDidiFailException e) {
                            BCLib.LOGGER.error("Failed fixing BlockState in " + String.valueOf(pos));
                            state.addError("Failed fixing BlockState in " + String.valueOf(pos) + " (" + e.getMessage() + ")");
                            state.didFail = true;
                            changed[0] = false;
                            e.printStackTrace();
                        }
                    });
                    if (!changed[0]) continue;
                    LOGGER.warn("Writing '{}': {}/{}", new Object[]{file, x, z});
                    DataOutputStream output = region.getChunkDataOutputStream(pos);
                    NbtIo.write((CompoundTag)root, (DataOutput)output);
                    output.close();
                }
            }
            region.close();
        }
        catch (Exception e) {
            BCLib.LOGGER.error("Failed fixing Region.");
            state.addError("Failed fixing Region in " + file.getName() + " (" + e.getMessage() + ")");
            state.didFail = true;
            e.printStackTrace();
        }
    }

    static CompoundTag getPatchData() {
        if (patchConfTag == null) {
            patchConfTag = WorldConfig.getCompoundTag((ModCore)BCLib.C, (String)"patches");
        }
        return patchConfTag;
    }

    static void fixItemArrayWithID(ListTag items, boolean[] changed, MigrationProfile data, boolean recursive) {
        items.forEach(inTag -> DataFixerAPI.fixID((CompoundTag)inTag, changed, data, recursive));
    }

    static void fixID(CompoundTag inTag, boolean[] changed, MigrationProfile data, boolean recursive) {
        CompoundTag entityTag;
        CompoundTag tag = inTag;
        changed[0] = changed[0] | data.replaceStringFromIDs(tag, "id");
        if (tag.contains("Item")) {
            CompoundTag item = (CompoundTag)tag.get("Item");
            DataFixerAPI.fixID(item, changed, data, recursive);
        }
        if (recursive && tag.contains("Items")) {
            DataFixerAPI.fixItemArrayWithID(tag.getList("Items", 10), changed, data, true);
        }
        if (recursive && tag.contains("Inventory")) {
            ListTag inventory = tag.getList("Inventory", 10);
            DataFixerAPI.fixItemArrayWithID(inventory, changed, data, true);
        }
        if (tag.contains("tag") && (entityTag = (CompoundTag)tag.get("tag")).contains("BlockEntityTag")) {
            CompoundTag blockEntityTag = (CompoundTag)entityTag.get("BlockEntityTag");
            DataFixerAPI.fixID(blockEntityTag, changed, data, recursive);
        }
    }

    private static List<File> getAllPlayers(File dir) {
        ArrayList<File> list = new ArrayList<File>();
        if (!(dir = new File(dir, "playerdata")).exists() || !dir.isDirectory()) {
            return list;
        }
        for (File file : dir.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".dat")) continue;
            list.add(file);
        }
        return list;
    }

    private static List<File> getAllRegions(File dir, List<File> list) {
        if (list == null) {
            list = new ArrayList<File>();
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                DataFixerAPI.getAllRegions(file, list);
                continue;
            }
            if (!file.isFile() || !file.getName().endsWith(".mca")) continue;
            list.add(file);
        }
        return list;
    }

    public static void registerPatch(Supplier<Patch> patch) {
        Patch.getALL().add(patch.get());
    }

    private static CompoundTag readNbt(Path file) throws IOException {
        try {
            return NbtIo.readCompressed((Path)file, (NbtAccounter)NbtAccounter.unlimitedHeap());
        }
        catch (EOFException | ZipException e) {
            return NbtIo.read((Path)file);
        }
    }

    static class State {
        public boolean didFail = false;
        protected ArrayList<String> errors = new ArrayList();

        State() {
        }

        public void addError(String s) {
            this.errors.add(s);
        }

        public boolean hasError() {
            return !this.errors.isEmpty();
        }

        public String getErrorMessage() {
            return this.errors.stream().reduce("", (a, b) -> a + "  - " + b + "\n");
        }

        public String[] getErrorMessages() {
            String[] res = new String[this.errors.size()];
            return this.errors.toArray(res);
        }
    }

    @FunctionalInterface
    public static interface Callback {
        public void call();
    }
}

