/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.advancement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.storage.loot.LootTable;
import org.betterx.bclib.api.v2.advancement.Display;
import org.betterx.bclib.complexmaterials.WoodenComplexMaterial;
import org.betterx.bclib.complexmaterials.set.wood.WoodSlots;
import org.betterx.wover.complex.api.equipment.ArmorSlot;
import org.betterx.wover.complex.api.equipment.EquipmentSet;
import org.betterx.wover.complex.api.equipment.ToolSlot;

public class AdvancementManager {
    private static final Map<ResourceLocation, Advancement.Builder> ADVANCEMENTS = new LinkedHashMap<ResourceLocation, Advancement.Builder>();

    public static void register(ResourceLocation id, Advancement.Builder builder) {
        ADVANCEMENTS.put(id, builder);
    }

    public static void registerAllDataGen(List<String> namespaces, Consumer<AdvancementHolder> consumer) {
        AdvancementHolder ROOT_RECIPE = Advancement.Builder.advancement().addCriterion("impossible", CriteriaTriggers.IMPOSSIBLE.createCriterion((CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance())).build(RecipeBuilder.ROOT_RECIPE_ADVANCEMENT);
        HashMap<ResourceLocation, AdvancementHolder> BUILT = new HashMap<ResourceLocation, AdvancementHolder>();
        for (Map.Entry<ResourceLocation, Advancement.Builder> entry : ADVANCEMENTS.entrySet()) {
            ResourceLocation loc = entry.getKey();
            if (namespaces != null && !namespaces.contains(loc.getNamespace())) continue;
            Advancement.Builder builder = entry.getValue();
            AdvancementHolder adv = builder.build(loc);
            BUILT.put(loc, adv);
            consumer.accept(adv);
        }
    }

    public static class DisplayBuilder {
        Builder base;
        final Display display = new Display();

        DisplayBuilder reset(Builder base) {
            this.base = base;
            this.display.reset();
            return this;
        }

        public DisplayBuilder background(ResourceLocation value) {
            this.display.background = value;
            return this;
        }

        public DisplayBuilder icon(ItemLike value) {
            this.display.icon = new ItemStack(value);
            return this;
        }

        public DisplayBuilder icon(ItemStack value) {
            this.display.icon = value;
            return this;
        }

        public DisplayBuilder title(Component value) {
            this.display.title = value;
            return this;
        }

        public DisplayBuilder description(Component value) {
            this.display.description = value;
            return this;
        }

        public DisplayBuilder showToast() {
            this.display.showToast = true;
            return this;
        }

        public DisplayBuilder hideToast() {
            this.display.showToast = false;
            return this;
        }

        public DisplayBuilder hidden() {
            this.display.hidden = true;
            return this;
        }

        public DisplayBuilder visible() {
            this.display.hidden = false;
            return this;
        }

        public DisplayBuilder announceToChat() {
            this.display.announceChat = true;
            return this;
        }

        public DisplayBuilder hideFromChat() {
            this.display.announceChat = false;
            return this;
        }

        public DisplayBuilder frame(net.minecraft.advancements.AdvancementType type) {
            this.display.frame = type;
            return this;
        }

        public DisplayBuilder challenge() {
            return this.frame(net.minecraft.advancements.AdvancementType.CHALLENGE);
        }

        public DisplayBuilder task() {
            return this.frame(net.minecraft.advancements.AdvancementType.TASK);
        }

        public DisplayBuilder goal() {
            return this.frame(net.minecraft.advancements.AdvancementType.GOAL);
        }

        public Builder endDisplay() {
            this.base.display(this.display.build());
            return this.base;
        }
    }

    public static class Builder {
        private static final ThreadLocal<DisplayBuilder> DISPLAY_BUILDER = ThreadLocal.withInitial(DisplayBuilder::new);
        private static final ResourceLocation RECIPES_ROOT = RecipeBuilder.ROOT_RECIPE_ADVANCEMENT;
        private final Advancement.Builder builder = new OrderedBuilder();
        private final ResourceLocation id;
        private final AdvancementType type;
        private boolean canBuild = true;

        private Builder(ResourceLocation id, AdvancementType type) {
            ResourceLocation ID;
            if (type == AdvancementType.RECIPE_DECORATIONS) {
                ID = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("recipes/decorations/" + id.getPath()));
                this.builder.parent(RECIPES_ROOT);
            } else if (type == AdvancementType.RECIPE_TOOL) {
                ID = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("recipes/tools/" + id.getPath()));
                this.builder.parent(RECIPES_ROOT);
            } else {
                ID = id;
            }
            this.id = ID;
            this.type = type;
        }

        public static Builder createEmptyCopy(Builder builder) {
            return new Builder(builder.id, builder.type);
        }

        public static Builder create(ResourceLocation id) {
            return new Builder(id, AdvancementType.REGULAR);
        }

        public static Builder create(ResourceLocation id, AdvancementType type) {
            return new Builder(id, type);
        }

        public static Builder create(Item icon) {
            return Builder.create((ItemLike)icon, AdvancementType.REGULAR);
        }

        public static Builder create(ItemStack icon) {
            return Builder.create(icon, AdvancementType.REGULAR);
        }

        public static Builder create(ItemLike icon, AdvancementType type) {
            return Builder.create(new ItemStack(icon), type);
        }

        public static Builder create(ItemStack icon, AdvancementType type) {
            return Builder.create(icon, type, (DisplayBuilder displayBuilder) -> {});
        }

        public static Builder create(Item icon, AdvancementType type, Consumer<DisplayBuilder> displayAdapter) {
            return Builder.create(new ItemStack((ItemLike)icon), type, displayAdapter);
        }

        public static Builder create(ItemStack icon, AdvancementType type, Consumer<DisplayBuilder> displayAdapter) {
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)icon.getItem());
            boolean canBuild = true;
            if (id == null || icon.is(Items.AIR)) {
                canBuild = false;
                id = BuiltInRegistries.ITEM.getDefaultKey();
            }
            String baseName = "advancements." + id.getNamespace() + "." + id.getPath() + ".";
            Builder b = new Builder(id, type);
            DisplayBuilder displayBuilder = b.startDisplay(icon, (Component)Component.translatable((String)(baseName + "title")), (Component)Component.translatable((String)(baseName + "description")));
            if (displayAdapter != null) {
                displayAdapter.accept(displayBuilder);
            }
            b = displayBuilder.endDisplay();
            b.canBuild = canBuild;
            return b;
        }

        public static <C extends RecipeInput, T extends RecipeHolder<Recipe<C>>> Builder createRecipe(T recipe, AdvancementType type) {
            Item item = recipe.value().getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()).getItem();
            return Builder.create(item, type, (DisplayBuilder displayBuilder) -> displayBuilder.hideToast().hideFromChat()).addRecipeUnlockCriterion("has_the_recipe", recipe).startReward().addRecipe(recipe.id()).endReward().requirements(AdvancementRequirements.Strategy.OR);
        }

        public Builder parent(AdvancementHolder advancement) {
            this.builder.parent(advancement);
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder parent(ResourceLocation resourceLocation) {
            this.builder.parent(resourceLocation);
            return this;
        }

        public DisplayBuilder startDisplay(ItemLike icon) {
            String baseName = "advancements." + this.id.getNamespace() + "." + this.id.getPath() + ".";
            return this.startDisplay(icon, (Component)Component.translatable((String)(baseName + "title")), (Component)Component.translatable((String)(baseName + "description")));
        }

        public DisplayBuilder startDisplay(ItemLike icon, Component title, Component description) {
            return this.startDisplay(new ItemStack(icon), title, description);
        }

        public DisplayBuilder startDisplay(ItemStack icon, Component title, Component description) {
            if (icon == null) {
                this.canBuild = false;
            } else {
                ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)icon.getItem());
                if (id == null) {
                    this.canBuild = false;
                }
            }
            DisplayBuilder dp = DISPLAY_BUILDER.get().reset(this);
            return dp.icon(icon).title(title).description(description);
        }

        Builder display(DisplayInfo displayInfo) {
            this.builder.display(displayInfo);
            return this;
        }

        public Builder awardRecipe(ItemLike ... items) {
            RewardsBuilder rewardBuilder = this.startReward();
            for (ItemLike item : items) {
                ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item.asItem());
                if (id == null) continue;
                rewardBuilder.addRecipe(id);
            }
            return rewardBuilder.endReward();
        }

        public RewardsBuilder startReward() {
            return new RewardsBuilder(this);
        }

        public Builder rewards(AdvancementRewards advancementRewards) {
            this.builder.rewards(advancementRewards);
            return this;
        }

        public Builder rewardXP(int xp) {
            return this.rewards(AdvancementRewards.Builder.experience((int)500).build());
        }

        public <T extends CriterionTriggerInstance> Builder addCriterion(String string, CriterionTrigger<T> criterionTrigger, T criterionTriggerInstance) {
            this.builder.addCriterion(string, new Criterion(criterionTrigger, criterionTriggerInstance));
            return this;
        }

        public Builder addCriterion(String string, Criterion criterion) {
            this.builder.addCriterion(string, criterion);
            return this;
        }

        public Builder addAtStructureCriterion(String name, Holder<Structure> structure) {
            return this.addCriterion(name, PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inStructure(structure)));
        }

        public <C extends RecipeInput, T extends Recipe<C>> Builder addRecipeUnlockCriterion(String name, RecipeHolder<T> recipe) {
            return this.addCriterion(name, RecipeUnlockedTrigger.unlocked((ResourceLocation)recipe.id()));
        }

        public Builder addInventoryChangedCriterion(String name, ItemLike ... items) {
            return this.addCriterion(name, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])items));
        }

        public Builder addInventoryChangedAnyCriterion(String name, ItemLike ... items) {
            Criterion t = InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of(items)});
            return this.addCriterion(name, t);
        }

        public Builder addInventoryChangedCriterion(String name, TagKey<Item> tag) {
            Criterion t = InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of(tag)});
            return this.addCriterion(name, t);
        }

        public Builder addEquipmentSetSlotCriterion(EquipmentSet set, ArmorSlot slot) {
            return this.addInventoryChangedCriterion(set.baseName + "_" + String.valueOf(slot), new ItemLike[]{set.get(slot)});
        }

        public Builder addEquipmentSetSlotCriterion(EquipmentSet set, ToolSlot slot) {
            return this.addInventoryChangedCriterion(set.baseName + "_" + String.valueOf(slot), new ItemLike[]{set.get(slot)});
        }

        public Builder addArmorSetCriterion(EquipmentSet set) {
            return this.addEquipmentSetSlotCriterion(set, ArmorSlot.HELMET_SLOT).addEquipmentSetSlotCriterion(set, ArmorSlot.CHESTPLATE_SLOT).addEquipmentSetSlotCriterion(set, ArmorSlot.LEGGINGS_SLOT).addEquipmentSetSlotCriterion(set, ArmorSlot.BOOTS_SLOT);
        }

        public Builder addToolSetCriterion(EquipmentSet set) {
            return this.addEquipmentSetSlotCriterion(set, ToolSlot.PICKAXE_SLOT).addEquipmentSetSlotCriterion(set, ToolSlot.AXE_SLOT).addEquipmentSetSlotCriterion(set, ToolSlot.SHOVEL_SLOT).addEquipmentSetSlotCriterion(set, ToolSlot.SWORD_SLOT).addEquipmentSetSlotCriterion(set, ToolSlot.HOE_SLOT);
        }

        public Builder addWoodCriterion(WoodenComplexMaterial mat) {
            return this.addInventoryChangedAnyCriterion("got_" + mat.getBaseName(), new ItemLike[]{mat.getBlock(WoodSlots.LOG), mat.getBlock(WoodSlots.BARK), mat.getBlock(WoodSlots.PLANKS)});
        }

        public Builder addVisitBiomesCriterion(List<Holder<Biome>> list) {
            for (Holder<Biome> holder : list) {
                this.addCriterion(((ResourceKey)holder.unwrapKey().orElseThrow()).location().toString(), PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome(holder)));
            }
            return this;
        }

        public Builder requireAll() {
            this.builder.requirements(AdvancementRequirements.Strategy.AND);
            return this;
        }

        public Builder requireOne() {
            this.builder.requirements(AdvancementRequirements.Strategy.OR);
            return this;
        }

        public Builder requirements(AdvancementRequirements.Strategy requirementsStrategy) {
            this.builder.requirements(requirementsStrategy);
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder requirements(String[][] strings) {
            return this.requirements(Arrays.stream(strings).map(Arrays::asList).map(ArrayList::new).collect(Collectors.toList()));
        }

        public Builder requirements(List<List<String>> strings) {
            this.builder.requirements(new AdvancementRequirements(strings));
            return this;
        }

        public ResourceLocation build() {
            AdvancementManager.register(this.id, this.builder);
            return this.id;
        }
    }

    public static enum AdvancementType {
        REGULAR,
        RECIPE_DECORATIONS,
        RECIPE_TOOL;

    }

    public static class RewardsBuilder {
        private final Builder calle;
        private final AdvancementRewards.Builder builder = new AdvancementRewards.Builder();

        private RewardsBuilder(Builder calle) {
            this.calle = calle;
        }

        public RewardsBuilder addExperience(int i) {
            this.builder.addExperience(i);
            return this;
        }

        public RewardsBuilder addLootTable(ResourceKey<LootTable> resourceLocation) {
            this.builder.addLootTable(resourceLocation);
            return this;
        }

        public RewardsBuilder addRecipe(ResourceLocation resourceLocation) {
            this.builder.addRecipe(resourceLocation);
            return this;
        }

        public RewardsBuilder runs(ResourceLocation resourceLocation) {
            this.builder.runs(resourceLocation);
            return this;
        }

        public Builder endReward() {
            this.calle.rewards(this.builder.build());
            return this.calle;
        }
    }

    static class OrderedBuilder
    extends Advancement.Builder {
        OrderedBuilder() {
        }
    }
}

