/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.ComposterAPI;
import org.betterx.bclib.behaviours.interfaces.BehaviourCompostable;
import org.betterx.bclib.blocks.BaseBarrelBlock;
import org.betterx.bclib.blocks.BaseChestBlock;
import org.betterx.bclib.blocks.BaseFurnaceBlock;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.client.render.BaseChestBlockEntityRenderer;
import org.betterx.bclib.interfaces.PostInitable;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.items.tool.BaseShearsItem;
import org.betterx.bclib.registry.BaseBlockEntities;

public class PostInitAPI {
    private static List<Consumer<Boolean>> postInitFunctions = Lists.newArrayList();
    private static List<TagKey<Block>> blockTags = Lists.newArrayList();
    private static List<TagKey<Item>> itemTags = Lists.newArrayList();

    public static void register(Consumer<Boolean> function) {
        postInitFunctions.add(function);
    }

    public static void postInit(boolean isClient) {
        BuiltInRegistries.BLOCK.forEach(block -> {
            PostInitAPI.processBlockCommon(block);
            if (isClient) {
                PostInitAPI.processBlockClient(block);
            }
        });
        BuiltInRegistries.ITEM.forEach(item -> PostInitAPI.processItemCommon(item));
        if (postInitFunctions != null) {
            postInitFunctions.forEach(function -> function.accept(isClient));
            postInitFunctions = null;
        }
        blockTags = null;
        itemTags = null;
    }

    @Environment(value=EnvType.CLIENT)
    private static void processBlockClient(Block block) {
        if (block instanceof RenderLayerProvider) {
            BCLRenderLayer layer = ((RenderLayerProvider)block).getRenderLayer();
            if (layer == BCLRenderLayer.CUTOUT) {
                BlockRenderLayerMap.INSTANCE.putBlock(block, RenderType.cutout());
            } else if (layer == BCLRenderLayer.TRANSLUCENT) {
                BlockRenderLayerMap.INSTANCE.putBlock(block, RenderType.translucent());
            }
        }
        if (block instanceof BaseChestBlock) {
            BaseChestBlockEntityRenderer.registerRenderLayer(block);
        }
    }

    private static void processItemCommon(Item item) {
        if (item instanceof BaseShearsItem) {
            DispenserBlock.registerBehavior((ItemLike)item.asItem(), (DispenseItemBehavior)new ShearsDispenseItemBehavior());
        }
    }

    private static void processBlockCommon(Block block) {
        Item item = block.asItem();
        if (block instanceof PostInitable) {
            ((PostInitable)block).postInit();
        }
        if (block instanceof BehaviourCompostable) {
            BehaviourCompostable c = (BehaviourCompostable)block;
            if (item != null && item != Items.AIR) {
                ComposterAPI.allowCompost(c.compostingChance(), item);
            } else if (BCLib.isDatagen()) {
                BCLib.LOGGER.verbose("Block " + String.valueOf(block) + " has compostable behaviour but no item!");
            }
        }
        if (block instanceof BaseChestBlock) {
            BaseBlockEntities.CHEST.registerBlock(block);
        } else if (block instanceof BaseBarrelBlock) {
            BaseBlockEntities.BARREL.registerBlock(block);
        } else if (block instanceof BaseFurnaceBlock) {
            BaseBlockEntities.FURNACE.registerBlock(block);
        }
    }
}

