/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.datagen.impl;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.data.DataProvider;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.WoverAutoProvider;
import org.betterx.wover.datagen.api.WoverDataProvider;
import org.betterx.wover.entrypoint.LibWoverDatagen;

public abstract class PackBuilderImpl {
    protected final List<WoverDataProvider<?>> providerFactories = new LinkedList();
    protected final List<WoverAutoProvider.WithRedirect> redirectors = new LinkedList<WoverAutoProvider.WithRedirect>();

    protected abstract ModCore modCore();

    protected <T extends DataProvider> void addProviderWithRedirect(WoverDataProvider<T> provider) {
        WoverDataProvider p = this.redirectors.stream().reduce(provider, (prov, redirector) -> redirector.redirect(prov), (a, b) -> a);
        if (p != null) {
            this.providerFactories.add(p);
        }
    }

    <T extends DataProvider> void instantiateAutoProvider(WoverDataProvider<T> provider) {
        if (provider == null) {
            return;
        }
        LibWoverDatagen.C.LOG.debug("Instantiating auto provider: {}", new Object[]{provider.getClass().getName()});
        if (provider instanceof WoverAutoProvider.WithRedirect) {
            this.redirectors.add((WoverAutoProvider.WithRedirect)((Object)provider));
            this.providerFactories.add(provider);
        } else {
            this.addProviderWithRedirect(provider);
        }
    }
}

