/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.datagen.api;

import com.mojang.serialization.Lifecycle;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricDynamicRegistryProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.WoverRegistryProvider;
import org.jetbrains.annotations.ApiStatus;

public abstract class WoverRegistryContentProvider<T>
extends WoverRegistryProvider<T> {
    private final List<ResourceKey<T>> content = new LinkedList<ResourceKey<T>>();

    public WoverRegistryContentProvider(ModCore modCore, String title, ResourceKey<Registry<T>> registryKey) {
        super(modCore, title, registryKey);
    }

    @Override
    protected abstract void bootstrap(BootstrapContext<T> var1);

    private void addContent(ResourceKey<T> resourceKey) {
        this.content.add(resourceKey);
    }

    private void wrappedBoostrap(final BootstrapContext<T> context) {
        BootstrapContext wrapped = new BootstrapContext<T>(){

            public Holder.Reference<T> register(ResourceKey<T> resourceKey, T object, Lifecycle lifecycle) {
                WoverRegistryContentProvider.this.addContent(resourceKey);
                return context.register(resourceKey, object, lifecycle);
            }

            public <S> HolderGetter<S> lookup(ResourceKey<? extends Registry<? extends S>> resourceKey) {
                return context.lookup(resourceKey);
            }
        };
        this.bootstrap(wrapped);
    }

    @Override
    @ApiStatus.Internal
    public final void buildRegistry(RegistrySetBuilder registryBuilder) {
        this.modCore.log.info("Registering " + this.title);
        registryBuilder.add(this.registryKey, this::wrappedBoostrap);
    }

    @Override
    @ApiStatus.Internal
    public final FabricDynamicRegistryProvider getProvider(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
        return new FabricDynamicRegistryProvider(output, registriesFuture){

            protected void configure(HolderLookup.Provider registries, FabricDynamicRegistryProvider.Entries entries) {
                HolderLookup.RegistryLookup registry = registries.lookupOrThrow(WoverRegistryContentProvider.this.registryKey);
                int count = 0;
                for (ResourceKey key : WoverRegistryContentProvider.this.content) {
                    Optional optional = registry.get(key);
                    if (!optional.isPresent() || !((Holder.Reference)optional.get()).isBound()) continue;
                    entries.add(key, ((Holder.Reference)optional.get()).value());
                    ++count;
                }
                WoverRegistryContentProvider.this.modCore.log.info("[" + count + " / " + WoverRegistryContentProvider.this.content.size() + "] " + String.valueOf(WoverRegistryContentProvider.this.registryKey.location()));
            }

            public String getName() {
                return WoverRegistryContentProvider.this.title;
            }
        };
    }
}

