/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.datagen.api;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricDynamicRegistryProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.WoverRegistryProvider;
import org.jetbrains.annotations.ApiStatus;

public abstract class WoverFullRegistryProvider<T>
extends WoverRegistryProvider<T> {
    public final Predicate<String> validNamespace;

    public WoverFullRegistryProvider(ModCore modCore, String title, ResourceKey<Registry<T>> registryKey, Predicate<String> validNamespace) {
        super(modCore, title, registryKey);
        this.validNamespace = validNamespace;
    }

    public WoverFullRegistryProvider(ModCore modCore, String title, ResourceKey<Registry<T>> registryKey, List<String> validNamespaces) {
        this(modCore, title, registryKey, validNamespaces::contains);
    }

    public WoverFullRegistryProvider(ModCore modCore, String title, ResourceKey<Registry<T>> registryKey) {
        this(modCore, title, registryKey, List.of(modCore.namespace));
    }

    @Override
    protected abstract void bootstrap(BootstrapContext<T> var1);

    @Override
    @ApiStatus.Internal
    public final void buildRegistry(RegistrySetBuilder registryBuilder) {
        this.modCore.log.info("Registering " + this.title);
        registryBuilder.add(this.registryKey, this::bootstrap);
    }

    @Override
    @ApiStatus.Internal
    public FabricDynamicRegistryProvider getProvider(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
        return new FabricDynamicRegistryProvider(output, registriesFuture){

            protected void configure(HolderLookup.Provider registries, FabricDynamicRegistryProvider.Entries entries) {
                HolderLookup.RegistryLookup registry = registries.lookupOrThrow(WoverFullRegistryProvider.this.registryKey);
                long countAll = registry.listElementIds().count();
                List<Holder.Reference> filtered = registry.listElementIds().filter(key -> WoverFullRegistryProvider.this.validNamespace.test(key.location().getNamespace())).map(arg_0 -> ((HolderLookup.RegistryLookup)registry).getOrThrow(arg_0)).filter(Holder.Reference::isBound).toList();
                long filteredCount = filtered.size();
                filtered.forEach(holder -> entries.add(holder.key(), holder.value()));
                WoverFullRegistryProvider.this.modCore.log.info("[" + filteredCount + " / " + countAll + "] " + String.valueOf(WoverFullRegistryProvider.this.registryKey.location()));
            }

            public String getName() {
                return WoverFullRegistryProvider.this.title;
            }
        };
    }
}

