/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.datagen.api;

import java.util.LinkedList;
import java.util.List;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.PackBuilder;
import org.betterx.wover.datagen.api.WoverDataProvider;
import org.betterx.wover.datagen.impl.WoverDataGenEntryPointImpl;
import org.betterx.wover.entrypoint.LibWoverDatagen;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class WoverDataGenEntryPoint
implements DataGeneratorEntrypoint {
    private List<PackBuilder> builders = null;
    private PackBuilder globalBuilder = null;

    protected WoverDataGenEntryPoint() {
    }

    protected PackBuilder addDatapack(ResourceLocation location) {
        PackBuilder res = new PackBuilder(this.modCore(), location);
        this.builders.add(res);
        return res;
    }

    protected abstract void onInitializeProviders(PackBuilder var1);

    protected abstract ModCore modCore();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        WoverDataGenEntryPoint woverDataGenEntryPoint = this;
        synchronized (woverDataGenEntryPoint) {
            if (this.builders == null) {
                LibWoverDatagen.C.LOG.debug("Initializing WoverDataGenEntryPoint:" + this.getClass().getName() + " for " + String.valueOf(this.modCore()));
                this.builders = new LinkedList<PackBuilder>();
                this.globalBuilder = this.addDatapack(null);
                this.addDefaultGlobalProviders(this.globalBuilder);
                this.onInitializeProviders(this.globalBuilder);
            }
        }
    }

    private FabricDataGenerator.Pack createBuiltinDatapack(FabricDataGenerator generator, ResourceLocation location) {
        FabricDataGenerator.Pack pack = generator.createBuiltinResourcePack(location);
        pack.addProvider(packOutput -> PackMetadataGenerator.forFeaturePack((PackOutput)packOutput, (Component)Component.translatable((String)("pack." + location.getNamespace() + "." + location.getPath() + ".description"))));
        return pack;
    }

    @Nullable
    public String getEffectiveModId() {
        return this.modCore().modId;
    }

    @ApiStatus.Internal
    public final void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        if (this.ignoreRun()) {
            LibWoverDatagen.C.LOG.debug("Ignoring run for " + String.valueOf(this));
            return;
        }
        this.initialize();
        this.globalBuilder.pack = fabricDataGenerator.createPack();
        this.builders.stream().filter(p -> p.location != null).forEach(p -> {
            p.pack = this.createBuiltinDatapack(fabricDataGenerator, p.location);
        });
        for (PackBuilder builder : this.builders) {
            builder.providerFactories().stream().forEach(provider -> {
                builder.pack.addProvider(provider::getProvider);
                WoverDataGenEntryPoint.addMultiProviders(builder, provider);
            });
            if (builder.datapackBootstrap == null) continue;
            builder.datapackBootstrap.bootstrap(fabricDataGenerator, builder.pack, builder.location);
        }
    }

    private static void addMultiProviders(PackBuilder builder, Object provider) {
        Object wpp;
        if (provider instanceof WoverDataProvider.Secondary) {
            wpp = (WoverDataProvider.Secondary)provider;
            builder.pack.addProvider(((WoverDataProvider.Secondary)wpp)::getSecondaryProvider);
        }
        if (provider instanceof WoverDataProvider.Tertiary) {
            wpp = (WoverDataProvider.Tertiary)provider;
            builder.pack.addProvider(((WoverDataProvider.Tertiary)wpp)::getTertiaryProvider);
        }
    }

    private void addDefaultGlobalProviders(PackBuilder globalPack) {
        WoverDataGenEntryPointImpl.addDefaultGlobalProviders(globalPack);
    }

    protected void onBuildRegistry(RegistrySetBuilder registryBuilder) {
    }

    @ApiStatus.Internal
    public final void buildRegistry(RegistrySetBuilder registryBuilder) {
        if (this.ignoreRun()) {
            return;
        }
        super.buildRegistry(registryBuilder);
        this.initialize();
        for (PackBuilder builder : this.builders) {
            builder.registryProviders().forEach(provider -> provider.buildRegistry(registryBuilder));
        }
        this.onBuildRegistry(registryBuilder);
    }

    public static <T extends DataProvider> void registerAutoProvider(PackBuilder.ProviderFactory<T> providerFactory) {
        WoverDataGenEntryPointImpl.registerAutoProvider(providerFactory);
    }

    protected boolean ignoreRun() {
        return !WoverDataGenEntryPoint.runsForMod(this.modCore());
    }

    public static boolean runsForMod(ModCore modCore) {
        String target = WoverDataGenEntryPoint.targetModID();
        if (!modCore.namespace.equals(LibWoverDatagen.C.namespace) && (target == null || target.isEmpty())) {
            return true;
        }
        return modCore.modId.equals(WoverDataGenEntryPoint.targetModID());
    }

    public static String targetModID() {
        return System.getProperty("fabric-api.datagen.modid");
    }

    public String toString() {
        return this.getClass().getSimpleName() + " for " + String.valueOf(this.modCore());
    }
}

