/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.world;

import com.denfop.IUItem;
import com.denfop.blocks.BlockBasalts;
import com.denfop.blocks.BlockHeavyOre;
import com.denfop.blocks.BlockMineral;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.IUFluid;
import com.denfop.world.WorldBaseGen;
import com.denfop.world.vein.ChanceOre;
import com.denfop.world.vein.VeinType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class GeneratorVolcano {
    public static final int[][] protrusionOffsets = new int[][]{{-1, 1, -1}, {0, 2, -1}, {1, 3, -1}, {1, 4, 0}, {1, 5, 1}, {0, 6, 1}, {-1, 7, 1}, {-1, 8, 0}, {0, 9, 0}};
    private static BlockState basalt_smooth = IUItem.basalts.getState(BlockBasalts.Type.basalt_smooth);
    private static BlockState basalt_sulfur_ore = IUItem.basalts.getState(BlockBasalts.Type.basalt_sulfur_ore);
    private static BlockState basalt_pylon = IUItem.basalts.getState(BlockBasalts.Type.basalt_pylon);
    private static BlockState basalt_magma = IUItem.basalts.getState(BlockBasalts.Type.basalt_magma);
    private static BlockState basalt_cobblestone = IUItem.basalts.getState(BlockBasalts.Type.basalt_cobblestone);
    private static BlockState basalt_melted = IUItem.basalts.getState(BlockBasalts.Type.basalt_melted);
    private static BlockState basalt = IUItem.basalts.getState(BlockBasalts.Type.basalt);
    private static BlockState basalt_boron_ore = IUItem.basalts.getState(BlockBasalts.Type.basalt_boron_ore);
    private static BlockState basalt_spongy = IUItem.basalts.getState(BlockBasalts.Type.basalt_spongy);
    private static BlockState basalt_blocked = IUItem.basalts.getState(BlockBasalts.Type.basalt_blocked);
    private static BlockState[][] basalts_ores = null;
    private final BlockPos position2;
    private final Thread thread;
    boolean genChest = false;
    private Level world;
    private BlockPos position;
    private Random rand;
    private LinkedList<BlockPos> blockPosList1;
    private LinkedList<BlockPos> blockPosList;
    private ChunkPos chunkPos;
    private ChunkAccess chunk;
    private int baseHeight;
    private int baseRadius;
    private double protrusionChance;
    private double lavaFlowChance;
    private double stalagmiteChance;
    private Map<ChunkPos, ChunkAccess> chunkPosChunkMap = new HashMap<ChunkPos, ChunkAccess>();
    private boolean end;
    private int y;
    private int maxbaseHeight;

    public GeneratorVolcano(FeaturePlaceContext<NoneFeatureConfiguration> p159749) {
        this.position2 = new BlockPos(p159749.origin().getX(), 30, p159749.origin().getZ());
        this.thread = new Thread(){

            @Override
            public void run() {
                if (GeneratorVolcano.this.y == GeneratorVolcano.this.baseHeight) {
                    while (!GeneratorVolcano.this.genChest) {
                        BlockPos pos;
                        int index = GeneratorVolcano.this.rand.nextInt(GeneratorVolcano.this.blockPosList1.size());
                        if (GeneratorVolcano.this.rand.nextDouble() >= 0.95) {
                            pos = GeneratorVolcano.this.blockPosList1.get(index);
                            if (!GeneratorVolcano.this.world.getBlockState(pos).isAir()) {
                                pos = pos.above();
                            }
                            GeneratorVolcano.this.genChest = true;
                            continue;
                        }
                        pos = GeneratorVolcano.this.blockPosList1.remove(index);
                        if (!GeneratorVolcano.this.blockPosList1.isEmpty()) continue;
                        if (!GeneratorVolcano.this.world.getBlockState(pos).isAir()) {
                            pos = pos.above();
                        }
                        GeneratorVolcano.this.genChest = true;
                    }
                    GeneratorVolcano.this.end = true;
                    return;
                }
                int radius = GeneratorVolcano.this.baseRadius - GeneratorVolcano.this.y / 2;
                if (radius < 10) {
                    for (int x = -radius; x <= radius; ++x) {
                        for (int z = -radius; z <= radius; ++z) {
                            if (x * x + z * z > radius * radius) continue;
                            BlockPos pos = GeneratorVolcano.this.position.offset(x, GeneratorVolcano.this.y, z);
                            GeneratorVolcano.this.world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                        }
                    }
                    ++GeneratorVolcano.this.y;
                    return;
                }
                for (int x = -radius; x <= radius; ++x) {
                    for (int z = -radius; z <= radius; ++z) {
                        if (x * x + z * z > radius * radius) continue;
                        BlockPos pos = GeneratorVolcano.this.position.offset(x, GeneratorVolcano.this.y, z);
                        if (GeneratorVolcano.this.y >= GeneratorVolcano.this.baseHeight - 1 || x * x + z * z > (radius - 2) * (radius - 2)) {
                            GeneratorVolcano.this.world.setBlock(pos, GeneratorVolcano.this.getBlockState(GeneratorVolcano.this.maxbaseHeight, GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                            if (GeneratorVolcano.this.y < GeneratorVolcano.this.baseHeight - 5 && (double)GeneratorVolcano.this.y > (double)GeneratorVolcano.this.maxbaseHeight * 0.1 && GeneratorVolcano.this.rand.nextDouble() < GeneratorVolcano.this.stalagmiteChance) {
                                for (int i = 1; i <= GeneratorVolcano.this.rand.nextInt(3); ++i) {
                                    BlockPos belowPos = pos.below(i);
                                    GeneratorVolcano.this.world.setBlock(belowPos, GeneratorVolcano.this.getBlockState(GeneratorVolcano.this.maxbaseHeight, GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                }
                            } else if ((double)GeneratorVolcano.this.y < (double)GeneratorVolcano.this.maxbaseHeight * 0.6 && (double)GeneratorVolcano.this.y > (double)GeneratorVolcano.this.maxbaseHeight * 0.1 && GeneratorVolcano.this.rand.nextDouble() < 0.05) {
                                GeneratorVolcano.this.world.setBlock(pos, GeneratorVolcano.this.getBlockState(GeneratorVolcano.this.maxbaseHeight, GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                for (int i = 1; i <= 3 + GeneratorVolcano.this.rand.nextInt(6); ++i) {
                                    BlockPos belowPos = pos.below(i);
                                    GeneratorVolcano.this.world.setBlock(belowPos, GeneratorVolcano.this.getBlockStatePylon(GeneratorVolcano.this.maxbaseHeight, GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                }
                            } else if ((double)GeneratorVolcano.this.y < (double)GeneratorVolcano.this.maxbaseHeight * 0.25 && (double)GeneratorVolcano.this.y > (double)GeneratorVolcano.this.maxbaseHeight * 0.025 && GeneratorVolcano.this.rand.nextDouble() < GeneratorVolcano.this.lavaFlowChance) {
                                BlockPos belowPos = pos.below();
                                GeneratorVolcano.this.setBlockState1(GeneratorVolcano.this.world, belowPos, ((IUFluid)((Object)FluidName.fluidpahoehoe_lava.getInstance().get())).getSource().defaultFluidState().createLegacyBlock(), 3);
                            }
                            if (GeneratorVolcano.this.rand.nextInt(1000) > 20) continue;
                            BlockPos belowPos = pos.above();
                            GeneratorVolcano.this.setBlockState1(GeneratorVolcano.this.world, belowPos, ((IUFluid)((Object)FluidName.fluidpahoehoe_lava.getInstance().get())).getSource().defaultFluidState().createLegacyBlock(), 3);
                            continue;
                        }
                        if (GeneratorVolcano.this.y == 0) {
                            if (GeneratorVolcano.this.rand.nextDouble() < GeneratorVolcano.this.protrusionChance) {
                                int z1;
                                int i;
                                int type = GeneratorVolcano.this.rand.nextInt(5);
                                if (type == 0) {
                                    BlockPos protrusionPos = pos.above(0);
                                    GeneratorVolcano.this.setBlockState1(GeneratorVolcano.this.world, protrusionPos, GeneratorVolcano.this.getBlockDownState(GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                    GeneratorVolcano.this.blockPosList1.add(protrusionPos);
                                    continue;
                                }
                                if (type == 1) {
                                    int protrusionSize = GeneratorVolcano.this.rand.nextInt(5) + 2;
                                    for (i = 0; i < protrusionSize; ++i) {
                                        BlockPos protrusionPos = pos.above(i);
                                        GeneratorVolcano.this.blockPosList.add(protrusionPos);
                                        GeneratorVolcano.this.setBlockState1(GeneratorVolcano.this.world, protrusionPos, GeneratorVolcano.this.getBlockStatePylon(GeneratorVolcano.this.maxbaseHeight, GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                    }
                                    GeneratorVolcano.this.blockPosList1.add(pos.above(protrusionSize - 1));
                                    continue;
                                }
                                if (type == 2) {
                                    for (int x1 = -1; x1 < 2; ++x1) {
                                        for (z1 = -1; z1 < 2; ++z1) {
                                            BlockPos protrusionPos = pos.offset(x1, 0, z1);
                                            GeneratorVolcano.this.blockPosList.add(protrusionPos);
                                            GeneratorVolcano.this.setBlockState1(GeneratorVolcano.this.world, protrusionPos, GeneratorVolcano.this.getBlockDownState(GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                            GeneratorVolcano.this.blockPosList1.add(protrusionPos);
                                        }
                                    }
                                    int[][] x1 = protrusionOffsets;
                                    z1 = x1.length;
                                    for (int protrusionPos = 0; protrusionPos < z1; ++protrusionPos) {
                                        int[] offset = x1[protrusionPos];
                                        for (int yy = 0; yy < offset[1]; ++yy) {
                                            BlockPos protrusionPos2 = pos.offset(offset[0], yy, offset[2]);
                                            GeneratorVolcano.this.blockPosList.add(protrusionPos2);
                                            GeneratorVolcano.this.setBlockState1(GeneratorVolcano.this.world, protrusionPos2, GeneratorVolcano.this.getBlockState(GeneratorVolcano.this.maxbaseHeight, GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                        }
                                    }
                                    continue;
                                }
                                if (type == 3) {
                                    for (int x1 = -1; x1 < 2; ++x1) {
                                        for (z1 = -1; z1 < 2; ++z1) {
                                            BlockPos protrusionPos = pos.offset(x1, 0, z1);
                                            GeneratorVolcano.this.blockPosList.add(protrusionPos);
                                            GeneratorVolcano.this.setBlockState1(GeneratorVolcano.this.world, protrusionPos, GeneratorVolcano.this.getBlockDownState(GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                            GeneratorVolcano.this.blockPosList1.add(protrusionPos);
                                        }
                                    }
                                    int protrusionSize = GeneratorVolcano.this.rand.nextInt(5) + 2;
                                    for (i = 0; i < protrusionSize; ++i) {
                                        BlockPos protrusionPos = pos.above(i);
                                        GeneratorVolcano.this.blockPosList.add(protrusionPos);
                                        GeneratorVolcano.this.setBlockState1(GeneratorVolcano.this.world, protrusionPos, GeneratorVolcano.this.getBlockStatePylon(GeneratorVolcano.this.maxbaseHeight, GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                    }
                                    protrusionSize = GeneratorVolcano.this.rand.nextInt(protrusionSize);
                                    for (i = 0; i < protrusionSize; ++i) {
                                        BlockPos pos1;
                                        BlockPos protrusionPos = pos.above(i);
                                        for (int z12 = -1; z12 < 2; z12 += 2) {
                                            pos1 = protrusionPos.east(z12);
                                            GeneratorVolcano.this.blockPosList.add(pos1);
                                            GeneratorVolcano.this.setBlockState1(GeneratorVolcano.this.world, pos1, GeneratorVolcano.this.getBlockState(GeneratorVolcano.this.maxbaseHeight, GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 32);
                                        }
                                        for (int x1 = -1; x1 < 2; x1 += 2) {
                                            pos1 = protrusionPos.north(x1);
                                            GeneratorVolcano.this.blockPosList.add(pos1);
                                            GeneratorVolcano.this.setBlockState1(GeneratorVolcano.this.world, pos1, GeneratorVolcano.this.getBlockState(GeneratorVolcano.this.maxbaseHeight, GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                        }
                                    }
                                    continue;
                                }
                                for (int x1 = -1; x1 < 2; ++x1) {
                                    for (z1 = -1; z1 < 2; ++z1) {
                                        BlockPos protrusionPos = pos.offset(x1, 0, z1);
                                        GeneratorVolcano.this.blockPosList.add(protrusionPos);
                                        GeneratorVolcano.this.blockPosList1.add(protrusionPos);
                                        GeneratorVolcano.this.setBlockState1(GeneratorVolcano.this.world, protrusionPos, GeneratorVolcano.this.getBlockState(GeneratorVolcano.this.maxbaseHeight, GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                    }
                                }
                                int protrusionSize = GeneratorVolcano.this.rand.nextInt(5) + 2;
                                for (i = 0; i < protrusionSize; ++i) {
                                    BlockPos protrusionPos = pos.above(i);
                                    GeneratorVolcano.this.blockPosList.add(protrusionPos);
                                    GeneratorVolcano.this.setBlockState1(GeneratorVolcano.this.world, protrusionPos, GeneratorVolcano.this.getBlockState(GeneratorVolcano.this.maxbaseHeight, GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                }
                                protrusionSize = GeneratorVolcano.this.rand.nextInt(protrusionSize);
                                for (i = 0; i < protrusionSize; ++i) {
                                    BlockPos protrusionPos = pos.above(i);
                                    for (int z13 = -1; z13 < 2; z13 += 2) {
                                        for (int x1 = -1; x1 < 2; x1 += 2) {
                                            BlockPos pos1 = protrusionPos.east(z13);
                                            pos1 = pos1.north(x1);
                                            GeneratorVolcano.this.blockPosList.add(pos1);
                                            GeneratorVolcano.this.setBlockState1(GeneratorVolcano.this.world, pos1, GeneratorVolcano.this.getBlockState(GeneratorVolcano.this.maxbaseHeight, GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                        }
                                    }
                                }
                                continue;
                            }
                            boolean remove = GeneratorVolcano.this.blockPosList.remove(pos);
                            if (remove) continue;
                            GeneratorVolcano.this.setBlockState1(GeneratorVolcano.this.world, pos, ((IUFluid)((Object)FluidName.fluidpahoehoe_lava.getInstance().get())).getSource().defaultFluidState().createLegacyBlock(), 3);
                            continue;
                        }
                        if (GeneratorVolcano.this.blockPosList.isEmpty() || GeneratorVolcano.this.y > 10) {
                            GeneratorVolcano.this.setBlockState1(GeneratorVolcano.this.world, pos, Blocks.AIR.defaultBlockState(), 3);
                            continue;
                        }
                        boolean remove = GeneratorVolcano.this.blockPosList.remove(pos);
                        if (remove) continue;
                        GeneratorVolcano.this.setBlockState1(GeneratorVolcano.this.world, pos, Blocks.AIR.defaultBlockState(), 3);
                    }
                }
                ++GeneratorVolcano.this.y;
            }
        };
        this.thread.setPriority(1);
    }

    public void setWorld(Level world) {
        if (this.world == null) {
            this.world = world;
            this.rand = WorldBaseGen.random;
            this.end = false;
            this.chunkPos = new ChunkPos(this.position2);
            this.chunk = world.getChunk(this.chunkPos.x, this.chunkPos.z, ChunkStatus.EMPTY, false);
            this.baseHeight = 80 + this.rand.nextInt(30);
            this.baseRadius = 35 + this.rand.nextInt(20);
            this.protrusionChance = 0.05;
            this.lavaFlowChance = 0.01;
            this.stalagmiteChance = 0.1;
            this.blockPosList = new LinkedList();
            this.blockPosList1 = new LinkedList();
            this.maxbaseHeight = 0;
            for (int y = 0; y < this.baseHeight; ++y) {
                int radius = this.baseRadius - y / 2;
                if (radius >= 10) continue;
                this.maxbaseHeight = y;
                break;
            }
            if (basalts_ores == null) {
                this.initBasaltsOres();
            }
            int height = this.chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, this.position2.getX(), this.position2.getZ());
            BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(this.position2.getX(), height, this.position2.getZ());
            this.position = checkPos.above(this.maxbaseHeight / 2);
            if (this.position.getY() > 60) {
                this.position = this.position.below(this.position.getY() - 60);
            }
            this.y = 0;
            this.end = false;
        }
    }

    private void initBasaltsOres() {
        basalts_ores = new BlockState[WorldBaseGen.veinTypes.size()][];
        for (int i = 0; i < WorldBaseGen.veinTypes.size(); ++i) {
            ChanceOre chanceOre;
            int j;
            VeinType type = WorldBaseGen.veinTypes.get(i);
            int mineral = type.getHeavyOre() == null ? 0 : 1;
            GeneratorVolcano.basalts_ores[i] = new BlockState[mineral + type.getOres().size()];
            if (type.getHeavyOre() != null) {
                if (type.getHeavyOre() instanceof BlockHeavyOre) {
                    GeneratorVolcano.basalts_ores[i][0] = IUItem.basaltheavyore.getStateFromMeta(type.getMeta());
                } else if (type.getHeavyOre() instanceof BlockMineral) {
                    GeneratorVolcano.basalts_ores[i][0] = IUItem.basaltheavyore1.getStateFromMeta(type.getMeta());
                }
                for (j = 0; j < type.getOres().size(); ++j) {
                    chanceOre = type.getOres().get(j);
                    GeneratorVolcano.basalts_ores[i][1 + j] = chanceOre.getBlock();
                }
                continue;
            }
            for (j = 0; j < type.getOres().size(); ++j) {
                chanceOre = type.getOres().get(j);
                GeneratorVolcano.basalts_ores[i][j] = chanceOre.getBlock();
            }
        }
    }

    public BlockState getBlockDownState(int y, Random random) {
        double chance = random.nextDouble();
        if (chance < 0.7) {
            double chance1 = random.nextDouble();
            if (chance1 < 0.9) {
                return basalt_blocked;
            }
            int meta = random.nextInt(WorldBaseGen.veinTypes.size());
            while (WorldBaseGen.veinTypes.get(meta).getHeavyOre() == null) {
                meta = random.nextInt(WorldBaseGen.veinTypes.size());
            }
            return basalts_ores[meta][0];
        }
        if (chance < 0.9) {
            return basalt_cobblestone;
        }
        return basalt_magma;
    }

    public BlockState getBlockState(int baseHeight, int y, Random random) {
        if ((double)y < (double)baseHeight * 0.15) {
            double chance = random.nextDouble();
            if (chance < 0.65) {
                double chance1 = random.nextDouble();
                if (chance1 < 0.9) {
                    return basalt_melted;
                }
                int meta = random.nextInt(WorldBaseGen.veinTypes.size());
                while (WorldBaseGen.veinTypes.get(meta).getHeavyOre() == null) {
                    meta = random.nextInt(WorldBaseGen.veinTypes.size());
                }
                return basalts_ores[meta][0];
            }
            if (chance < 0.9) {
                return basalt_cobblestone;
            }
            return basalt_magma;
        }
        if ((double)y < (double)baseHeight * 0.7) {
            double chance = random.nextDouble();
            if (chance < 0.65) {
                double chance1 = random.nextDouble();
                if (chance1 < 0.9) {
                    return basalt;
                }
                int meta = random.nextInt(WorldBaseGen.veinTypes.size());
                while (WorldBaseGen.veinTypes.get(meta).getHeavyOre() == null) {
                    meta = random.nextInt(WorldBaseGen.veinTypes.size());
                }
                return basalts_ores[meta][0];
            }
            if (chance < 0.8) {
                double chance1 = random.nextDouble();
                if (chance1 < 0.9) {
                    return basalt_spongy;
                }
                int meta = random.nextInt(WorldBaseGen.veinTypes.size());
                VeinType vein = WorldBaseGen.veinTypes.get(meta);
                int index = vein.getHeavyOre() == null ? 0 : 1;
                int typeOreMeta = random.nextInt(vein.getOres().size());
                return basalts_ores[meta][index + typeOreMeta];
            }
            return basalt_magma;
        }
        double chance = random.nextDouble();
        if (chance < 0.25) {
            return basalt;
        }
        double chance1 = random.nextDouble();
        if (chance1 < 0.9) {
            if (chance1 < 0.45) {
                return basalt_smooth;
            }
            if (chance1 <= 0.48) {
                return basalt_sulfur_ore;
            }
            return Blocks.STONE.defaultBlockState();
        }
        int meta = random.nextInt(WorldBaseGen.veinTypes.size());
        VeinType vein = WorldBaseGen.veinTypes.get(meta);
        int index = vein.getHeavyOre() == null ? 0 : 1;
        int typeOreMeta = random.nextInt(vein.getOres().size());
        return basalts_ores[meta][index + typeOreMeta];
    }

    public BlockState getBlockStatePylon(int baseHeight, int y, Random random) {
        if ((double)y < (double)baseHeight * 0.15) {
            double chance = random.nextDouble();
            if (chance < 0.65) {
                double chance1 = random.nextDouble();
                if (chance1 < 0.9) {
                    return basalt_pylon;
                }
                int meta = random.nextInt(WorldBaseGen.veinTypes.size());
                while (WorldBaseGen.veinTypes.get(meta).getHeavyOre() == null) {
                    meta = random.nextInt(WorldBaseGen.veinTypes.size());
                }
                return basalts_ores[meta][0];
            }
            if (chance < 0.9) {
                return basalt_magma;
            }
            return basalt_boron_ore;
        }
        if ((double)y < (double)baseHeight * 0.7) {
            double chance = random.nextDouble();
            if (chance < 0.65) {
                double chance1 = random.nextDouble();
                if (chance1 < 0.9) {
                    return basalt_pylon;
                }
                int meta = random.nextInt(WorldBaseGen.veinTypes.size());
                while (WorldBaseGen.veinTypes.get(meta).getHeavyOre() == null) {
                    meta = random.nextInt(WorldBaseGen.veinTypes.size());
                }
                return basalts_ores[meta][0];
            }
            if (chance < 0.8) {
                double chance1 = random.nextDouble();
                if (chance1 < 0.9) {
                    return basalt_pylon;
                }
                int meta = random.nextInt(WorldBaseGen.veinTypes.size());
                VeinType vein = WorldBaseGen.veinTypes.get(meta);
                int index = vein.getHeavyOre() == null ? 0 : 1;
                int typeOreMeta = random.nextInt(vein.getOres().size());
                return basalts_ores[meta][index + typeOreMeta];
            }
            return basalt_magma;
        }
        double chance = random.nextDouble();
        if (chance < 0.25) {
            return basalt_sulfur_ore;
        }
        double chance1 = random.nextDouble();
        if (chance1 < 0.9) {
            return basalt_pylon;
        }
        int meta = random.nextInt(WorldBaseGen.veinTypes.size());
        VeinType vein = WorldBaseGen.veinTypes.get(meta);
        int index = vein.getHeavyOre() == null ? 0 : 1;
        int typeOreMeta = random.nextInt(vein.getOres().size());
        return basalts_ores[meta][index + typeOreMeta];
    }

    public void setBlockState1(Level level, BlockPos p_46605_, BlockState p_46606_, int p_46607_) {
        level.setBlock(p_46605_, p_46606_, p_46607_);
    }

    public void generate() {
        this.thread.run();
    }

    public boolean isEnd() {
        return this.end;
    }
}

