/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.world;

import com.denfop.world.TypeGas;
import net.minecraft.nbt.CompoundTag;

public class GenData {
    private final int y;
    private final int x;
    private final int z;
    private final TypeGas typeGas;

    public GenData(int y, int x, int z, TypeGas typeGas) {
        this.y = y;
        this.x = x;
        this.z = z;
        this.typeGas = typeGas;
    }

    public GenData(CompoundTag nbtTagCompound) {
        this.y = nbtTagCompound.getShort("y");
        this.x = nbtTagCompound.getInt("x");
        this.z = nbtTagCompound.getInt("z");
        this.typeGas = TypeGas.values()[nbtTagCompound.getByte("type")];
    }

    public CompoundTag writeNBT() {
        CompoundTag nbtTagCompound = new CompoundTag();
        nbtTagCompound.putShort("y", (short)this.y);
        nbtTagCompound.putInt("x", (int)((short)this.x));
        nbtTagCompound.putInt("z", (int)((short)this.z));
        nbtTagCompound.putByte("type", (byte)this.typeGas.ordinal());
        return nbtTagCompound;
    }

    public TypeGas getTypeGas() {
        return this.typeGas;
    }

    public int getY() {
        return this.y;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }
}

