/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class RetraceDiggingUtils {
    public static BlockHitResult retrace(Player player) {
        return RetraceDiggingUtils.retrace(player, RetraceDiggingUtils.getBlockReachDistance(player));
    }

    public static double getBlockReachDistance(Player player) {
        return player.level().isClientSide ? RetraceDiggingUtils.getBlockReachDistance_client() : (player instanceof ServerPlayer ? RetraceDiggingUtils.getBlockReachDistance_server((ServerPlayer)player) : 5.0);
    }

    public static BlockHitResult retrace(Player player, double reach) {
        return RetraceDiggingUtils.retrace(player, reach, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static double getBlockReachDistance_client() {
        return Minecraft.getInstance().player.blockInteractionRange();
    }

    private static double getBlockReachDistance_server(ServerPlayer player) {
        return player.blockInteractionRange();
    }

    public static BlockHitResult retrace(Player player, double reach, boolean stopOnFluids) {
        Vec3 vec3 = player.getEyePosition();
        Vec3 vec31 = vec3.add(player.calculateViewVector(player.getXRot(), player.getYRot()).scale(player.blockInteractionRange()));
        return player.level().clip(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
    }

    public static Vec3 getStartVec(Player player) {
        return RetraceDiggingUtils.getCorrectedHeadVec(player);
    }

    public static Vec3 getCorrectedHeadVec(Player player) {
        Vec3 eyePos = player.position().add(0.0, (double)player.getEyeHeight(), 0.0);
        return eyePos;
    }

    public static Vec3 getEndVec(Player player, double reach) {
        Vec3 headVec = RetraceDiggingUtils.getCorrectedHeadVec(player);
        Vec3 lookVec = player.getLookAngle();
        headVec.add((double)((float)(lookVec.x * reach)), (double)((float)(lookVec.y * reach)), (double)((float)(lookVec.z * reach)));
        return headVec;
    }
}

