/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.utils;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.radiationsystem.EnumCoefficient;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.invslot.InvSlot;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.mechanism.quarry.QuarryItem;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.world.WorldBaseGen;
import com.denfop.world.vein.ChanceOre;
import com.denfop.world.vein.VeinType;
import com.google.common.base.Preconditions;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModUtils {
    public static final Set<DataComponentType<?>> ignoredNbtKeys = new HashSet<DataComponentType>(Arrays.asList(DataComponents.DAMAGE, (DataComponentType)DataComponentsInit.ENERGY.get(), (DataComponentType)DataComponentsInit.ACTIVE.get(), (DataComponentType)DataComponentsInit.MODE.get(), (DataComponentType)DataComponentsInit.BLACK_LIST.get(), (DataComponentType)DataComponentsInit.EXPERIENCE.get(), (DataComponentType)DataComponentsInit.GENOME_CROP.get(), (DataComponentType)DataComponentsInit.GENOME_BEE.get(), (DataComponentType)DataComponentsInit.SAVE.get(), DataComponents.MAX_DAMAGE, DataComponents.MAX_STACK_SIZE, DataComponents.CONTAINER, DataComponents.FOOD, DataComponents.ENCHANTMENTS, DataComponents.STORED_ENCHANTMENTS, DataComponents.CUSTOM_NAME, DataComponents.TOOL, DataComponents.UNBREAKABLE, DataComponents.RARITY, DataComponents.REPAIR_COST, (DataComponentType)DataComponentsInit.LEVEL.get(), (DataComponentType)DataComponentsInit.UPGRADE_ITEM.get(), (DataComponentType)DataComponentsInit.WIND_UPGRADE.get(), (DataComponentType)DataComponentsInit.WATER_UPGRADE.get(), (DataComponentType)DataComponentsInit.SKIN.get(), (DataComponentType)DataComponentsInit.FLY.get(), (DataComponentType)DataComponentsInit.JETPACK.get(), (DataComponentType)DataComponentsInit.DIRECTION.get(), (DataComponentType)DataComponentsInit.CONTAINER.get(), (DataComponentType)DataComponentsInit.CONTAINER_ADDITIONAL.get(), (DataComponentType)DataComponentsInit.LIST_STRING.get(), (DataComponentType)DataComponentsInit.LIST_INTEGER.get(), (DataComponentType)DataComponentsInit.LIST_STACK.get(), (DataComponentType)DataComponentsInit.BEE_LIST.get(), (DataComponentType)DataComponentsInit.MOB.get(), (DataComponentType)DataComponentsInit.NAME.get(), (DataComponentType)DataComponentsInit.WIRELESS.get(), (DataComponentType)DataComponentsInit.DESCRIPTIONS_CONTAINER.get(), (DataComponentType)DataComponentsInit.VEIN_INFO.get(), (DataComponentType)DataComponentsInit.UPGRADE_KIT.get(), (DataComponentType)DataComponentsInit.REACTOR_DATA.get(), (DataComponentType)DataComponentsInit.REACTOR_SCHEDULE.get(), (DataComponentType)DataComponentsInit.TELEPORT.get(), DataComponents.LORE, DataComponents.RARITY, DataComponents.REPAIR_COST, DataComponents.ATTRIBUTE_MODIFIERS));
    private static final Direction[] BY_2D_DATA = (Direction[])Arrays.stream(Direction.values()).filter(p_235685_ -> p_235685_.getAxis().isHorizontal()).sorted(Comparator.comparingInt(Direction::get2DDataValue)).toArray(Direction[]::new);
    public static Logger log;
    public static Direction[] facings;
    public static ItemStack emptyStack;
    public static Set<Direction> noFacings;
    public static Set<Direction> onlyNorth;
    public static Set<Direction> horizontalFacings;
    public static Direction[] HORIZONTALS;
    public static Set<Direction> verticalFacings;
    public static Set<Direction> downSideFacings;
    public static Set<Direction> allFacings;

    public static Vec3 getVecFromVec3i(Vec3i vec3i) {
        return new Vec3((double)vec3i.getX(), (double)vec3i.getY(), (double)vec3i.getZ());
    }

    public static double getEnergyValue(ItemStack stack) {
        if (ModUtils.isEmpty(stack)) {
            return 0.0;
        }
        if (ModUtils.checkItemEquality(stack, Items.REDSTONE)) {
            return 800.0;
        }
        return 0.0;
    }

    public static int getFuelValue(ItemStack stack, boolean allowLava) {
        boolean isLava;
        if (ModUtils.isEmpty(stack)) {
            return 0;
        }
        FluidStack liquid = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
        boolean bl = isLava = !liquid.isEmpty() && liquid.getAmount() > 0 && liquid.getFluid() == Fluids.LAVA;
        if (isLava && !allowLava) {
            return 0;
        }
        Integer ret = (Integer)AbstractFurnaceBlockEntity.getFuel().get(stack.getItem());
        if (ret == null) {
            return 0;
        }
        return isLava ? ret / 10 : ret;
    }

    public static ItemStack get(Player player, InteractionHand hand) {
        return player.getItemInHand(hand);
    }

    public static ItemStack decSize(ItemStack stack) {
        return ModUtils.decSize(stack, 1);
    }

    public static ItemStack decSize(ItemStack stack, int amount) {
        return ModUtils.incSize(stack, -amount);
    }

    public static ItemStack incSize(ItemStack stack, int amount) {
        return ModUtils.setSize(stack, ModUtils.getSize(stack) + amount);
    }

    public static boolean storeInventoryItem(ItemStack stack, Player player, boolean simulate) {
        if (!simulate) {
            return player.getInventory().add(stack);
        }
        int sizeLeft = ModUtils.getSize(stack);
        int maxStackSize = Math.min(player.getInventory().getMaxStackSize(), stack.getMaxStackSize());
        for (int i = 0; i < player.getInventory().items.size() && sizeLeft > 0; ++i) {
            ItemStack invStack = (ItemStack)player.getInventory().items.get(i);
            if (ModUtils.isEmpty(invStack)) {
                sizeLeft -= maxStackSize;
                continue;
            }
            if (!ModUtils.checkNbtEquality(stack.getComponents(), invStack.getComponents()) || ModUtils.getSize(invStack) >= maxStackSize) continue;
            sizeLeft -= maxStackSize - ModUtils.getSize(invStack);
        }
        return sizeLeft <= 0;
    }

    public static void dropAsEntity(Level world, BlockPos pos, ItemStack stack, int count) {
        stack = stack.copy();
        stack.setCount(count);
        ModUtils.dropAsEntity(world, pos, stack);
    }

    public static void dropAsEntity(Level world, BlockPos pos, ItemStack stack) {
        if (!ModUtils.isEmpty(stack)) {
            double f = 0.7;
            double dx = (double)world.random.nextFloat() * f + (1.0 - f) * 0.5;
            double dy = (double)world.random.nextFloat() * f + (1.0 - f) * 0.5;
            double dz = (double)world.random.nextFloat() * f + (1.0 - f) * 0.5;
            ItemEntity entityItem = new ItemEntity(world, (double)pos.getX() + dx, (double)pos.getY() + dy, (double)pos.getZ() + dz, stack.copy());
            entityItem.setDefaultPickUpDelay();
            world.addFreshEntity((Entity)entityItem);
        }
    }

    public static boolean checkItemEquality(ItemStack a, ItemStack b) {
        return ModUtils.isEmpty(a) && ModUtils.isEmpty(b) || !ModUtils.isEmpty(a) && !ModUtils.isEmpty(b) && a.getItem() == b.getItem() && ModUtils.checkNbtEquality(a, b);
    }

    public static boolean checkItemEquality(ItemStack a, Item b) {
        return ModUtils.isEmpty(a) && b == null || !ModUtils.isEmpty(a) && b != null && a.getItem() == b;
    }

    public static boolean checkItemEqualityStrict(ItemStack a, ItemStack b) {
        return ModUtils.isEmpty(a) && ModUtils.isEmpty(b) || !ModUtils.isEmpty(a) && !ModUtils.isEmpty(b) && a.is(b.getItem()) && ModUtils.checkNbtEquality(a.getComponents(), b.getComponents());
    }

    private static boolean checkNbtEquality(ItemStack a, ItemStack b) {
        return ModUtils.areAllDataComponentsEqual(a, b);
    }

    public static boolean areAllDataComponentsEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1.isEmpty() && stack2.isEmpty()) {
            return true;
        }
        if (stack1.isEmpty() || stack2.isEmpty()) {
            return false;
        }
        for (DataComponentType type : stack1.getComponents().keySet()) {
            Object comp2;
            Object comp1;
            if (ignoredNbtKeys.contains(type)) continue;
            boolean has1 = stack1.has(type);
            boolean has2 = stack2.has(type);
            if (!has1) continue;
            if (!has2) {
                return false;
            }
            if (!has1 || (comp1 = stack1.get(type)).equals(comp2 = stack2.get(type))) continue;
            return false;
        }
        return true;
    }

    public static boolean checkNbtEquality(DataComponentMap a, DataComponentMap b) {
        DataComponentType key2;
        Set keysB;
        if (a == b) {
            return true;
        }
        Set keysA = a != null ? a.keySet() : Collections.emptySet();
        Set set = keysB = b != null ? b.keySet() : Collections.emptySet();
        if (keysA.isEmpty() && keysB.isEmpty()) {
            return true;
        }
        HashSet<DataComponentType> toCheck = new HashSet<DataComponentType>(Math.max(keysA.size(), keysB.size()));
        for (DataComponentType key2 : keysA) {
            if (ignoredNbtKeys.contains(key2)) continue;
            if (!keysB.contains(key2)) {
                return false;
            }
            toCheck.add(key2);
        }
        for (DataComponentType key2 : keysB) {
            if (ignoredNbtKeys.contains(key2)) continue;
            if (!keysA.contains(key2)) {
                return false;
            }
            toCheck.add(key2);
        }
        Iterator var5 = toCheck.iterator();
        do {
            if (!var5.hasNext()) {
                return true;
            }
            key2 = (DataComponentType)var5.next();
        } while (Objects.equals(Objects.requireNonNull(a).get(key2), Objects.requireNonNull(b).get(key2)));
        return false;
    }

    public static boolean isEmpty(ItemStack stack) {
        if (stack == emptyStack || stack == null) {
            return true;
        }
        return stack.getCount() <= 0;
    }

    public static boolean isEmpty(Player player, InteractionHand hand) {
        return ModUtils.isEmpty(player.getItemInHand(hand));
    }

    public static int getSize(ItemStack stack) {
        return ModUtils.isEmpty(stack) ? 0 : stack.getCount();
    }

    public static List<ItemStack> get_blacklist_block() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((ItemLike)Blocks.STONE));
        list.add(new ItemStack((ItemLike)Blocks.DIRT));
        list.add(new ItemStack((ItemLike)Blocks.NETHERRACK));
        list.add(new ItemStack((ItemLike)Blocks.END_STONE));
        list.add(new ItemStack((ItemLike)Blocks.ANDESITE));
        list.add(new ItemStack((ItemLike)Blocks.GRANITE));
        list.add(new ItemStack((ItemLike)Blocks.COBBLESTONE));
        list.add(new ItemStack((ItemLike)Blocks.POLISHED_GRANITE));
        list.add(new ItemStack((ItemLike)Blocks.POLISHED_DIORITE));
        list.add(new ItemStack((ItemLike)Blocks.POLISHED_ANDESITE));
        list.add(new ItemStack((ItemLike)Blocks.COARSE_DIRT));
        list.add(new ItemStack((ItemLike)Blocks.PODZOL));
        return list;
    }

    public static void info(String message) {
        log.info(message);
    }

    public static CompoundTag nbt() {
        return new CompoundTag();
    }

    public static CompoundTag nbt(ItemStack stack) {
        if (stack.isEmpty()) {
            return new CompoundTag();
        }
        CompoundTag NBTTagCompound = (CompoundTag)stack.get(DataComponentsInit.DATA);
        if (NBTTagCompound == null) {
            NBTTagCompound = new CompoundTag();
        }
        stack.set(DataComponentsInit.DATA, (Object)NBTTagCompound.copy());
        return (CompoundTag)stack.get(DataComponentsInit.DATA);
    }

    public static CompoundTag nbtOrNull(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        return (CompoundTag)stack.get(DataComponentsInit.DATA);
    }

    public static List<ItemStack> getListFromModule(ItemStack stack) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (!stack.isEmpty()) {
            List stringList = (List)stack.getOrDefault(DataComponentsInit.LIST_STRING, Collections.emptyList());
            for (String temp : stringList) {
                TagKey tag = new TagKey(Registries.ITEM, ResourceLocation.parse((String)temp));
                List list = new Ingredient.TagValue(tag).getItems().stream().toList();
                stacks.addAll(list);
            }
        }
        return stacks;
    }

    public static List<QuarryItem> getQuarryListFromModule(ItemStack stack) {
        ArrayList<QuarryItem> stacks = new ArrayList<QuarryItem>();
        if (!stack.isEmpty()) {
            List stringList = (List)stack.getOrDefault(DataComponentsInit.LIST_STRING, Collections.emptyList());
            for (String s : stringList) {
                stacks.add(new QuarryItem(s));
            }
        }
        return stacks;
    }

    public static boolean getOre(Block localBlock) {
        ItemStack stack = new ItemStack((ItemLike)localBlock, 1);
        for (ItemStack itemstack : ModUtils.get_blacklist_block()) {
            if (!stack.is(itemstack.getItem())) continue;
            return false;
        }
        return true;
    }

    public static boolean getore(Item localBlock) {
        for (ItemStack itemstack : ModUtils.get_blacklist_block()) {
            if (localBlock != itemstack.getItem()) continue;
            return false;
        }
        return true;
    }

    public static boolean getore(ItemStack localBlock) {
        for (ItemStack itemstack : ModUtils.get_blacklist_block()) {
            if (!localBlock.is(itemstack.getItem())) continue;
            return false;
        }
        return true;
    }

    public static boolean getore(Block stack, Block localBlock) {
        ItemStack stack1 = new ItemStack((ItemLike)localBlock);
        for (ItemStack itemstack : ModUtils.get_blacklist_block()) {
            if (!stack1.is(itemstack.getItem())) continue;
            return false;
        }
        if (stack != localBlock) {
            return false;
        }
        for (ItemStack itemstack : IUCore.get_ore) {
            BlockItem blockItem = (BlockItem)itemstack.getItem();
            if (stack != blockItem.getBlock()) continue;
            return true;
        }
        return localBlock == Blocks.REDSTONE_ORE;
    }

    public static List<Double> Time(double time) {
        ArrayList<Double> list = new ArrayList<Double>();
        double temp = 0.0;
        if (time / 3600.0 >= 1.0) {
            temp = time / 3600.0;
        }
        temp = Math.floor(temp);
        list.add(Math.floor(temp));
        double temp1 = 0.0;
        if ((time - temp * 3600.0) / 60.0 >= 1.0) {
            temp1 = (time - temp * 3600.0) / 60.0;
        }
        temp1 = Math.floor(temp1);
        list.add(Math.floor(temp1));
        double temp2 = time - (temp * 3600.0 + temp1 * 60.0);
        list.add(Math.floor(temp2));
        return list;
    }

    public static int getsum1(List<Integer> sum) {
        int sum_sum = 0;
        for (Integer aDouble : sum) {
            sum_sum += aDouble.intValue();
        }
        return sum_sum;
    }

    public static void SetDoubleWithoutItem(CompoundTag NBTTagCompound, String name, double amount) {
        if (NBTTagCompound == null) {
            NBTTagCompound = new CompoundTag();
        }
        NBTTagCompound.putDouble(name, amount);
    }

    public static String Boolean(boolean boolean1) {
        if (boolean1) {
            return Localization.translate("iu.yes");
        }
        return Localization.translate("iu.no");
    }

    public static void mode(ItemStack stack, List<Component> list) {
        list.add((Component)Component.literal((String)ModUtils.mode(stack)));
    }

    public static String mode(ItemStack stack) {
        String mode = (String)stack.getOrDefault(DataComponentsInit.SKIN, (Object)"");
        if (mode.isEmpty()) {
            return Localization.translate("defaultskin");
        }
        return switch (mode) {
            case "Zelen" -> Localization.translate("camouflageskin");
            case "Demon" -> Localization.translate("demonskin");
            case "Dark" -> Localization.translate("Darkskin");
            case "Cold" -> Localization.translate("Coldskin");
            case "Ender" -> Localization.translate("Enderskin");
            case "Ukraine" -> Localization.translate("Ukraineskin");
            case "Fire" -> Localization.translate("Fireskin");
            case "Emerald" -> Localization.translate("Emeraldskin");
            case "Taiga" -> Localization.translate("Taigaskin");
            case "Desert" -> Localization.translate("Desertskin");
            case "Snow" -> Localization.translate("Snowskin");
            default -> Localization.translate("defaultskin");
        };
    }

    public static ItemStack mode(CompoundTag nbt, ItemStack stack) {
        String mode = nbt.getString("mode");
        ItemStack stack1 = stack.copy();
        if (mode.isEmpty()) {
            return stack1;
        }
        stack1.set(DataComponentsInit.SKIN, (Object)mode);
        return stack1;
    }

    public static String mode(int meta) {
        if (meta == 0) {
            return Localization.translate("defaultskin");
        }
        switch (meta) {
            case 3: {
                return Localization.translate("camouflageskin");
            }
            case 4: {
                return Localization.translate("demonskin");
            }
            case 6: {
                return Localization.translate("Darkskin");
            }
            case 1: {
                return Localization.translate("Coldskin");
            }
            case 7: {
                return Localization.translate("Enderskin");
            }
            case 2: {
                return Localization.translate("Ukraineskin");
            }
            case 5: {
                return Localization.translate("Fireskin");
            }
            case 11: {
                return Localization.translate("Emeraldskin");
            }
            case 8: {
                return Localization.translate("Taigaskin");
            }
            case 10: {
                return Localization.translate("Desertskin");
            }
            case 9: {
                return Localization.translate("Snowskin");
            }
        }
        return Localization.translate("defaultskin");
    }

    public static String getString(float number) {
        int i = (int)Math.log10(number);
        String maxstorage_2 = "0";
        if (i > -3 && i < 0) {
            float gg = number * 1000.0f;
            maxstorage_2 = String.format("%.0fm", Float.valueOf(gg));
        } else if (i <= -3 && i > -6) {
            float gg = number * 1000000.0f;
            maxstorage_2 = String.format("%.2f\u00b5", Float.valueOf(gg));
        } else if (i <= -6 && i > -9) {
            float gg = number * 1.0E9f;
            maxstorage_2 = String.format("%.2fn", Float.valueOf(gg));
        } else if (i <= -9 && i > -12) {
            float gg = number * 1.0E12f;
            maxstorage_2 = String.format("%.2fp", Float.valueOf(gg));
        } else if (i >= 0 && i < 3 && number <= 1000.0f) {
            float gg = number;
            maxstorage_2 = String.format("%.0f", Float.valueOf(gg));
        } else if (i >= 3 && i < 6) {
            float gg = number / 1000.0f;
            maxstorage_2 = String.format("%.2fK", Float.valueOf(gg));
        } else if (i >= 6 && i < 9) {
            float gg = number / 1000000.0f;
            maxstorage_2 = String.format("%.2fM", Float.valueOf(gg));
        } else if (i >= 9 && i < 12) {
            float gg = number / 1.0E9f;
            maxstorage_2 = String.format("%.2fG", Float.valueOf(gg));
        }
        return maxstorage_2;
    }

    public static String getUnit(EnumCoefficient coefficient) {
        switch (coefficient) {
            case MICRO: {
                return "\u00b5";
            }
            case MILI: {
                return "m";
            }
            case KILO: {
                return "k";
            }
            case DEFAULT: {
                return "";
            }
        }
        return "n";
    }

    public static String getString1(double number) {
        int i = (int)Math.log10(number);
        String maxstorage_2 = "0";
        if (i > -3 && i < 0) {
            double gg = number * 1000.0;
            maxstorage_2 = String.format("%.0fm", gg);
        } else if (i <= -3 && i > -6) {
            double gg = number * 1000000.0;
            maxstorage_2 = String.format("%.0f\u00b5", gg);
        } else if (i <= -6 && i > -9) {
            double gg = number * 1.0E9;
            maxstorage_2 = String.format("%.0fn", gg);
        } else if (i <= -9 && i > -12) {
            double gg = number * 1.0E12;
            maxstorage_2 = String.format("%.0fp", gg);
        } else if (i >= 0 && i < 3 && number <= 1000.0) {
            double gg = number;
            maxstorage_2 = String.format("%.0f", gg);
        } else if (i >= 3 && i < 6 && number >= 1000.0 && number < 1000000.0) {
            double gg = number / 1000.0;
            maxstorage_2 = String.format("%.2fK", gg);
        } else if (i >= 6 && i < 9 && number >= 1000000.0 && number < 1.0E9) {
            double gg = number / 1000000.0;
            maxstorage_2 = String.format("%.2fM", gg);
        } else if (i >= 9 && i < 12 && number >= 1.0E9 && number < 2.1E9) {
            double gg = number / 1.0E9;
            maxstorage_2 = String.format("%.2fG", gg);
        }
        return maxstorage_2;
    }

    public static String getString(double number) {
        String maxstorage_2 = "0";
        double i = Math.log10(number);
        if (i > -3.0 && i < 0.0) {
            maxstorage_2 = String.format("%.0fm", number * 1000.0);
        } else if (i <= -3.0 && i > -6.0) {
            maxstorage_2 = String.format("%.0f\u00b5", number * 1000000.0);
        } else if (i <= -6.0 && i > -9.0) {
            maxstorage_2 = String.format("%.0fn", number * 1.0E9);
        } else if (i <= -9.0 && i > -12.0) {
            maxstorage_2 = String.format("%.0fp", number * 1.0E12);
        } else if (i < 3.0) {
            maxstorage_2 = String.format("%.0f", number);
        } else if (i < 6.0) {
            maxstorage_2 = String.format("%.2fK", number / 1000.0);
        } else if (i < 9.0) {
            maxstorage_2 = String.format("%.2fM", number / 1000000.0);
        } else if (i < 12.0) {
            maxstorage_2 = String.format("%.2fG", number / 1.0E9);
        } else if (i < 15.0) {
            maxstorage_2 = String.format("%.2fT", number / 1.0E12);
        } else if (i < 18.0) {
            maxstorage_2 = String.format("%.2fP", number / 1.0E15);
        } else if (i < 21.0) {
            maxstorage_2 = String.format("%.2fE", number / 1.0E18);
        } else if (i < 24.0) {
            maxstorage_2 = String.format("%.2fZ", number / 1.0E21);
        } else if (i < 27.0) {
            maxstorage_2 = String.format("%.2fY", number / 1.0E24);
        }
        return maxstorage_2;
    }

    public static String getStringBukket(double number) {
        String maxstorage_2 = "0";
        double i = Math.log10(number);
        if (i > -3.0 && i < 0.0) {
            maxstorage_2 = String.format("%.0fm", number * 1000.0);
        } else if (i <= -3.0 && i > -6.0) {
            maxstorage_2 = String.format("%.0f\u00b5", number * 1000000.0);
        } else if (i <= -6.0 && i > -9.0) {
            maxstorage_2 = String.format("%.0fn", number * 1.0E9);
        } else if (i <= -9.0 && i > -12.0) {
            maxstorage_2 = String.format("%.0fp", number * 1.0E12);
        } else if (i < 3.0) {
            maxstorage_2 = String.format("%.0fm", number * 1000.0);
        } else if (i < 6.0) {
            maxstorage_2 = String.format("%.2fK", number / 1000.0);
        } else if (i < 9.0) {
            maxstorage_2 = String.format("%.2fM", number / 1000000.0);
        } else if (i < 12.0) {
            maxstorage_2 = String.format("%.2fG", number / 1.0E9);
        } else if (i < 15.0) {
            maxstorage_2 = String.format("%.2fT", number / 1.0E12);
        } else if (i < 18.0) {
            maxstorage_2 = String.format("%.2fP", number / 1.0E15);
        } else if (i < 21.0) {
            maxstorage_2 = String.format("%.2fE", number / 1.0E18);
        } else if (i < 24.0) {
            maxstorage_2 = String.format("%.2fZ", number / 1.0E21);
        } else if (i < 27.0) {
            maxstorage_2 = String.format("%.2fY", number / 1.0E24);
        }
        return maxstorage_2;
    }

    public static int slot(List<Integer> list) {
        int meta = 0;
        for (Integer integer : list) {
            if (integer == 0) continue;
            meta = integer;
        }
        return meta;
    }

    public static int convertRGBcolorToInt(int r, int g, int b) {
        float divColor = 255.0f;
        Color tmpColor = new Color((float)r / divColor, (float)g / divColor, (float)b / divColor);
        return tmpColor.getRGB();
    }

    public static int convertRGBAcolorToInt(int r, int g, int b) {
        return 0xFA000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static IItemHandler getItemHandler(@javax.annotation.Nullable BlockEntity tile, Direction side) {
        if (tile == null) {
            return null;
        }
        @Nullable IItemHandler handler = (IItemHandler)tile.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, tile.getBlockPos(), (Object)side);
        if (handler == null) {
            if (side != null && tile instanceof WorldlyContainer) {
                handler = new SidedInvWrapper((WorldlyContainer)tile, side);
            } else if (tile instanceof Container) {
                handler = new InvWrapper((Container)tile);
            }
        }
        return handler;
    }

    public static ItemStack setSize(ItemStack stack, int col) {
        stack = stack.copy();
        stack.setCount(col);
        return stack;
    }

    public static ItemStack setSize(Item item, int col) {
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.setCount(col);
        return stack;
    }

    public static int limit(int value, int min, int max) {
        if (value <= min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static float limit(float value, float min, float max) {
        if (!Float.isNaN(value) && !(value <= min)) {
            return Math.min(value, max);
        }
        return min;
    }

    public static double limit(double value, double min, double max) {
        if (!Double.isNaN(value) && !(value <= min)) {
            return Math.min(value, max);
        }
        return min;
    }

    public static ItemStack getRecipeFromType(Level world, ItemStack stack1, RecipeType<SmeltingRecipe> type) {
        List recipes = world.getRecipeManager().getAllRecipesFor(type);
        for (RecipeHolder recipe1 : recipes) {
            SmeltingRecipe recipe = (SmeltingRecipe)recipe1.value();
            if (recipe.getIngredients().size() > 1) {
                return ItemStack.EMPTY;
            }
            if (!((Ingredient)recipe.getIngredients().get(0)).test(stack1)) continue;
            return recipe.getResultItem((HolderLookup.Provider)world.registryAccess());
        }
        return ItemStack.EMPTY;
    }

    @Nonnull
    public static ItemStack insertItem(IItemHandler dest, @Nonnull ItemStack stack, boolean simulate, int slots) {
        if (dest == null || stack.isEmpty()) {
            return stack;
        }
        slots = Math.min(slots, dest.getSlots());
        for (int i = 0; i < slots; ++i) {
            ItemStack stack1 = dest.insertItem(i, stack, simulate);
            if (stack1.isEmpty()) {
                return ItemStack.EMPTY;
            }
            if (stack1 == stack) continue;
            return stack1;
        }
        return stack;
    }

    public static void showFlames(Level level, BlockPos pos, Direction facing) {
        if (level.random.nextInt(8) == 0) {
            double x = (double)pos.getX() + ((double)facing.getStepX() * 1.04 + 1.0) / 2.0;
            double y = (double)pos.getY() + (double)level.random.nextFloat() * 0.375;
            double z = (double)pos.getZ() + ((double)facing.getStepZ() * 1.04 + 1.0) / 2.0;
            if (facing.getAxis() == Direction.Axis.X) {
                z += (double)level.random.nextFloat() * 0.625 - 0.3125;
            } else {
                x += (double)level.random.nextFloat() * 0.625 - 0.3125;
            }
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static ItemStack getCellFromFluid(Fluid fluid) {
        return IUItem.fluidCell.getItem().getItemStack(fluid);
    }

    public static void tick(InvSlotOutput slot, TileEntityBlock tile) {
        for (Direction facing1 : facings) {
            BlockPos pos = tile.getBlockPos().offset(facing1.getNormal());
            BlockEntity tile1 = tile.getWorld().getBlockEntity(pos);
            if (tile1 instanceof TileEntityInventory) {
                TileEntityInventory inventory = (TileEntityInventory)tile1;
                for (InvSlot invSlot : inventory.getInputSlots()) {
                    int maxCount;
                    ItemStack input;
                    if (invSlot.acceptAllOrIndex()) {
                        for (int j = 0; j < slot.size(); ++j) {
                            ItemStack output = slot.get(j);
                            if (output.isEmpty() || !invSlot.accepts(output, 0)) continue;
                            for (int jj = 0; jj < invSlot.size() && !output.isEmpty(); ++jj) {
                                input = invSlot.get(jj);
                                if (input.isEmpty()) {
                                    if (!invSlot.add(output)) continue;
                                    slot.set(j, ItemStack.EMPTY);
                                    output = ItemStack.EMPTY;
                                    continue;
                                }
                                if (!ModUtils.checkItemEquality(input, output) || (maxCount = Math.min(input.getMaxStackSize() - input.getCount(), output.getCount())) <= 0) continue;
                                input.grow(maxCount);
                                output.shrink(maxCount);
                            }
                        }
                        continue;
                    }
                    for (int jj = 0; jj < slot.size(); ++jj) {
                        ItemStack output;
                        for (int j = 0; j < invSlot.size() && !(output = slot.get(jj)).isEmpty(); ++j) {
                            input = invSlot.get(j);
                            if (input.isEmpty()) {
                                if (!invSlot.accepts(output, j) || !invSlot.add(output)) continue;
                                slot.set(jj, ItemStack.EMPTY);
                                output = ItemStack.EMPTY;
                                continue;
                            }
                            if (!ModUtils.checkItemEquality(input, output) || (maxCount = Math.min(input.getMaxStackSize() - input.getCount(), output.getCount())) <= 0) continue;
                            input.grow(maxCount);
                            output.shrink(maxCount);
                        }
                    }
                }
                continue;
            }
            IItemHandler handler = ModUtils.getItemHandler(tile1, facing1.getOpposite());
            if (handler == null) continue;
            int slots = handler.getSlots();
            for (int j = 0; j < slot.size(); ++j) {
                int count;
                ItemStack stack1;
                ItemStack took = slot.get(j);
                if (took.isEmpty()) continue;
                if (!(handler instanceof Container)) {
                    stack1 = ModUtils.insertItem(handler, took = took.copy(), true, slots);
                    if (stack1.isEmpty()) {
                        slot.set(j, ItemStack.EMPTY);
                        ModUtils.insertItem(handler, took, false, slots);
                        continue;
                    }
                    if (stack1 == took) continue;
                    count = slot.get(j).getCount() - stack1.getCount();
                    slot.get(j).shrink(count);
                    stack1.setCount(count);
                    ModUtils.insertItem(handler, stack1, false, slots);
                    continue;
                }
                stack1 = ModUtils.insertItem1(handler, took, true, slots);
                if (stack1.isEmpty()) {
                    slot.set(j, ItemStack.EMPTY);
                    ModUtils.insertItem1(handler, took, false, slots);
                    continue;
                }
                if (stack1 == took) continue;
                count = slot.get(j).getCount() - stack1.getCount();
                slot.get(j).shrink(count);
                stack1.setCount(count);
                ModUtils.insertItem1(handler, stack1, false, slots);
            }
        }
    }

    @Nonnull
    public static ItemStack insertItem1(IItemHandler dest, @Nonnull ItemStack stack, boolean simulate, int slot) {
        if (dest == null || stack.isEmpty()) {
            return stack;
        }
        slot = Math.min(slot, dest.getSlots());
        for (int i = 0; i < slot; ++i) {
            ItemStack stack2 = ModUtils.insertItem2(dest, i, stack, simulate);
            if (stack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            if (stack2 == stack) continue;
            return stack2;
        }
        return stack;
    }

    public static boolean canItemStacksStack(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        return !a.isEmpty() && a.is(b.getItem());
    }

    @Nonnull
    public static ItemStack insertItem2(IItemHandler dest, int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = dest.getStackInSlot(slot);
        if (!stackInSlot.isEmpty()) {
            int max = stackInSlot.getMaxStackSize();
            int limit = dest.getSlotLimit(slot);
            if (stackInSlot.getCount() >= Math.min(max, limit)) {
                return stack;
            }
            if (!ModUtils.canItemStacksStack(stack, stackInSlot)) {
                return stack;
            }
            int m = Math.min(max, limit) - stackInSlot.getCount();
            if (stack.getCount() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.copy();
                    copy.grow(stackInSlot.getCount());
                    ((SidedInvWrapper)dest).setStackInSlot(slot, copy);
                    return ItemStack.EMPTY;
                }
            } else {
                stack = stack.copy();
                if (!simulate) {
                    ItemStack copy = stack.split(m);
                    copy.grow(stackInSlot.getCount());
                    ((SidedInvWrapper)dest).setStackInSlot(slot, copy);
                    return ItemStack.EMPTY;
                }
            }
            return stack;
        }
        int m = Math.min(stack.getMaxStackSize(), dest.getSlotLimit(slot));
        if (m < stack.getCount()) {
            stack = stack.copy();
            if (!simulate) {
                ((SidedInvWrapper)dest).setStackInSlot(slot, stack.split(m));
            }
            return stack;
        }
        if (!simulate) {
            ((SidedInvWrapper)dest).setStackInSlot(slot, stack);
        }
        return ItemStack.EMPTY;
    }

    public static FluidActionResult tryFillContainer(@NotNull ItemStack container, IFluidHandler fluidSource, int maxAmount, @Nullable Player player, boolean doFill) {
        ItemStack containerCopy = ModUtils.copyStackWithSize(container, 1);
        IFluidHandlerItem containerFluidHandler = (IFluidHandlerItem)containerCopy.getCapability(Capabilities.FluidHandler.ITEM);
        for (int i = 0; i < fluidSource.getTanks(); ++i) {
            FluidStack simulatedTransfer = ModUtils.tryFluidTransfer((IFluidHandler)containerFluidHandler, fluidSource, maxAmount, false, i);
            if (simulatedTransfer.isEmpty()) continue;
            if (doFill) {
                SoundEvent soundevent;
                ModUtils.tryFluidTransfer((IFluidHandler)containerFluidHandler, fluidSource, maxAmount, true, i);
                if (player != null && (soundevent = simulatedTransfer.getFluid().getFluidType().getSound(simulatedTransfer, SoundActions.BUCKET_FILL)) != null) {
                    player.level().playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            } else {
                containerFluidHandler.fill(simulatedTransfer, IFluidHandler.FluidAction.EXECUTE);
            }
            ItemStack resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }
        return FluidActionResult.FAILURE;
    }

    @NotNull
    public static FluidActionResult tryFillContainerAndStow(@NotNull ItemStack container, IFluidHandler fluidSource, IItemHandler inventory, int maxAmount, @Nullable Player player, boolean doFill) {
        if (container.isEmpty()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.getAbilities().instabuild) {
            FluidActionResult filledReal = ModUtils.tryFillContainer(container, fluidSource, maxAmount, player, doFill);
            if (filledReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.getCount() == 1) {
            FluidActionResult filledReal = ModUtils.tryFillContainer(container, fluidSource, maxAmount, player, doFill);
            if (filledReal.isSuccess()) {
                return filledReal;
            }
        } else {
            ItemStack remainder;
            FluidActionResult filledSimulated = ModUtils.tryFillContainer(container, fluidSource, maxAmount, player, false);
            if (filledSimulated.isSuccess() && ((remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)filledSimulated.getResult(), (boolean)true)).isEmpty() || player != null)) {
                FluidActionResult filledReal = ModUtils.tryFillContainer(container, fluidSource, maxAmount, player, doFill);
                remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)filledReal.getResult(), (!doFill ? 1 : 0) != 0);
                if (!remainder.isEmpty() && player != null && doFill) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)remainder);
                }
                ItemStack containerCopy = container.copy();
                containerCopy.shrink(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    @NotNull
    public static ItemStack copyStackWithSize(@NotNull ItemStack itemStack, int size) {
        if (size == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack copy = itemStack.copy();
        copy.setCount(size);
        return copy;
    }

    public static boolean interactWithFluidHandler(@Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull IFluidHandler handler) {
        IItemHandler playerInventory;
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)hand);
        Preconditions.checkNotNull((Object)handler);
        ItemStack heldItem = player.getItemInHand(hand);
        if (!heldItem.isEmpty() && (playerInventory = (IItemHandler)player.getCapability(Capabilities.ItemHandler.ENTITY, null)) != null) {
            FluidActionResult fluidActionResult = ModUtils.tryFillContainerAndStow(heldItem, handler, playerInventory, Integer.MAX_VALUE, player, true);
            if (!fluidActionResult.isSuccess()) {
                Object stack = null;
                int sizeTanks = handler.getTanks();
                int capacity = -1;
                @NotNull ItemStack stack1 = ModUtils.copyStackWithSize(heldItem, 1);
                IFluidHandlerItem containerFluidHandler = FluidHandlerFix.getFluidHandler(stack1);
                for (int i = 0; i < sizeTanks; ++i) {
                    if ((!handler.getFluidInTank(i).isEmpty() || handler.fill(containerFluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) <= 0) && (handler.getFluidInTank(i).isEmpty() || !FluidStack.isSameFluid((FluidStack)handler.getFluidInTank(i), (FluidStack)containerFluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)) || handler.fill(containerFluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) <= 0)) continue;
                    capacity = handler.getTankCapacity(i) - (handler.getFluidInTank(i).isEmpty() ? 0 : handler.getFluidInTank(i).getAmount());
                }
                fluidActionResult = capacity <= 0 ? FluidActionResult.FAILURE : ModUtils.tryEmptyContainerAndStow(heldItem, handler, playerInventory, capacity, player, true);
            }
            if (fluidActionResult.isSuccess()) {
                player.setItemInHand(hand, fluidActionResult.getResult());
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static FluidActionResult tryEmptyContainerAndStow(@NotNull ItemStack container, IFluidHandler fluidDestination, IItemHandler inventory, int maxAmount, @Nullable Player player, boolean doDrain) {
        if (container.isEmpty()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.getAbilities().instabuild) {
            FluidActionResult emptiedReal = ModUtils.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.getCount() == 1) {
            FluidActionResult emptiedReal = ModUtils.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return emptiedReal;
            }
        } else {
            ItemStack remainder;
            FluidActionResult emptiedSimulated = ModUtils.tryEmptyContainer(container, fluidDestination, maxAmount, player, false);
            if (emptiedSimulated.isSuccess() && ((remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)emptiedSimulated.getResult(), (boolean)true)).isEmpty() || player != null)) {
                FluidActionResult emptiedReal = ModUtils.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
                remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)emptiedReal.getResult(), (!doDrain ? 1 : 0) != 0);
                if (!remainder.isEmpty() && player != null && doDrain) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)remainder);
                }
                ItemStack containerCopy = container.copy();
                containerCopy.shrink(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    @NotNull
    public static FluidActionResult tryEmptyContainer(@NotNull ItemStack container, IFluidHandler fluidDestination, int maxAmount, @Nullable Player player, boolean doDrain) {
        ItemStack containerCopy = ModUtils.copyStackWithSize(container, 1);
        IFluidHandlerItem containerFluidHandler = FluidHandlerFix.getFluidHandler(containerCopy);
        if (containerFluidHandler != null) {
            SoundEvent soundevent;
            FluidStack transfer = ModUtils.tryFluidTransfer(fluidDestination, (IFluidHandler)containerFluidHandler, maxAmount, doDrain);
            if (transfer.isEmpty()) {
                return FluidActionResult.FAILURE;
            }
            if (!doDrain) {
                containerFluidHandler.drain(transfer, IFluidHandler.FluidAction.EXECUTE);
            }
            if (doDrain && player != null && (soundevent = transfer.getFluid().getFluidType().getSound(transfer, SoundActions.BUCKET_EMPTY)) != null) {
                player.level().playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            ItemStack resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }
        return FluidActionResult.FAILURE;
    }

    @NotNull
    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, int maxAmount, boolean doTransfer, int index) {
        FluidStack stack = fluidSource.getFluidInTank(index).copy();
        if (stack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        stack.setAmount(Math.min(stack.getAmount(), maxAmount));
        FluidStack drainable = fluidSource.drain(stack, IFluidHandler.FluidAction.SIMULATE);
        if (!drainable.isEmpty()) {
            return ModUtils.tryFluidTransfer_Internal(fluidDestination, fluidSource, drainable, doTransfer);
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, int maxAmount, boolean doTransfer) {
        FluidStack drainable = fluidSource.drain(maxAmount, IFluidHandler.FluidAction.SIMULATE);
        if (!drainable.isEmpty()) {
            return ModUtils.tryFluidTransfer_Internal(fluidDestination, fluidSource, drainable, doTransfer);
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, FluidStack resource, boolean doTransfer) {
        FluidStack drainable = fluidSource.drain(resource, IFluidHandler.FluidAction.SIMULATE);
        if (!drainable.isEmpty() && FluidStack.isSameFluid((FluidStack)resource, (FluidStack)drainable)) {
            return ModUtils.tryFluidTransfer_Internal(fluidDestination, fluidSource, drainable, doTransfer);
        }
        return FluidStack.EMPTY;
    }

    private static FluidStack tryFluidTransfer_Internal(IFluidHandler fluidDestination, IFluidHandler fluidSource, FluidStack drainable, boolean doTransfer) {
        int fillableAmount = fluidDestination.fill(drainable, IFluidHandler.FluidAction.SIMULATE);
        if (fillableAmount > 0) {
            drainable.setAmount(fillableAmount);
            if (doTransfer) {
                FluidStack drained = fluidSource.drain(drainable, IFluidHandler.FluidAction.EXECUTE);
                if (!drained.isEmpty()) {
                    drained.setAmount(fluidDestination.fill(drained, IFluidHandler.FluidAction.EXECUTE));
                    return drained;
                }
            } else {
                return drainable;
            }
        }
        return FluidStack.EMPTY;
    }

    public static Direction getFacingFromTwoPositions(BlockPos fromPos, BlockPos toPos) {
        int dx = toPos.getX() - fromPos.getX();
        int dy = toPos.getY() - fromPos.getY();
        int dz = toPos.getZ() - fromPos.getZ();
        if (dx > 0) {
            return Direction.EAST;
        }
        if (dx < 0) {
            return Direction.WEST;
        }
        if (dy > 0) {
            return Direction.DOWN;
        }
        if (dy < 0) {
            return Direction.UP;
        }
        if (dz > 0) {
            return Direction.SOUTH;
        }
        if (dz < 0) {
            return Direction.NORTH;
        }
        return Direction.DOWN;
    }

    public static boolean inChanceOre(VeinType veinType, BlockState state) {
        for (ChanceOre chanceOre : veinType.getOres()) {
            if (chanceOre.getBlock() != state) continue;
            return true;
        }
        return false;
    }

    public static List<Component> getInformationFromOre(BlockState state) {
        ArrayList<Component> stringList = new ArrayList<Component>();
        for (VeinType vein : WorldBaseGen.veinTypes) {
            if ((vein.getHeavyOre() == null || vein.getHeavyOre().getStateMeta(vein.getMeta()) != state) && !ModUtils.inChanceOre(vein, state)) continue;
            Component s = vein.getHeavyOre() != null ? new ItemStack((ItemLike)vein.getHeavyOre().getBlock(), 1).getDisplayName() : new ItemStack((ItemLike)vein.getOres().get(0).getBlock().getBlock(), 1).getDisplayName();
            stringList.add(s);
        }
        return stringList;
    }

    static {
        facings = Direction.values();
        emptyStack = ItemStack.EMPTY;
        noFacings = Collections.emptySet();
        onlyNorth = Collections.unmodifiableSet(EnumSet.of(Direction.NORTH));
        horizontalFacings = Collections.unmodifiableSet(EnumSet.copyOf(Arrays.asList(BY_2D_DATA)));
        HORIZONTALS = BY_2D_DATA;
        verticalFacings = Collections.unmodifiableSet(EnumSet.of(Direction.DOWN, Direction.UP));
        downSideFacings = Collections.unmodifiableSet(EnumSet.complementOf(EnumSet.of(Direction.UP)));
        allFacings = Collections.unmodifiableSet(EnumSet.allOf(Direction.class));
    }
}

