/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.transport.types;

import com.denfop.blocks.ISubEnum;
import com.denfop.tiles.transport.types.ICableItem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public enum NightType implements ISubEnum,
ICableItem
{
    npipe(0, 0, 0.25f, 0.02, 2.147483647E9);

    public static final NightType[] values;
    private static final Map<String, NightType> nameMap;
    public final int maxInsulation;
    public final int minColoredInsulation;
    public final float thickness;
    public final double loss;
    public final double capacity;
    private final ResourceLocation texture;

    private NightType(int maxInsulation, int minColoredInsulation, float thickness, double loss, double capacity) {
        this.maxInsulation = maxInsulation;
        this.minColoredInsulation = minColoredInsulation;
        this.thickness = thickness;
        this.loss = loss;
        this.capacity = capacity;
        this.texture = ResourceLocation.tryBuild((String)"industrialupgrade", (String)("blocks/wiring/" + this.getMainPath() + "/" + this.getNameCable()));
    }

    public static NightType get(String name) {
        return nameMap.get(name);
    }

    @Override
    public String getName() {
        return this.name() + "_npipe";
    }

    @Override
    public int getId() {
        return this.ordinal();
    }

    @Override
    public String getNameCable() {
        return this.name() + "_npipe";
    }

    @Override
    public String getMainPath() {
        return "ncable";
    }

    @Override
    public float getThickness() {
        return this.thickness;
    }

    @Override
    public ResourceLocation getRecourse() {
        return this.texture;
    }

    static {
        values = NightType.values();
        nameMap = new HashMap<String, NightType>();
        for (NightType type : values) {
            nameMap.put(type.getName(), type);
        }
    }
}

