/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.transport.tiles;

import com.denfop.Localization;
import com.denfop.api.cool.ICoolAcceptor;
import com.denfop.api.cool.ICoolConductor;
import com.denfop.api.cool.ICoolEmitter;
import com.denfop.api.cool.ICoolTile;
import com.denfop.api.cool.InfoCable;
import com.denfop.api.cool.event.CoolTileLoadEvent;
import com.denfop.api.cool.event.CoolTileUnloadEvent;
import com.denfop.api.energy.ConductorInfo;
import com.denfop.api.heat.IHeatAcceptor;
import com.denfop.api.heat.IHeatConductor;
import com.denfop.api.heat.IHeatEmitter;
import com.denfop.api.heat.IHeatTile;
import com.denfop.api.heat.event.HeatTileLoadEvent;
import com.denfop.api.heat.event.HeatTileUnloadEvent;
import com.denfop.api.sytem.InfoTile;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.transport.tiles.TileEntityMultiCable;
import com.denfop.tiles.transport.types.HeatColdType;
import com.denfop.tiles.transport.types.ICableItem;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class TileEntityHeatColdPipes
extends TileEntityMultiCable
implements ICoolConductor,
IHeatConductor {
    public boolean addedToEnergyNet;
    protected HeatColdType cableType;
    int hashCodeSource;
    Map<Direction, ICoolTile> energyCoolConductorMap = new HashMap<Direction, ICoolTile>();
    List<InfoTile<ICoolTile>> validColdReceivers = new LinkedList<InfoTile<ICoolTile>>();
    Map<Direction, IHeatTile> energyHeatConductorMap = new HashMap<Direction, IHeatTile>();
    boolean updateConnect = false;
    List<InfoTile<IHeatTile>> validHeatReceivers = new LinkedList<InfoTile<IHeatTile>>();
    private boolean needUpdate;
    private long id;
    private InfoCable typeColdCable;
    private com.denfop.api.heat.InfoCable typeHeatCable;
    private final ConductorInfo conductorHeat;
    private final ConductorInfo conductorCool;

    public TileEntityHeatColdPipes(HeatColdType cableType, IMultiTileBlock tileBlock, BlockPos pos, BlockState state) {
        super(cableType, tileBlock, pos, state);
        this.cableType = cableType;
        this.connectivity = 0;
        this.addedToEnergyNet = false;
        this.conductorCool = new ConductorInfo(pos, this);
        this.conductorHeat = new ConductorInfo(pos, this);
    }

    @Override
    public ConductorInfo getHeatConductor() {
        return this.conductorHeat;
    }

    @Override
    public ConductorInfo getCoolConductor() {
        return this.conductorCool;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> info) {
        HeatColdType type = this.cableType;
        double capacity = type.capacity;
        info.add(Localization.translate("iu.transport.cold") + "-" + ModUtils.getString(capacity) + " \u00b0C");
        info.add(Localization.translate("iu.transport.heat") + ModUtils.getString(type.capacity1) + " \u00b0C");
    }

    @Override
    public ICableItem getCableItem() {
        return this.cableType;
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        this.cableType = HeatColdType.values[nbt.getByte("cableType") & 0xFF];
    }

    @Override
    public InfoCable getCoolCable() {
        return this.typeColdCable;
    }

    @Override
    public void setCoolCable(InfoCable cable) {
        this.typeColdCable = cable;
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void AddCoolTile(ICoolTile tile, Direction dir) {
        if (!this.getWorld().isClientSide) {
            if (!this.energyCoolConductorMap.containsKey(dir)) {
                this.energyCoolConductorMap.put(dir, tile);
                this.validColdReceivers.add(new InfoTile<ICoolTile>(tile, dir.getOpposite()));
            }
            this.updateConnect = true;
        }
    }

    @Override
    public void RemoveCoolTile(ICoolTile tile, Direction dir) {
        if (!this.getWorld().isClientSide) {
            this.energyCoolConductorMap.remove(dir);
            Iterator<InfoTile<ICoolTile>> iter = this.validColdReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<ICoolTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
            this.updateConnect = true;
        }
    }

    @Override
    public Map<Direction, ICoolTile> getCoolTiles() {
        return this.energyCoolConductorMap;
    }

    @Override
    public List<InfoTile<ICoolTile>> getCoolValidReceivers() {
        return this.validColdReceivers;
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        nbt.putByte("cableType", (byte)this.cableType.ordinal());
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide && !this.addedToEnergyNet) {
            this.energyCoolConductorMap.clear();
            this.validColdReceivers.clear();
            NeoForge.EVENT_BUS.post((Event)new HeatTileLoadEvent(this, this.getWorld()));
            NeoForge.EVENT_BUS.post((Event)new CoolTileLoadEvent(this, this.getWorld()));
            this.addedToEnergyNet = true;
            this.updateConnectivity();
        }
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        super.updateTileServer(var1, var2);
        NeoForge.EVENT_BUS.post((Event)new HeatTileUnloadEvent(this, this.getWorld()));
        NeoForge.EVENT_BUS.post((Event)new CoolTileUnloadEvent(this, this.getWorld()));
        this.needUpdate = true;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.needUpdate) {
            this.energyCoolConductorMap.clear();
            this.validColdReceivers.clear();
            this.validHeatReceivers.clear();
            this.energyHeatConductorMap.clear();
            NeoForge.EVENT_BUS.post((Event)new HeatTileLoadEvent(this, this.getWorld()));
            NeoForge.EVENT_BUS.post((Event)new CoolTileLoadEvent(this, this.getWorld()));
            this.needUpdate = false;
            this.updateConnectivity();
        }
        if (this.updateConnect) {
            this.updateConnect = false;
            this.updateConnectivity();
        }
    }

    @Override
    public void onUnloaded() {
        if (!this.getLevel().isClientSide && this.addedToEnergyNet) {
            NeoForge.EVENT_BUS.post((Event)new HeatTileUnloadEvent(this, this.getWorld()));
            NeoForge.EVENT_BUS.post((Event)new CoolTileUnloadEvent(this, this.getWorld()));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public void AddHeatTile(IHeatTile tile, Direction dir) {
        if (!this.getWorld().isClientSide) {
            if (!this.energyHeatConductorMap.containsKey(dir)) {
                this.energyHeatConductorMap.put(dir, tile);
                this.validHeatReceivers.add(new InfoTile<IHeatTile>(tile, dir.getOpposite()));
            }
            this.updateConnect = true;
        }
    }

    @Override
    public com.denfop.api.heat.InfoCable getHeatCable() {
        return this.typeHeatCable;
    }

    @Override
    public void setHeatCable(com.denfop.api.heat.InfoCable cable) {
        this.typeHeatCable = cable;
    }

    @Override
    public void RemoveHeatTile(IHeatTile tile, Direction dir) {
        if (!this.getWorld().isClientSide) {
            this.energyHeatConductorMap.remove(dir);
            Iterator<InfoTile<IHeatTile>> iter = this.validHeatReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<IHeatTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
            this.updateConnect = true;
        }
    }

    @Override
    public Map<Direction, IHeatTile> getHeatTiles() {
        return this.energyHeatConductorMap;
    }

    @Override
    public List<InfoTile<IHeatTile>> getHeatValidReceivers() {
        return this.validHeatReceivers;
    }

    @Override
    public void updateConnectivity() {
        Direction[] var4;
        byte newConnectivity = 0;
        for (Direction dir : var4 = Direction.values()) {
            newConnectivity = (byte)(newConnectivity << 1);
            ICoolTile tile = this.energyCoolConductorMap.get(dir);
            if (this.getBlackList().contains(dir)) continue;
            if (tile != null) {
                if ((!(tile instanceof ICoolAcceptor) || !((ICoolAcceptor)tile).acceptsCoolFrom(this, dir.getOpposite())) && (!(tile instanceof ICoolEmitter) || !((ICoolEmitter)tile).emitsCoolTo(this, dir.getOpposite())) || !this.canInteractWith()) continue;
                newConnectivity = (byte)(newConnectivity + 1);
                continue;
            }
            IHeatTile heatTile = this.energyHeatConductorMap.get(dir);
            if ((!(heatTile instanceof IHeatAcceptor) || !((IHeatAcceptor)heatTile).acceptsHeatFrom(this, dir.getOpposite())) && (!(heatTile instanceof IHeatEmitter) || !((IHeatEmitter)heatTile).emitsHeatTo(this, dir.getOpposite())) || !this.canInteractWith()) continue;
            newConnectivity = (byte)(newConnectivity + 1);
        }
        this.setConnectivity(newConnectivity);
        this.cableItem = this.cableType;
    }

    @Override
    public boolean wrenchCanRemove(Player player) {
        return false;
    }

    public boolean canInteractWith() {
        return true;
    }

    @Override
    public double getConductorBreakdownHeat() {
        return this.cableType.capacity1 + 1.0;
    }

    @Override
    public double getConductorBreakdownCold() {
        return this.cableType.capacity + 1.0;
    }

    @Override
    public void update_render() {
        if (!this.getWorld().isClientSide) {
            this.updateConnectivity();
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.cableType);
            EncoderHandler.encode(packet, this.connectivity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.cableType = HeatColdType.values[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.connectivity = (Byte)DecoderHandler.decode(customPacketBuffer);
            this.rerender();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean acceptsCoolFrom(ICoolEmitter var1, Direction var2) {
        return !this.getBlackList().contains(var2);
    }

    @Override
    public boolean emitsCoolTo(ICoolAcceptor var1, Direction var2) {
        return !this.getBlackList().contains(var2);
    }

    @Override
    public boolean acceptsHeatFrom(IHeatEmitter var1, Direction var2) {
        return !this.getBlackList().contains(var2);
    }

    @Override
    public boolean emitsHeatTo(IHeatAcceptor var1, Direction var2) {
        return !this.getBlackList().contains(var2);
    }

    @Override
    public BlockEntity getTile() {
        return this;
    }
}

