/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.panels.entity;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.IAdvEnergyNet;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.SunCoef;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.solar.EnumSolarType;
import com.denfop.api.solar.EnumTypeParts;
import com.denfop.api.solar.ISolarTile;
import com.denfop.api.solar.SolarEnergySystem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.ComponentMiniPanel;
import com.denfop.componets.ComponentPollution;
import com.denfop.componets.ComponentTimer;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerMiniPanels;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiMiniPanel;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotGlassMiniPanels;
import com.denfop.invslot.InvSlotOutputMiniPanels;
import com.denfop.invslot.InvSlotStorageMiniPanels;
import com.denfop.items.ItemCore;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.panels.entity.TileSolarPanel;
import com.denfop.utils.ModUtils;
import com.denfop.utils.Timer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TileEntityMiniPanels
extends TileEntityInventory
implements ISolarTile {
    public final InvSlotStorageMiniPanels invSlotStorage;
    public final InvSlotOutputMiniPanels invSlotOutput;
    public final ComponentTimer timer;
    public final InvSlot invSlotCore;
    public ComponentMiniPanel component;
    public InvSlotGlassMiniPanels invSlotGlass;
    public ComponentPollution pollution;
    public boolean canRain;
    public boolean hasSky;
    public Holder<Biome> biome;
    public boolean wetBiome;
    public boolean noSunWorld;
    public boolean rain;
    public boolean sunIsUp;
    public boolean skyIsVisible;
    public List<List<EnumState>> listStable = new ArrayList<List<EnumState>>(9);
    public double bonusGeneration;
    public TileSolarPanel.GenerationState activeState = TileSolarPanel.GenerationState.NONE;
    public double load;
    public double genDay = 0.0;
    public double genNight = 0.0;
    public double genDayNight = 0.0;
    public double generating;
    private int levelBlock;
    private SunCoef sunCoef;

    public TileEntityMiniPanels(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.minipanel, pos, state);
        this.component = this.addComponent(ComponentMiniPanel.asBasicSource(this, 0.0, 14));
        this.invSlotGlass = new InvSlotGlassMiniPanels(this);
        this.invSlotStorage = new InvSlotStorageMiniPanels(this);
        this.invSlotOutput = new InvSlotOutputMiniPanels(this);
        this.invSlotCore = new InvSlot(this, this, InvSlot.TypeItemSlot.INPUT, 2){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.getItem() instanceof ItemCore;
            }

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                SolarEnergySystem.system.calculateCores((TileEntityMiniPanels)this.base);
                SolarEnergySystem.system.recalculation((TileEntityMiniPanels)this.base, EnumTypeParts.GENERATION);
                return content;
            }
        };
        this.pollution = this.addComponent(new ComponentPollution(this));
        this.timer = this.addComponent(new ComponentTimer(this, new Timer(3, 0, 0), new Timer(2, 30, 0), new Timer(2, 0, 0)));
        this.pollution.setTimer(this.timer);
    }

    @Override
    public void addInformation(ItemStack itemStack, List<String> info) {
        info.add(Localization.translate("iu.minipanel.info"));
        info.add(Localization.translate("iu.minipanel.info2"));
        info.add(Localization.translate("iu.minipanel.info3"));
        if (this.getWorld() != null) {
            if (this.level.isDay()) {
                info.add(Localization.translate("supsolpans.iu.GenerationDay.tooltip") + " " + ModUtils.getString(this.generating) + " EF/t ");
                info.add(Localization.translate("supsolpans.iu.GenerationNight.tooltip") + " " + ModUtils.getString(this.genNight) + " EF/t ");
            } else {
                info.add(Localization.translate("supsolpans.iu.GenerationDay.tooltip") + " " + ModUtils.getString(this.genDay) + " EF/t ");
                info.add(Localization.translate("supsolpans.iu.GenerationNight.tooltip") + " " + ModUtils.getString(this.generating) + " EF/t ");
            }
            info.add(Localization.translate("iu.item.tooltip.Output") + " " + ModUtils.getString(this.component.getProdution()) + " EF/t ");
            info.add(Localization.translate("iu.item.tooltip.Capacity") + " " + ModUtils.getString(this.component.storage) + " EF ");
            info.add(Localization.translate("iu.tier") + ModUtils.getString(this.component.getSourceTier()));
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.minipanel;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public List<AABB> getAabbs(boolean forCollision) {
        return Collections.singletonList(new AABB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0));
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.generating = (Double)DecoderHandler.decode(customPacketBuffer);
            this.invSlotGlass.readFromNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), this.getNBTFromSlot(customPacketBuffer));
            this.invSlotStorage.readFromNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), this.getNBTFromSlot(customPacketBuffer));
            this.invSlotOutput.readFromNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), this.getNBTFromSlot(customPacketBuffer));
            this.bonusGeneration = (Double)DecoderHandler.decode(customPacketBuffer);
            this.rain = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.noSunWorld = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.hasSky = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.skyIsVisible = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.load = (Double)DecoderHandler.decode(customPacketBuffer);
            this.listStable = (List)DecoderHandler.decode(customPacketBuffer);
            this.sunIsUp = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.levelBlock = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.generating);
            EncoderHandler.encode(packet, this.invSlotGlass);
            EncoderHandler.encode(packet, this.invSlotStorage);
            EncoderHandler.encode(packet, this.invSlotOutput);
            EncoderHandler.encode(packet, this.bonusGeneration);
            EncoderHandler.encode(packet, this.rain);
            EncoderHandler.encode(packet, this.noSunWorld);
            EncoderHandler.encode(packet, this.hasSky);
            EncoderHandler.encode(packet, this.skyIsVisible);
            EncoderHandler.encode(packet, this.load);
            EncoderHandler.encode(packet, this.listStable);
            EncoderHandler.encode(packet, this.sunIsUp);
            EncoderHandler.encode(packet, this.levelBlock);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void setCapacity(double capacity) {
        this.component.setCapacity(capacity);
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.pollution, false);
            EncoderHandler.encode(packet, this.timer, false);
            EncoderHandler.encode(packet, this.component, false);
            EncoderHandler.encode(packet, this.invSlotGlass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.pollution.onNetworkUpdate(customPacketBuffer);
            this.timer.onNetworkUpdate(customPacketBuffer);
            this.component.onNetworkUpdate(customPacketBuffer);
            this.invSlotGlass.readFromNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), ((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), new CompoundTag()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void gainFuel() {
        double coefpollution = 1.0;
        switch (this.timer.getIndexWork()) {
            case -1: {
                coefpollution = 0.25;
                break;
            }
            case 1: {
                coefpollution = 0.75;
                break;
            }
            case 2: {
                coefpollution = 0.5;
            }
        }
        switch (this.activeState) {
            case DAY: {
                this.generating = (this.genDay + this.genDayNight) * (1.0 + this.bonusGeneration);
                break;
            }
            case NIGHT: {
                this.generating = (this.genNight + this.genDayNight) * (1.0 + this.bonusGeneration);
                break;
            }
            case RAINDAY: {
                this.generating = 0.65 * (this.genDay + this.genDayNight) * (1.0 + this.bonusGeneration);
                break;
            }
            case RAINNIGHT: {
                this.generating = 0.65 * (this.genNight + this.genDayNight) * (1.0 + this.bonusGeneration);
                break;
            }
            case NETHER: 
            case END: 
            case NONE: {
                this.generating = 0.0;
            }
        }
        this.generating *= coefpollution * this.experimental_generating();
    }

    private double experimental_generating() {
        if (this.sunCoef == null) {
            this.sunCoef = EnergyNetGlobal.instance.getSunCoefficient(this.level);
        }
        return this.sunCoef.getCoef();
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.level.isClientSide) {
            this.biome = this.level.getBiome(this.pos);
            this.canRain = ((Biome)this.biome.value()).getPrecipitationAt(this.pos) == Biome.Precipitation.RAIN || ((Biome)this.biome.value()).getModifiedClimateSettings().downfall() > 0.0f;
            this.hasSky = this.level.dimensionType().hasSkyLight();
            this.updateVisibility();
            SolarEnergySystem.system.calculateCores(this);
            SolarEnergySystem.system.recalculation(this, EnumTypeParts.GENERATION);
            SolarEnergySystem.system.recalculation(this, EnumTypeParts.OUTPUT);
            SolarEnergySystem.system.recalculation(this, EnumTypeParts.CAPACITY);
            IAdvEnergyNet advEnergyNet = EnergyNetGlobal.instance;
            this.sunCoef = advEnergyNet.getSunCoefficient(this.level);
        }
    }

    public void updateVisibility() {
        this.wetBiome = ((Biome)this.biome.value()).getModifiedClimateSettings().downfall() > 0.0f;
        this.noSunWorld = this.level.dimension() == Level.NETHER;
        this.rain = this.wetBiome && (this.level.isRaining() || this.level.isThundering());
        this.sunIsUp = this.level.isDay();
        boolean bl = this.skyIsVisible = this.level.canSeeSky(this.pos.above()) && this.level.getBlockState(this.pos.above()).getMapColor((BlockGetter)this.level, this.pos.above()) == MapColor.NONE && !this.noSunWorld;
        if (!this.skyIsVisible) {
            this.activeState = TileSolarPanel.GenerationState.NONE;
        }
        if (this.sunIsUp && this.skyIsVisible) {
            this.activeState = !this.rain ? TileSolarPanel.GenerationState.DAY : TileSolarPanel.GenerationState.RAINDAY;
        }
        if (!this.sunIsUp && this.skyIsVisible) {
            this.activeState = !this.rain ? TileSolarPanel.GenerationState.NIGHT : TileSolarPanel.GenerationState.RAINNIGHT;
        }
        if (this.level.dimension() == Level.END) {
            this.activeState = TileSolarPanel.GenerationState.END;
        }
        if (this.level.dimension() == Level.NETHER) {
            this.activeState = TileSolarPanel.GenerationState.NETHER;
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        return super.writeToNBT(nbt);
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getWorld().getGameTime() % 80L == 0L) {
            this.updateVisibility();
        }
        this.timer.setCanWork(!this.invSlotGlass.isEmpty());
        this.generating = 0.0;
        if (this.load >= 100.0) {
            return;
        }
        this.gainFuel();
        this.component.addEnergy(this.generating);
    }

    @Override
    public void setOutput(double output) {
        this.component.setProdution(output);
    }

    @Override
    public void setGeneration(EnumSolarType solarType, double generation) {
        switch (solarType) {
            case DAY: {
                this.genDay = generation;
                break;
            }
            case NIGHT: {
                this.genNight = generation;
                break;
            }
            case DAY_NIGHT: {
                this.genDayNight = generation;
            }
        }
    }

    @Override
    public List<ItemStack> getCapacityItems() {
        return new ArrayList<ItemStack>(this.invSlotStorage);
    }

    @Override
    public List<ItemStack> getOutputItems() {
        return new ArrayList<ItemStack>(this.invSlotOutput);
    }

    @Override
    public List<ItemStack> getGenerationItems() {
        return new ArrayList<ItemStack>(this.invSlotGlass);
    }

    @Override
    public void setBonus(EnumTypeParts typeBonus, double bonus) {
        switch (typeBonus) {
            case OUTPUT: {
                this.component.setBonusProdution(bonus);
                break;
            }
            case CAPACITY: {
                this.component.setBonusCapacity(bonus);
                break;
            }
            case GENERATION: {
                this.bonusGeneration = bonus;
            }
        }
    }

    @Override
    public double getBonus(EnumTypeParts typeBonus) {
        switch (typeBonus) {
            case OUTPUT: {
                return this.component.getBonusProdution();
            }
            case CAPACITY: {
                return this.component.getBonusCapacity();
            }
            case GENERATION: {
                return this.bonusGeneration;
            }
        }
        return 0.0;
    }

    @Override
    public void setLoad(double load) {
        this.load = load;
    }

    @Override
    public List<List<EnumState>> getStables() {
        return this.listStable;
    }

    @Override
    public void setStables(int index, List<EnumState> enumStateList) {
        if (index < this.listStable.size()) {
            this.listStable.set(index, enumStateList);
        } else {
            this.listStable.add(index, enumStateList);
        }
    }

    @Override
    public List<ItemStack> getCoresItems() {
        return new ArrayList<ItemStack>(this.invSlotCore);
    }

    @Override
    public int getCoreLevel() {
        return this.levelBlock;
    }

    @Override
    public void setCoreLevel(int level) {
        this.levelBlock = level;
    }

    public ContainerMiniPanels getGuiContainer(Player var1) {
        return new ContainerMiniPanels(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiMiniPanel((ContainerMiniPanels)menu);
    }

    public static enum EnumState {
        STABLE,
        UNSTABLE,
        NORMAL,
        EMPTY;

    }
}

