/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.generator.things.fluid;

import com.denfop.IUItem;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Fluids;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerWaterGenerator;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiWaterGenerator;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ParticleUtils;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class TileWaterGenerator
extends TileElectricMachine
implements IUpgradableBlock {
    public final InvSlotUpgrade upgradeSlot;
    public final InvSlotOutput outputSlot = new InvSlotOutput(this, 1);
    public final InvSlotFluid containerslot = new InvSlotFluidByList((TileEntityInventory)this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.OUTPUT, new Fluid[]{net.minecraft.world.level.material.Fluids.WATER});
    public final FluidTank fluidTank;
    protected final Fluids fluids = this.addComponent(new Fluids(this));
    private final float energycost;
    private double lastEnergy;

    public TileWaterGenerator(BlockPos pos, BlockState state) {
        super(10000.0, 1, 1, BlockBaseMachine3.watergenerator, pos, state);
        this.energycost = 40.0f;
        this.fluidTank = this.fluids.addTank("fluidTank", 20000, InvSlot.TypeItemSlot.OUTPUT, Fluids.fluidPredicate(new Fluid[]{net.minecraft.world.level.material.Fluids.WATER}));
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.25));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.25));
    }

    private static int applyModifier(int extra) {
        double ret = Math.round(14.0 + (double)extra);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.watergenerator;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        this.lastEnergy = nbt.getDouble("lastEnergy");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        nbt.putDouble("lastEnergy", this.lastEnergy);
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            this.setUpgradestat();
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (!(this.energy.getEnergy() <= 0.0) && this.fluidTank.getFluidAmount() < this.fluidTank.getCapacity()) {
            if (!this.getActive()) {
                this.setActive(true);
            }
            if (this.energy.getEnergy() >= (double)this.energycost) {
                this.attemptGeneration();
                if (this.level.getGameTime() % 40L == 0L) {
                    this.initiate(0);
                }
            } else if (this.level.getGameTime() % 40L == 0L) {
                this.initiate(2);
            }
            this.lastEnergy = this.energy.getEnergy();
        } else if (this.getActive()) {
            this.setActive(false);
        }
        if (!this.containerslot.isEmpty() && this.fluidTank.getFluidAmount() > 0) {
            this.containerslot.processFromTank((IFluidTank)this.fluidTank, this.outputSlot);
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setUpgradestat();
        }
        if (this.getActive() && this.level.getGameTime() % 5L == 0L) {
            ParticleUtils.spawnWaterGeneratorParticles(this.level, this.pos, this.level.random);
        }
    }

    public void attemptGeneration() {
        int k = (int)(this.energy.getEnergy() / (double)this.energycost);
        if (this.fluidTank.getFluidAmount() + 1 > this.fluidTank.getCapacity()) {
            return;
        }
        int m = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        this.fluidTank.fill(new FluidStack((Fluid)net.minecraft.world.level.material.Fluids.WATER, Math.min(m, k)), IFluidHandler.FluidAction.EXECUTE);
        this.energy.useEnergy(this.energycost * (float)Math.min(m, k));
    }

    public String getProgressAsString() {
        int p = Math.min((int)(this.energy.getEnergy() * 100.0 / (double)this.energycost), 100);
        return p + "%";
    }

    public ContainerWaterGenerator getGuiContainer(Player entityPlayer) {
        return new ContainerWaterGenerator(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiWaterGenerator((ContainerWaterGenerator)menu);
    }

    public void setUpgradestat() {
        this.energy.setSinkTier(TileWaterGenerator.applyModifier(this.upgradeSlot.extraTier));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.FluidExtract);
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }
}

