/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.blastfurnace.block;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.multiblock.IMainMultiBlock;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBlastFurnace;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Fluids;
import com.denfop.componets.HeatComponent;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerBlastFurnace;
import com.denfop.gui.GuiBlastFurnace;
import com.denfop.gui.GuiCore;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.items.resource.ItemIngots;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.register.InitMultiBlockSystem;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.mechanism.blastfurnace.api.IBlastHeat;
import com.denfop.tiles.mechanism.blastfurnace.api.IBlastInputFluid;
import com.denfop.tiles.mechanism.blastfurnace.api.IBlastMain;
import com.denfop.tiles.mechanism.blastfurnace.api.InvSlotBlastFurnace;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.apache.commons.lang3.mutable.MutableObject;
import org.joml.Vector3f;

public class TileBlastFurnaceMain
extends TileMultiBlockBase
implements IBlastMain,
IUpdatableTileEvent,
IAudioFixer {
    public final FluidTank tank;
    public final InvSlotOutput output1;
    public final InvSlotFluidByList fluidSlot;
    public final HeatComponent heat;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    public boolean load = false;
    public ItemStack outputStack = ItemStack.EMPTY;
    public InvSlotBlastFurnace invSlotBlastFurnace = new InvSlotBlastFurnace(this);
    public InvSlotOutput output = new InvSlotOutput(this, 1);
    public FluidTank tank1 = new FluidTank(12000);
    public IBlastHeat blastHeat;
    public IBlastInputFluid blastInputFluid;
    public List<Player> entityPlayerList;
    public double progress = 0.0;
    public int bar = 1;
    public EnumTypeAudio typeAudio = EnumTypeAudio.OFF;
    public EnumTypeAudio[] valuesAudio = EnumTypeAudio.values();
    private boolean sound = true;

    public TileBlastFurnaceMain(BlockPos pos, BlockState state) {
        super(InitMultiBlockSystem.blastFurnaceMultiBlock, BlockBlastFurnace.blast_furnace_main, pos, state);
        this.full = false;
        Fluids fluids = this.addComponent(new Fluids(this));
        this.tank = fluids.addTank("tank", 10000, InvSlot.TypeItemSlot.INPUT, Fluids.fluidPredicate((Fluid)FluidName.fluidsteam.getInstance().get()));
        this.entityPlayerList = new ArrayList<Player>();
        this.fluidSlot = new InvSlotFluidByList((TileEntityInventory)this, 1, (Fluid)net.minecraft.world.level.material.Fluids.WATER);
        this.output1 = new InvSlotOutput(this, 1);
        this.heat = this.addComponent(HeatComponent.asBasicSink(this, 1000.0));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.2));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.5));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.getActive() && this.level.getGameTime() % 5L == 0L) {
            RandomSource rand = RandomSource.create();
            Direction facing = this.getFacing();
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    double offsetX = 0.0;
                    double offsetZ = 0.0;
                    switch (facing) {
                        case NORTH: {
                            offsetZ = -0.3;
                            break;
                        }
                        case SOUTH: {
                            offsetZ = 0.3;
                            break;
                        }
                        case WEST: {
                            offsetX = -0.3;
                            break;
                        }
                        case EAST: {
                            offsetX = 0.3;
                        }
                    }
                    Level world = this.getLevel();
                    if (world == null) {
                        return;
                    }
                    Vec3 particlePos = new Vec3((double)this.pos.getX() + 0.5 + (double)dx + offsetX * -1.0 + rand.nextDouble() * 0.2 - 0.1, (double)this.pos.getY() + 1.2 + rand.nextDouble() * 0.2, (double)this.pos.getZ() + 0.5 + (double)dz + offsetZ * -1.0 + rand.nextDouble() * 0.2 - 0.1);
                    for (int i = 0; i < 1 + rand.nextInt(2); ++i) {
                        world.addParticle((ParticleOptions)ParticleTypes.FLAME, particlePos.x, particlePos.y, particlePos.z, 0.0, 0.05, 0.0);
                    }
                    for (int j = 0; j < 1 + rand.nextInt(2); ++j) {
                        world.addParticle((ParticleOptions)ParticleTypes.SMOKE, particlePos.x, particlePos.y + 0.3, particlePos.z, 0.0, 0.02, 0.0);
                    }
                    if (rand.nextInt(3) == 0) {
                        world.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 1.0f), (double)this.pos.getX() + 0.5 + (double)dx + offsetX * -1.0 + rand.nextDouble() * 0.4 - 0.2, (double)this.pos.getY() + 1.4 + rand.nextDouble() * 0.3, (double)this.pos.getZ() + 0.5 + (double)dz + offsetZ * -1.0 + rand.nextDouble() * 0.4 - 0.2, 1.0, (double)0.3f, (double)0.1f);
                    }
                    if (rand.nextInt(5) != 0) continue;
                    world.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)this.pos.getX() + 0.5 + (double)dx + offsetX * -4.0 + rand.nextDouble() * 0.4 - 0.2, (double)this.pos.getY() + 1.6, (double)this.pos.getZ() + 0.5 + (double)dz + offsetZ * -4.0 + rand.nextDouble() * 0.4 - 0.2, 0.0, 0.1, 0.0);
                }
            }
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBlastFurnace.blast_furnace_main;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.blastfurnace.getBlock(this.getTeBlock().getId());
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.full = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.tank1 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            this.progress = (Double)DecoderHandler.decode(customPacketBuffer);
            this.bar = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.sound = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.heat.buffer.storage = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.full);
            EncoderHandler.encode(packet, this.tank1);
            EncoderHandler.encode(packet, this.progress);
            EncoderHandler.encode(packet, this.bar);
            EncoderHandler.encode(packet, this.sound);
            EncoderHandler.encode(packet, this.heat.buffer.storage);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.blastfurnace.info1"));
        tooltip.add(Localization.translate("iu.blastfurnace.info3") + Localization.translate(new ItemStack(IUItem.blastfurnace.getItem(0)).getDescriptionId()));
        tooltip.add(Localization.translate("iu.blastfurnace.info4"));
        tooltip.add(Localization.translate("iu.blastfurnace.info5") + new ItemStack((ItemLike)IUItem.ForgeHammer.getItem()).getDisplayName().getString());
        tooltip.add(Localization.translate("iu.blastfurnace.info6"));
    }

    @Override
    public EnumTypeAudio getTypeAudio() {
        return this.typeAudio;
    }

    @Override
    public void setType(EnumTypeAudio type) {
        this.typeAudio = type;
    }

    @Override
    public boolean getEnable() {
        return this.sound;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.blast_furnace.getSoundEvent();
    }

    @Override
    public void initiate(int soundEvent) {
        if (this.getTypeAudio() == this.valuesAudio[soundEvent % this.valuesAudio.length]) {
            return;
        }
        this.setType(this.valuesAudio[soundEvent % this.valuesAudio.length]);
        if (!this.getEnable()) {
            return;
        }
        if (this.getSound() == null) {
            return;
        }
        if (soundEvent == 0) {
            this.getWorld().playSound(null, this.pos, this.getSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (soundEvent == 1) {
            new PacketStopSound(this.getWorld(), this.pos);
            this.getWorld().playSound(null, this.pos, EnumSound.InterruptOne.getSoundEvent(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            new PacketStopSound(this.getWorld(), this.pos);
        }
    }

    @Override
    public void updateAfterAssembly() {
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IBlastInputFluid.class);
        this.setInputFluid((IBlastInputFluid)this.getWorld().getBlockEntity(pos1.get(0)));
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IBlastHeat.class);
        this.setHeat((IBlastHeat)this.getWorld().getBlockEntity(pos1.get(0)));
    }

    @Override
    public void usingBeforeGUI() {
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            ItemStack content;
            new PacketUpdateFieldTile(this, "sound", this.sound);
            this.outputStack = this.invSlotBlastFurnace.isEmpty() ? ItemStack.EMPTY : ((content = this.invSlotBlastFurnace.get(0)).getItem().equals(Items.IRON_INGOT) ? IUItem.advIronIngot : (content.getItem() instanceof ItemIngots && IUItem.iuingot.getMeta((ItemIngots)content.getItem()) == 3 ? new ItemStack((ItemLike)IUItem.crafting_elements.getStack(480)) : new ItemStack((ItemLike)IUItem.crafting_elements.getStack(479), 1)));
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (!this.full) {
            if (this.getActive()) {
                this.setActive(false);
                this.initiate(2);
            }
            return;
        }
        MutableObject output1 = new MutableObject();
        if (this.fluidSlot.transferToTank((IFluidTank)this.tank1, (MutableObject<ItemStack>)output1, true) && (output1.getValue() == null || this.output1.canAdd((ItemStack)output1.getValue()))) {
            this.fluidSlot.transferToTank((IFluidTank)this.tank1, (MutableObject<ItemStack>)output1, false);
            if (output1.getValue() != null) {
                this.output1.add((ItemStack)output1.getValue());
            }
        }
        if (!this.invSlotBlastFurnace.isEmpty() && !this.outputStack.isEmpty() && this.output.canAdd(this.outputStack)) {
            double heat;
            int amount_stream = this.tank.getFluidAmount();
            if (this.heat.getEnergy() == this.heat.getCapacity()) {
                int bar1 = this.bar;
                if (amount_stream < bar1 * 2) {
                    bar1 = amount_stream / 2;
                }
                if (bar1 > 0) {
                    if (this.progress == 0.0) {
                        this.setActive(true);
                        this.initiate(0);
                    }
                    if (!this.getActive()) {
                        this.setActive(true);
                    }
                    this.progress += 1.0 + 0.25 * (double)(bar1 - 1);
                    this.tank.drain(Math.min(bar1 * 2, this.tank.getFluidAmount()), IFluidHandler.FluidAction.EXECUTE);
                    if (this.progress >= 3600.0 && this.output.add(this.outputStack)) {
                        this.progress = 0.0;
                        this.invSlotBlastFurnace.get(0).shrink(1);
                        this.setActive(false);
                        this.initiate(2);
                    }
                }
            }
            if ((heat = this.heat.getEnergy()) > 500.0 && this.tank.getFluidAmount() + 2 < this.tank.getCapacity()) {
                int add;
                int size = this.tank1.getFluidAmount();
                int size_stream = this.tank.getCapacity() - this.tank.getFluidAmount();
                int size1 = size / 5;
                if ((size1 = Math.min(size1, 10)) > 0 && (add = Math.min(size_stream / 2, size1)) > 0) {
                    this.tank.fill(new FluidStack((Fluid)FluidName.fluidsteam.getInstance().get(), add * 2), IFluidHandler.FluidAction.EXECUTE);
                    this.getInputFluid().getFluidTank().drain(add * 5, IFluidHandler.FluidAction.EXECUTE);
                }
            }
        } else if (this.getActive()) {
            this.setActive(false);
        }
        if (this.heat.getEnergy() > 0.0) {
            this.heat.useEnergy(1.0);
        }
    }

    @Override
    public IBlastHeat getHeat() {
        return this.blastHeat;
    }

    @Override
    public void setHeat(IBlastHeat blastHeat) {
        this.blastHeat = blastHeat;
        try {
            this.heat.onUnloaded();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.blastHeat != null) {
            this.heat.setParent((TileEntityInventory)((Object)blastHeat));
            this.heat.onLoaded();
        }
    }

    @Override
    public IBlastInputFluid getInputFluid() {
        return this.blastInputFluid;
    }

    @Override
    public void setInputFluid(IBlastInputFluid blastInputFluid) {
        this.blastInputFluid = blastInputFluid;
        if (this.blastInputFluid == null) {
            this.tank1 = new FluidTank(12000);
            new PacketUpdateFieldTile(this, "fluidtank1", false);
        } else {
            this.tank1 = this.blastInputFluid.getFluidTank();
            new PacketUpdateFieldTile(this, "fluidtank2", this.tank1);
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.sound = nbttagcompound.getBoolean("sound");
        this.bar = nbttagcompound.getInt("bar");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putBoolean("sound", this.sound);
        nbttagcompound.putInt("bar", this.bar);
        return nbttagcompound;
    }

    @Override
    public double getProgress() {
        return this.progress;
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
        switch ((int)i) {
            case 0: {
                this.bar = Math.min(this.bar + 1, 5);
                break;
            }
            case 1: {
                this.bar = Math.max(1, this.bar - 1);
                break;
            }
            case 10: {
                this.sound = !this.sound;
                new PacketUpdateFieldTile(this, "sound", this.sound);
                if (this.sound || this.getTypeAudio() != EnumTypeAudio.ON) break;
                this.setType(EnumTypeAudio.OFF);
                this.initiate(2);
            }
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("sound")) {
            try {
                this.sound = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (this.full && this.activate) {
            if (!this.getWorld().isClientSide && FluidHandlerFix.getFluidHandler(player.getItemInHand(hand)) != null) {
                return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.blastInputFluid.getFluid().getCapability(Capabilities.FluidHandler.BLOCK, side));
            }
            return super.onActivated(player, hand, side, vec3);
        }
        return super.onActivated(player, hand, side, vec3);
    }

    public ContainerBlastFurnace getGuiContainer(Player entityPlayer) {
        return new ContainerBlastFurnace(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player entityPlayer, ContainerBase<? extends IAdvInventory> b) {
        return new GuiBlastFurnace((ContainerBlastFurnace)b);
    }

    @Override
    public IMainMultiBlock getMain() {
        return this;
    }

    @Override
    public void setMainMultiElement(IMainMultiBlock main) {
    }

    @Override
    public boolean isMain() {
        return true;
    }

    @Override
    public void onNetworkEvent(int var1) {
    }

    @Override
    public int getBlockLevel() {
        return 0;
    }
}

