/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.primitive.EnumPrimitive;
import com.denfop.api.primitive.PrimitiveHandler;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.FluidHandlerRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IInputFluid;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InputFluid;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockSqueezer;
import com.denfop.componets.Fluids;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntitySqueezer
extends TileEntityInventory
implements IUpdateTick,
IHasRecipe {
    private static final List<AABB> aabbs = Collections.singletonList(new AABB(0.0, 0.0, -0.5, 1.0, 1.7, 1.5));
    private static final List<AABB> aabbs1 = Collections.singletonList(new AABB(-0.5, 0.0, 0.0, 1.5, 1.7, 1.0));
    public final InvSlotRecipes inputSlotA = new InvSlotRecipes(this, this, "squeezer", this){

        @Override
        public boolean accepts(ItemStack itemStack, int index) {
            if (index == 4) {
                return super.accepts(itemStack, 0);
            }
            return false;
        }
    };
    public final Fluids.InternalFluidTank fluidTank1;
    public final InvSlotFluidByList fluidSlot1;
    public final FluidHandlerRecipe fluid_handler;
    public short progress = 0;
    public Map<UUID, Double> data;
    private MachineRecipe output;

    public TileEntitySqueezer(BlockPos pos, BlockState state) {
        super(BlockSqueezer.squeezer, pos, state);
        Fluids fluids = this.addComponent(new Fluids(this));
        this.fluidTank1 = fluids.addTank("fluidTank1", 12000, InvSlot.TypeItemSlot.OUTPUT);
        this.fluid_handler = new FluidHandlerRecipe("squeezer", fluids);
        this.fluidTank1.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getOutputFluids(0)));
        this.fluidSlot1 = new InvSlotFluidByList((TileEntityInventory)this, 1, this.fluid_handler.getOutputFluids(0));
        this.fluidSlot1.setTypeFluidSlot(InvSlotFluid.TypeFluidSlot.OUTPUT);
        this.inputSlotA.setStackSizeLimit(1);
        Recipes.recipes.addInitRecipes(this);
    }

    public static void addRecipe(ItemStack container, FluidStack fluidStack) {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("squeezer", new BaseMachineRecipe(new Input(input.getInput(container)), new RecipeOutput(null, container)));
        Recipes.recipes.getRecipeFluid().addRecipe("squeezer", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(container), Collections.singletonList(fluidStack)));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        for (int i = 1; i < 5; ++i) {
            tooltip.add(Localization.translate("squeezer.info" + i));
        }
    }

    @Override
    public <T> T getCapability(@NotNull BlockCapability<T, Direction> cap, @Nullable Direction side) {
        if (cap == Capabilities.ItemHandler.BLOCK) {
            return null;
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void init() {
        TileEntitySqueezer.addRecipe(new ItemStack((ItemLike)IUItem.rawLatex.getItem()), new FluidStack((Fluid)FluidName.fluidrawlatex.getInstance().get(), 100));
        TileEntitySqueezer.addRecipe(new ItemStack((ItemLike)Items.WHEAT_SEEDS), new FluidStack((Fluid)FluidName.fluidseedoil.getInstance().get(), 10));
        TileEntitySqueezer.addRecipe(new ItemStack((ItemLike)Items.MELON_SEEDS), new FluidStack((Fluid)FluidName.fluidseedoil.getInstance().get(), 35));
        TileEntitySqueezer.addRecipe(new ItemStack((ItemLike)Items.PUMPKIN_SEEDS), new FluidStack((Fluid)FluidName.fluidseedoil.getInstance().get(), 35));
        TileEntitySqueezer.addRecipe(new ItemStack((ItemLike)IUItem.crops.getStack(0)), new FluidStack((Fluid)FluidName.fluidseedoil.getInstance().get(), 50));
    }

    @Override
    public List<AABB> getAabbs(boolean forCollision) {
        if (this.facing != 4 && this.facing != 5) {
            return aabbs1;
        }
        return Collections.singletonList(new AABB(0.0, 0.0, -0.5, 1.0, 1.7, 1.5));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.squeezer.getBlock();
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockSqueezer.squeezer;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getLevel().isClientSide) {
            this.inputSlotA.load();
            this.fluid_handler.load(this.inputSlotA.get(0));
            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
            new PacketUpdateFieldTile(this, "fluidtank", (Object)this.fluidTank1);
            this.data = PrimitiveHandler.getPlayersData(EnumPrimitive.SQUEEZER);
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.getShort("progress");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putShort("progress", this.progress);
        return nbttagcompound;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
        this.fluid_handler.setOutput(null);
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        this.fluid_handler.setOutput(null);
        return this.output;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.inputSlotA.readFromNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), ((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), new CompoundTag()));
            FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            if (fluidTank1 != null) {
                this.fluidTank1.readFromNBT((HolderLookup.Provider)customPacketBuffer.registryAccess(), fluidTank1.writeToNBT((HolderLookup.Provider)customPacketBuffer.registryAccess(), new CompoundTag()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("slot")) {
            try {
                this.inputSlotA.readFromNbt((HolderLookup.Provider)is.registryAccess(), ((InvSlot)DecoderHandler.decode(is)).writeToNbt((HolderLookup.Provider)is.registryAccess(), new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("fluidtank")) {
            try {
                FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(is);
                if (fluidTank1 != null) {
                    this.fluidTank1.readFromNBT((HolderLookup.Provider)is.registryAccess(), fluidTank1.writeToNBT((HolderLookup.Provider)is.registryAccess(), new CompoundTag()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot3")) {
            this.inputSlotA.set(0, ItemStack.EMPTY);
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.inputSlotA);
            EncoderHandler.encode(customPacketBuffer, (Object)this.fluidTank1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 hitX) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.level.isClientSide) {
            return true;
        }
        if (stack.getItem().equals(IUItem.treetap.getItem()) && !this.inputSlotA.isEmpty() && this.output != null && this.fluid_handler.output() != null && this.fluid_handler.canFillFluid()) {
            this.progress = (short)(this.progress + (short)(10 + (short)(this.data.getOrDefault(player.getUUID(), 0.0) / 2.5)));
            this.getCooldownTracker().setTick(8);
            this.setActive(String.valueOf(this.progress / 10));
            if (this.progress >= 150) {
                this.progress = 0;
                this.setActive("");
                if (!this.getWorld().isClientSide) {
                    PrimitiveHandler.addExperience(EnumPrimitive.SQUEEZER, 0.5, player.getUUID());
                }
                this.fluid_handler.fillFluid();
                this.inputSlotA.consume(0, this.output.getRecipe().input.getInputs().get(0).getAmount());
                if (!this.level.isClientSide) {
                    new PacketUpdateFieldTile(this, "slot3", this.inputSlotA);
                    new PacketUpdateFieldTile(this, "fluidtank", (Object)this.fluidTank1);
                }
            }
            return this.getWorld().isClientSide;
        }
        if (!stack.isEmpty() && this.inputSlotA.accepts(stack, 4)) {
            if (this.inputSlotA.get(0).isEmpty()) {
                ItemStack stack1 = stack.copy();
                stack1.setCount(1);
                this.inputSlotA.set(0, stack1);
                stack.shrink(1);
                if (!this.level.isClientSide) {
                    new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                }
                return true;
            }
        } else {
            if (!this.getWorld().isClientSide && player.getItemInHand(hand).getCapability(Capabilities.FluidHandler.ITEM, null) != null && this.fluidTank1.getFluidAmount() >= 1000) {
                ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.getComp(Fluids.class).getCapability(Capabilities.FluidHandler.BLOCK, side));
                if (!this.level.isClientSide) {
                    new PacketUpdateFieldTile(this, "fluidtank", (Object)this.fluidTank1);
                }
                return true;
            }
            if (!this.inputSlotA.isEmpty()) {
                if (!this.level.isClientSide) {
                    ModUtils.dropAsEntity(this.level, this.pos, this.inputSlotA.get(0));
                }
                this.inputSlotA.set(0, ItemStack.EMPTY);
                this.output = null;
                if (!this.level.isClientSide) {
                    new PacketUpdateFieldTile(this, "slot3", false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.fluid_handler.output() == null && !this.inputSlotA.isEmpty()) {
            this.fluid_handler.getOutput(this.inputSlotA.get(0));
        } else if (this.fluid_handler.output() != null && this.inputSlotA.isEmpty()) {
            this.fluid_handler.setOutput(null);
        }
    }
}

