/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.Energy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.componets.client.ComponentVisibleArea;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerSheepFarm;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiSheepFarm;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TileEntitySheepFarm
extends TileEntityInventory
implements IUpgradableBlock {
    public static final Map<DyeColor, ItemLike> ITEM_BY_DYE = (Map)Util.make((Object)Maps.newEnumMap(DyeColor.class), p_29841_ -> {
        p_29841_.put(DyeColor.WHITE, Blocks.WHITE_WOOL);
        p_29841_.put(DyeColor.ORANGE, Blocks.ORANGE_WOOL);
        p_29841_.put(DyeColor.MAGENTA, Blocks.MAGENTA_WOOL);
        p_29841_.put(DyeColor.LIGHT_BLUE, Blocks.LIGHT_BLUE_WOOL);
        p_29841_.put(DyeColor.YELLOW, Blocks.YELLOW_WOOL);
        p_29841_.put(DyeColor.LIME, Blocks.LIME_WOOL);
        p_29841_.put(DyeColor.PINK, Blocks.PINK_WOOL);
        p_29841_.put(DyeColor.GRAY, Blocks.GRAY_WOOL);
        p_29841_.put(DyeColor.LIGHT_GRAY, Blocks.LIGHT_GRAY_WOOL);
        p_29841_.put(DyeColor.CYAN, Blocks.CYAN_WOOL);
        p_29841_.put(DyeColor.PURPLE, Blocks.PURPLE_WOOL);
        p_29841_.put(DyeColor.BLUE, Blocks.BLUE_WOOL);
        p_29841_.put(DyeColor.BROWN, Blocks.BROWN_WOOL);
        p_29841_.put(DyeColor.GREEN, Blocks.GREEN_WOOL);
        p_29841_.put(DyeColor.RED, Blocks.RED_WOOL);
        p_29841_.put(DyeColor.BLACK, Blocks.BLACK_WOOL);
    });
    private static final int RADIUS = 4;
    private static final int MAX_SHEEP = 20;
    public final InvSlot slotSeeds;
    public final InvSlotOutput output;
    public final Energy energy;
    public final InvSlotUpgrade upgradeSlot;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    private final ComponentUpgradeSlots componentUpgrade;
    private final ComponentVisibleArea visible;
    AABB searchArea;
    List<LevelChunk> chunks;

    public TileEntitySheepFarm(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.sheep_farm, pos, state);
        this.searchArea = new AABB(ModUtils.getVecFromVec3i((Vec3i)this.pos.offset(-4, -4, -4)), ModUtils.getVecFromVec3i((Vec3i)this.pos.offset(5, 5, 5)));
        this.chunks = new ArrayList<LevelChunk>();
        this.slotSeeds = new InvSlot(this, this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.getItem() == Items.WHEAT;
            }
        };
        this.output = new InvSlotOutput(this, 9);
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 1024.0, 4));
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
        this.visible = this.addComponent(new ComponentVisibleArea(this));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }

    public ContainerSheepFarm getGuiContainer(Player var1) {
        return new ContainerSheepFarm(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiSheepFarm((ContainerSheepFarm)menu);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.sheep_farm;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.visible.aabb = this.searchArea;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.sheep_farm.info"));
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getWorld().getGameTime() % 20L == 0L && this.energy.canUseEnergy(50.0)) {
            this.energy.useEnergy(50.0);
            List sheepList = this.level.getEntitiesOfClass(Sheep.class, this.searchArea);
            this.shearSheep(sheepList);
            if (sheepList.size() < 20) {
                this.breedSheep(sheepList);
            }
            if (sheepList.size() > 20) {
                this.killExcessSheep(sheepList);
            }
        }
    }

    private void killExcessSheep(List<Sheep> sheepList) {
        for (int i = sheepList.size() - 1; i >= 20; --i) {
            Sheep sheep = sheepList.get(i);
            sheep.discard();
            this.output.add(new ItemStack((ItemLike)Items.MUTTON, 1));
        }
    }

    private void breedSheep(List<Sheep> sheepList) {
        block0: for (int i = 0; i < sheepList.size(); ++i) {
            for (int j = i + 1; j < sheepList.size(); ++j) {
                Sheep sheep1 = sheepList.get(i);
                Sheep sheep2 = sheepList.get(j);
                if (sheep1.getAge() != 0 || sheep2.getAge() != 0 || sheep1.isInLove() || sheep2.isInLove() || this.slotSeeds.isEmpty() || this.slotSeeds.get(0).getCount() < 2) continue;
                sheep1.setInLove(null);
                sheep2.setInLove(null);
                this.slotSeeds.get(0).shrink(2);
                continue block0;
            }
        }
    }

    private void shearSheep(List<Sheep> sheepList) {
        for (Sheep sheep : sheepList) {
            if (sheep.isSheared() || !sheep.isAlive()) continue;
            sheep.setSheared(true);
            DyeColor color = sheep.getColor();
            int count = this.level.random.nextInt(2) + 1;
            this.output.add(new ItemStack(ITEM_BY_DYE.get(color), count));
        }
    }
}

