/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.FluidHandlerRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IInputFluid;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InputFluid;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockRefractoryFurnace;
import com.denfop.componets.Fluids;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityRefractoryFurnace
extends TileEntityInventory
implements IUpdateTick,
IHasRecipe {
    public final InvSlotRecipes inputSlotA = new InvSlotRecipes((TileEntityInventory)this, "refractory_furnace", (IUpdateTick)this);
    public final Fluids.InternalFluidTank fluidTank1;
    public final InvSlotFluidByList fluidSlot1;
    public final FluidHandlerRecipe fluid_handler;
    public short progress = 0;
    private MachineRecipe output;
    private boolean work;

    public TileEntityRefractoryFurnace(BlockPos pos, BlockState state) {
        super(BlockRefractoryFurnace.refractory_furnace, pos, state);
        Fluids fluids = this.addComponent(new Fluids(this));
        this.fluidTank1 = fluids.addTank("fluidTank1", 1728, InvSlot.TypeItemSlot.OUTPUT);
        this.fluid_handler = new FluidHandlerRecipe("refractory_furnace", fluids);
        this.fluidTank1.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getOutputFluids(0)));
        this.fluidSlot1 = new InvSlotFluidByList((TileEntityInventory)this, 1, this.fluid_handler.getOutputFluids(0));
        this.fluidSlot1.setTypeFluidSlot(InvSlotFluid.TypeFluidSlot.OUTPUT);
        this.inputSlotA.setStackSizeLimit(1);
        Recipes.recipes.addInitRecipes(this);
    }

    public static void addRecipe(ItemStack container, FluidStack fluidStack) {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("refractory_furnace", new BaseMachineRecipe(new Input(input.getInput(container)), new RecipeOutput(null, container)));
        Recipes.recipes.getRecipeFluid().addRecipe("refractory_furnace", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(container), Collections.singletonList(fluidStack)));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        for (int i = 1; i < 5; ++i) {
            tooltip.add(Localization.translate("refractory_furnace.info" + i));
        }
    }

    @Override
    public <T> T getCapability(@NotNull BlockCapability<T, Direction> cap, @Nullable Direction side) {
        if (cap == Capabilities.ItemHandler.BLOCK) {
            return null;
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void init() {
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(0)), new FluidStack((Fluid)FluidName.fluidmoltenmikhail.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(1)), new FluidStack((Fluid)FluidName.fluidmoltenaluminium.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(2)), new FluidStack((Fluid)FluidName.fluidmoltenvanadium.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(3)), new FluidStack((Fluid)FluidName.fluidmoltentungsten.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(6)), new FluidStack((Fluid)FluidName.fluidmoltencobalt.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(7)), new FluidStack((Fluid)FluidName.fluidmoltenmagnesium.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(8)), new FluidStack((Fluid)FluidName.fluidmoltennickel.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(9)), new FluidStack((Fluid)FluidName.fluidmoltenplatinum.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(10)), new FluidStack((Fluid)FluidName.fluidmoltentitanium.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(11)), new FluidStack((Fluid)FluidName.fluidmoltenchromium.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(12)), new FluidStack((Fluid)FluidName.fluidmoltenspinel.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(14)), new FluidStack((Fluid)FluidName.fluidmoltensilver.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(15)), new FluidStack((Fluid)FluidName.fluidmoltenzinc.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(16)), new FluidStack((Fluid)FluidName.fluidmoltenmanganese.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(17)), new FluidStack((Fluid)FluidName.fluidmolteniridium.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(18)), new FluidStack((Fluid)FluidName.fluidmoltengermanium.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(19)), new FluidStack((Fluid)FluidName.fluidmoltencopper.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(20)), new FluidStack((Fluid)FluidName.fluidmoltengold.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(21)), new FluidStack((Fluid)FluidName.fluidmolteniron.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(22)), new FluidStack((Fluid)FluidName.fluidmoltenlead.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(23)), new FluidStack((Fluid)FluidName.fluidmoltentin.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(25)), new FluidStack((Fluid)FluidName.fluidmoltenosmium.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(26)), new FluidStack((Fluid)FluidName.fluidmoltentantalum.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(27)), new FluidStack((Fluid)FluidName.fluidmoltencadmium.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(28)), new FluidStack((Fluid)FluidName.fluidmoltenarsenic.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(29)), new FluidStack((Fluid)FluidName.fluidmoltenbarium.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(30)), new FluidStack((Fluid)FluidName.fluidmoltenbismuth.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(31)), new FluidStack((Fluid)FluidName.fluidmoltengadolinium.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(32)), new FluidStack((Fluid)FluidName.fluidmoltengallium.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(33)), new FluidStack((Fluid)FluidName.fluidmoltenhafnium.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(34)), new FluidStack((Fluid)FluidName.fluidmoltenyttrium.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(35)), new FluidStack((Fluid)FluidName.fluidmoltenmolybdenum.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(36)), new FluidStack((Fluid)FluidName.fluidmoltenneodymium.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(37)), new FluidStack((Fluid)FluidName.fluidmoltenniobium.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(38)), new FluidStack((Fluid)FluidName.fluidmoltenpalladium.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(39)), new FluidStack((Fluid)FluidName.fluidmoltenpolonium.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(40)), new FluidStack((Fluid)FluidName.fluidmoltenstrontium.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(41)), new FluidStack((Fluid)FluidName.fluidmoltenthallium.getInstance().get(), 144));
        TileEntityRefractoryFurnace.addRecipe(new ItemStack((ItemLike)IUItem.crushed.getStack(42)), new FluidStack((Fluid)FluidName.fluidmoltenzirconium.getInstance().get(), 144));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.refractoryFurnace.getBlock();
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockRefractoryFurnace.refractory_furnace;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            this.inputSlotA.load();
            this.fluid_handler.load(this.inputSlotA.get(0));
            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
            new PacketUpdateFieldTile(this, "fluidtank", (Object)this.fluidTank1);
            BlockState blockState = this.level.getBlockState(this.pos.below());
            this.work = !blockState.isAir() ? blockState.getFluidState().is((Fluid)net.minecraft.world.level.material.Fluids.LAVA) : false;
        }
    }

    @Override
    public void onNeighborChange(BlockState neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        if (this.work) {
            if (this.pos.below().distSqr((Vec3i)neighborPos) == 0.0) {
                BlockState blockState = this.level.getBlockState(this.pos.below());
                this.work = !blockState.isAir() ? blockState.getFluidState().is((Fluid)net.minecraft.world.level.material.Fluids.LAVA) : false;
            }
        } else if (this.pos.below().distSqr((Vec3i)neighborPos) == 0.0) {
            BlockState blockState = this.level.getBlockState(this.pos.below());
            this.work = !blockState.isAir() ? blockState.getFluidState().is((Fluid)net.minecraft.world.level.material.Fluids.LAVA) : false;
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.getShort("progress");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putShort("progress", this.progress);
        return nbttagcompound;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
        this.fluid_handler.setOutput(null);
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        this.fluid_handler.setOutput(null);
        return this.output;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            InvSlot invSlot = (InvSlot)DecoderHandler.decode(customPacketBuffer);
            this.inputSlotA.read(invSlot);
            FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            if (fluidTank1 != null) {
                this.fluidTank1.readFromNBT((HolderLookup.Provider)customPacketBuffer.registryAccess(), fluidTank1.writeToNBT((HolderLookup.Provider)customPacketBuffer.registryAccess(), new CompoundTag()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("slot")) {
            try {
                InvSlot invSlot = (InvSlot)DecoderHandler.decode(is);
                this.inputSlotA.read(invSlot);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("fluidtank")) {
            try {
                FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(is);
                if (fluidTank1 != null) {
                    this.fluidTank1.readFromNBT((HolderLookup.Provider)is.registryAccess(), fluidTank1.writeToNBT((HolderLookup.Provider)is.registryAccess(), new CompoundTag()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot3")) {
            this.inputSlotA.set(0, ItemStack.EMPTY);
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.inputSlotA);
            EncoderHandler.encode(customPacketBuffer, (Object)this.fluidTank1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.level.isClientSide) {
            return true;
        }
        if (!stack.isEmpty() && this.inputSlotA.accepts(stack, 0)) {
            if (this.inputSlotA.get(0).isEmpty()) {
                ItemStack stack1 = stack.copy();
                stack1.setCount(1);
                this.inputSlotA.set(0, stack1);
                stack.shrink(1);
                if (!this.level.isClientSide) {
                    new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                }
                return true;
            }
        } else {
            if (!this.getWorld().isClientSide && FluidHandlerFix.getFluidHandler(player.getItemInHand(hand)) != null && this.fluidTank1.getFluidAmount() >= 1000) {
                ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.getComp(Fluids.class).getCapability(Capabilities.FluidHandler.BLOCK, side));
                if (!this.level.isClientSide) {
                    new PacketUpdateFieldTile(this, "fluidtank", (Object)this.fluidTank1);
                }
                return true;
            }
            if (!this.inputSlotA.isEmpty()) {
                if (!this.level.isClientSide) {
                    ModUtils.dropAsEntity(this.level, this.pos, this.inputSlotA.get(0));
                }
                this.inputSlotA.set(0, ItemStack.EMPTY);
                this.output = null;
                this.setActive(false);
                if (!this.level.isClientSide) {
                    new PacketUpdateFieldTile(this, "slot3", false);
                }
                return true;
            }
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.fluid_handler.output() == null && !this.inputSlotA.isEmpty()) {
            this.fluid_handler.getOutput(this.inputSlotA.get(0));
        } else if (this.fluid_handler.output() != null && this.inputSlotA.isEmpty()) {
            this.fluid_handler.setOutput(null);
        }
        if (this.work) {
            if (!this.inputSlotA.isEmpty() && this.output != null && this.fluid_handler.output() != null && this.fluid_handler.canFillFluid()) {
                this.progress = (short)(this.progress + 2);
                this.setActive(true);
                if (this.progress >= 150) {
                    this.progress = 0;
                    this.setActive("");
                    this.fluid_handler.fillFluid();
                    this.inputSlotA.consume(0, this.output.getRecipe().input.getInputs().get(0).getAmount());
                    if (!this.level.isClientSide) {
                        new PacketUpdateFieldTile(this, "slot3", this.inputSlotA);
                        new PacketUpdateFieldTile(this, "fluidtank", (Object)this.fluidTank1);
                    }
                }
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
    }
}

