/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerPalletGenerator;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiPalletGenerator;
import com.denfop.invslot.InvSlot;
import com.denfop.tiles.base.TileElectricMachine;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TileEntityPalletGenerator
extends TileElectricMachine {
    public static Map<ItemStack, Double> integerMap = new HashMap<ItemStack, Double>();
    public final InvSlot slot;
    public final ComponentBaseEnergy rad;
    public boolean update = true;
    public double generate = 0.0;

    public TileEntityPalletGenerator(BlockPos pos, BlockState state) {
        super(0.0, 14, 0, BlockBaseMachine3.pallet_generator, pos, state);
        this.energy = this.addComponent(Energy.asBasicSource(this, 5000000.0, this.tier));
        this.rad = this.addComponent(ComponentBaseEnergy.asBasicSink(EnergyType.RADIATION, this, 50000.0));
        this.slot = new InvSlot(this, this, InvSlot.TypeItemSlot.INPUT, 6){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                for (Map.Entry<ItemStack, Double> entry : integerMap.entrySet()) {
                    if (!entry.getKey().is(stack.getItem())) continue;
                    return true;
                }
                return false;
            }

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                TileEntityPalletGenerator tile = (TileEntityPalletGenerator)this.base;
                tile.update = true;
                return content;
            }
        };
        this.slot.setStackSizeLimit(1);
    }

    public static void init() {
        integerMap.put(new ItemStack((ItemLike)IUItem.nuclear_res.getStack(8)), 1.1);
        integerMap.put(new ItemStack((ItemLike)IUItem.pellets.getStack(8)), 1.2);
        integerMap.put(new ItemStack((ItemLike)IUItem.nuclear_res.getStack(9)), 1.3);
        integerMap.put(new ItemStack((ItemLike)IUItem.pellets.getStack(4)), 1.6);
        integerMap.put(new ItemStack((ItemLike)IUItem.pellets.getStack(0)), 1.75);
        integerMap.put(new ItemStack((ItemLike)IUItem.pellets.getStack(1)), 1.9);
        integerMap.put(new ItemStack((ItemLike)IUItem.pellets.getStack(9)), 2.05);
        integerMap.put(new ItemStack((ItemLike)IUItem.pellets.getStack(2)), 2.2);
        integerMap.put(new ItemStack((ItemLike)IUItem.pellets.getStack(3)), 2.45);
        integerMap.put(new ItemStack((ItemLike)IUItem.pellets.getStack(6)), 2.7);
        integerMap.put(new ItemStack((ItemLike)IUItem.pellets.getStack(7)), 2.85);
        integerMap.put(new ItemStack((ItemLike)IUItem.pellets.getStack(10)), 3.162);
        integerMap.put(new ItemStack((ItemLike)IUItem.pellets.getStack(5)), 3.32);
        integerMap.put(new ItemStack((ItemLike)IUItem.pellets.getStack(11)), 3.7);
        integerMap.put(new ItemStack((ItemLike)IUItem.pellets.getStack(12)), 4.0);
    }

    public ContainerPalletGenerator getGuiContainer(Player var1) {
        return new ContainerPalletGenerator(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiPalletGenerator((ContainerPalletGenerator)menu);
    }

    @Override
    public void updateEntityServer() {
        double num;
        super.updateEntityServer();
        if (this.update) {
            this.update = false;
            num = 0.0;
            this.generate = 0.0;
            for (ItemStack stack : this.slot) {
                for (Map.Entry<ItemStack, Double> entry : integerMap.entrySet()) {
                    if (!entry.getKey().is(stack.getItem())) continue;
                    if (num == 0.0) {
                        num = entry.getValue();
                        continue;
                    }
                    num *= entry.getValue().doubleValue();
                }
            }
            if (num != 0.0) {
                this.generate = 20000.0 / Math.ceil(num);
            }
        }
        if (this.generate != 0.0) {
            num = this.energy.getFreeEnergy() / 50.0;
            if (num >= 1.0) {
                double num1 = this.rad.getEnergy() / this.generate;
                if (num1 >= 1.0) {
                    double num2 = Math.min(Math.min(num, num1), 10.0);
                    this.rad.useEnergy(num2 * this.generate);
                    this.energy.addEnergy(num2 * 50.0);
                    this.setActive(true);
                } else {
                    this.setActive(false);
                }
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.pallet_generator;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }
}

